/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.util.resource.Location;
import org.zkoss.zk.ui.Component;

public class BinderUtil {
    static ThreadLocal<LiteStack<UtilContext>> _ctxStack = new ThreadLocal();

    public static void markHandling(Component comp, Binder binder) {
        comp.setAttribute("$BINDER$", (Object)binder);
    }

    public static void unmarkHandling(Component comp) {
        comp.removeAttribute("$BINDER$");
    }

    public static boolean isHandling(Component comp) {
        return comp.hasAttribute("$BINDER$");
    }

    public static Binder getBinder(Component comp) {
        return (Binder)comp.getAttribute("$BINDER$");
    }

    public static Binder getBinder(Component comp, boolean recurse) {
        return (Binder)comp.getAttribute("$BINDER$", recurse);
    }

    public static UtilContext pushContext() {
        LiteStack<UtilContext> stack = _ctxStack.get();
        if (stack == null) {
            stack = new LiteStack(3);
            _ctxStack.set(stack);
        }
        UtilContext ctx = new UtilContext();
        stack.push(ctx);
        return ctx;
    }

    public static boolean hasContext() {
        LiteStack<UtilContext> stack = _ctxStack.get();
        if (stack == null) {
            return false;
        }
        return !stack.empty();
    }

    public static UtilContext getContext() {
        LiteStack<UtilContext> stack = _ctxStack.get();
        if (stack == null) {
            return null;
        }
        return stack.peek();
    }

    public static void popContext() {
        LiteStack<UtilContext> stack = _ctxStack.get();
        if (stack != null) {
            stack.pop();
            if (stack.empty()) {
                _ctxStack.set(null);
            }
        } else {
            throw new IllegalStateException("nothing to popup");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LiteStack<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<T> _stack;

        public LiteStack() {
            this(3);
        }

        public LiteStack(int initialCapacity) {
            this._stack = new ArrayList<T>(initialCapacity);
        }

        public void push(T element) {
            this._stack.add(element);
        }

        public int size() {
            return this._stack.size();
        }

        public boolean empty() {
            return this._stack.size() == 0;
        }

        public T peek() {
            return this._stack.get(this._stack.size() - 1);
        }

        public T pop() {
            return this._stack.remove(this._stack.size() - 1);
        }
    }

    public static class UtilContext {
        boolean _ignoreAccessCreationWarn;
        Location _location;

        public boolean isIgnoreAccessCreationWarn() {
            return this._ignoreAccessCreationWarn;
        }

        public void setIgnoreAccessCreationWarn(boolean ignoreAccessCreationWarn) {
            this._ignoreAccessCreationWarn = ignoreAccessCreationWarn;
        }

        public void setCurrentLocation(Location location) {
            this._location = location;
        }

        public Location getCurrentLocation() {
            return this._location;
        }

        public String getCurrentLocationMessage() {
            return MiscUtil.formatLocationMessage(null, this._location);
        }
    }
}

