/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.tracker.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.zkoss.bind.impl.WeakIdentityMap;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.ChildrenBinding;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.sys.tracker.TrackerNode;
import org.zkoss.bind.tracker.impl.TrackerNodeImpl;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.util.IdentityHashSet;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerImpl
implements Tracker,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;
    private Map<Component, Map<Object, TrackerNode>> _compMap = new LinkedHashMap<Component, Map<Object, TrackerNode>>();
    private Map<Object, Set<TrackerNode>> _nullMap = new HashMap<Object, Set<TrackerNode>>();
    private transient Map<Object, Set<TrackerNode>> _beanMap = new WeakIdentityMap<Object, Set<TrackerNode>>();
    private transient EqualBeansMap _equalBeansMap = new EqualBeansMap();

    @Override
    public void addTracking(Component comp, String[] series, Binding binding) {
        if (!(binding instanceof LoadBinding)) {
            return;
        }
        TrackerNodeImpl node = (TrackerNodeImpl)this.getOrCreateTrackerNode(comp, series);
        node.addBinding(binding);
    }

    @Override
    public void addDependsOn(Component srcComp, String[] srcSeries, Binding srcBinding, Component dependsOnComp, String[] dependsOnSeries) {
        if (!(srcBinding instanceof LoadBinding)) {
            return;
        }
        if (dependsOnComp == null) {
            dependsOnComp = srcComp;
        }
        TrackerNodeImpl dependsOnNode = (TrackerNodeImpl)this.getOrCreateTrackerNode(dependsOnComp, dependsOnSeries);
        TrackerNode srcnode = this.getOrCreateTrackerNode(srcComp, srcSeries);
        dependsOnNode.addAssociate(srcnode);
    }

    private TrackerNode getOrCreateTrackerNode(Component comp, String[] series) {
        Map<Object, TrackerNode> nodes = this._compMap.get(comp);
        if (nodes == null) {
            nodes = new HashMap<Object, TrackerNode>(4);
            this._compMap.put(comp, nodes);
        }
        TrackerNode parentNode = null;
        for (String script : series) {
            TrackerNode node = null;
            if (parentNode == null) {
                node = nodes.get(script);
                if (node == null) {
                    node = new TrackerNodeImpl(script);
                    nodes.put(script, node);
                }
            } else {
                node = parentNode.getDependent(script);
                if (node == null) {
                    node = new TrackerNodeImpl(script);
                }
                parentNode.addDependent(script, node);
            }
            parentNode = node;
        }
        return parentNode;
    }

    @Override
    public void removeTrackings(Component comp) {
        Map<Object, TrackerNode> nodesMap = this._compMap.remove(comp);
        if (nodesMap != null) {
            HashSet<TrackerNode> removed = new HashSet<TrackerNode>();
            Collection<TrackerNode> nodes = nodesMap.values();
            for (TrackerNode node : nodes) {
                removed.add(node);
                removed.addAll(node.getDependents());
            }
            this.removeAllFromBeanMap(removed);
            this.removeNodes(this._nullMap.values(), removed);
        }
    }

    private void getLoadBindingsPerProperty(Collection<TrackerNode> nodes, String prop, Set<LoadBinding> bindings, Set<Object> kidbases, Set<TrackerNode> visited) {
        if (".".equals(prop)) {
            for (TrackerNode node : nodes) {
                this.getLoadBindings0(node, bindings, kidbases, visited);
            }
        } else if ("*".equals(prop)) {
            for (TrackerNode node : nodes) {
                Set<TrackerNode> kids = node.getDirectDependents();
                this.getNodesLoadBindings(kids, bindings, kidbases, visited);
            }
        } else {
            for (TrackerNode node : nodes) {
                TrackerNode kid = node.getDependent(prop);
                if (kid == null) continue;
                this.getLoadBindings0(kid, bindings, kidbases, visited);
            }
        }
    }

    @Override
    public Set<LoadBinding> getLoadBindings(Object base, String prop) {
        HashSet<LoadBinding> bindings = new HashSet<LoadBinding>();
        HashSet<TrackerNode> visited = new HashSet<TrackerNode>();
        this.collectLoadBindings(base, prop, bindings, visited);
        return bindings;
    }

    private void collectLoadBindings(Object base, String prop, Set<LoadBinding> bindings, Set<TrackerNode> visited) {
        HashSet<Object> kidbases = new HashSet<Object>();
        if (base != null) {
            if ("*".equals(base)) {
                Collection<Map<Object, TrackerNode>> nodesMaps = this._compMap.values();
                if (nodesMaps != null) {
                    for (Map<Object, TrackerNode> nodesMap : nodesMaps) {
                        Collection<TrackerNode> nodes = nodesMap.values();
                        if (nodes == null) continue;
                        this.getLoadBindingsPerProperty(nodes, prop, bindings, kidbases, visited);
                    }
                }
            } else {
                Set<TrackerNode> nodes = this.getAllTrackerNodesByBean(base);
                if (nodes != null && !nodes.isEmpty()) {
                    this.getLoadBindingsPerProperty(nodes, prop, bindings, kidbases, visited);
                }
            }
        } else if ("*".equals(prop)) {
            for (Set<TrackerNode> set : this._nullMap.values()) {
                this.getNodesLoadBindings(set, bindings, kidbases, visited);
            }
        } else {
            Set<TrackerNode> basenodes = this._nullMap.get(prop);
            this.getNodesLoadBindings(basenodes, bindings, kidbases, visited);
        }
        for (Set<TrackerNode> set : kidbases) {
            this.collectLoadBindings(set, "*", bindings, visited);
        }
    }

    @Override
    public void tieValue(Object comp, Object base, Object script, Object propName, Object value) {
        block9: {
            block8: {
                TrackerNode node;
                if (base != null) break block8;
                Map<Object, TrackerNode> bindingNodes = this._compMap.get(comp);
                if (bindingNodes == null || (node = bindingNodes.get(script)) == null) break block9;
                if (value != null) {
                    this.addBeanMap(node, value);
                } else {
                    this.removeAllBeanMap(node);
                    this.addNullMap(node);
                }
                break block9;
            }
            Set<TrackerNode> baseNodes = this.getAllTrackerNodesByBean(base);
            if (baseNodes != null) {
                LinkedHashSet<TrackerNode> propNodes = new LinkedHashSet<TrackerNode>();
                for (TrackerNode baseNode : baseNodes) {
                    TrackerNode node = baseNode.getDependent(script);
                    if (node == null) continue;
                    propNodes.add(node);
                    if (!BindELContext.isBracket((String)script)) continue;
                    ((TrackerNodeImpl)baseNode).tieProperty(propName, script);
                }
                if (value != null) {
                    for (TrackerNode node : propNodes) {
                        this.addBeanMap(node, value);
                    }
                } else {
                    for (TrackerNode node : propNodes) {
                        this.removeAllBeanMap(node);
                    }
                }
            }
        }
    }

    private void addBeanMap(TrackerNode node, Object value) {
        if (!value.equals(node.getBean())) {
            this.removeBeanMap(node);
            if (!BindELContext.isImmutable(value)) {
                Set<TrackerNode> nodes = this._beanMap.get(value);
                if (nodes == null) {
                    nodes = new HashSet<TrackerNode>();
                    this._beanMap.put(value, nodes);
                    this._equalBeansMap.put(value);
                }
                nodes.add(node);
                node.setBean(value);
            }
        }
        this.removeNullMap(node);
    }

    private void addNullMap(TrackerNode node) {
        Object propName = node.getFieldScript();
        Set<TrackerNode> nodes = this._nullMap.get(propName);
        if (nodes == null) {
            nodes = new HashSet<TrackerNode>();
            this._nullMap.put(propName, nodes);
        }
        nodes.add(node);
        this.removeBeanMap(node);
    }

    private void removeNullMap(TrackerNode node) {
        Object propName = node.getFieldScript();
        Set<TrackerNode> nodes = this._nullMap.get(propName);
        if (nodes != null) {
            nodes.remove(node);
            if (nodes.isEmpty()) {
                this._nullMap.remove(propName);
            }
        }
    }

    private void removeAllBeanMap(TrackerNode node) {
        this.removeBeanMap(node);
        Set<TrackerNode> kidnodes = node.getDependents();
        for (TrackerNode kid : kidnodes) {
            this.removeBeanMap(kid);
        }
    }

    private void removeBeanMap(TrackerNode node) {
        Object value = node.getBean();
        if (value != null) {
            node.setBean(null);
            Set<TrackerNode> nodes = this._beanMap.get(value);
            if (nodes != null) {
                nodes.remove(node);
                if (nodes.isEmpty()) {
                    this._equalBeansMap.remove(value);
                    this._beanMap.remove(value);
                }
            }
        }
    }

    private void getNodesLoadBindings(Set<TrackerNode> basenodes, Set<LoadBinding> bindings, Set<Object> kidbases, Set<TrackerNode> visited) {
        if (basenodes != null) {
            for (TrackerNode node : basenodes) {
                if (node == null) continue;
                this.getLoadBindings0(node, bindings, kidbases, visited);
            }
        }
    }

    private void getLoadBindings0(TrackerNode node, Set<LoadBinding> bindings, Set<Object> kidbases, Set<TrackerNode> visited) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        bindings.addAll(node.getLoadBindings());
        Set<ReferenceBinding> refBindings = node.getReferenceBindings();
        bindings.addAll(refBindings);
        for (ReferenceBinding refBinding : refBindings) {
            refBinding.invalidateCache();
            this.collectLoadBindings(refBinding, ".", bindings, visited);
        }
        for (TrackerNode associate : node.getAssociates()) {
            this.getLoadBindings0(associate, bindings, kidbases, visited);
        }
        Object kidbase = node.getBean();
        if (kidbases != null && kidbase != null) {
            kidbases.add(kidbase);
        } else {
            Set<TrackerNode> nodes = node.getDirectDependents();
            for (TrackerNode kid : nodes) {
                this.getLoadBindings0(kid, bindings, null, visited);
            }
        }
    }

    private Set<TrackerNode> getNodes(Object base, String postfix) {
        String[] props;
        Set<TrackerNode> nodes = this.getAllTrackerNodesByBean(base);
        for (String prop : props = postfix.split("\\.")) {
            nodes = this.getDependents(nodes, prop);
        }
        return nodes;
    }

    private Set<TrackerNode> getDependents(Set<TrackerNode> parentnodes, String prop) {
        HashSet<TrackerNode> kidnodes = new HashSet<TrackerNode>();
        for (TrackerNode node : parentnodes) {
            TrackerNode kid = node.getDependent(prop);
            if (kid == null) continue;
            kidnodes.add(kid);
        }
        return kidnodes;
    }

    private void removeAllFromBeanMap(Collection<TrackerNode> removed) {
        Set<Map.Entry<Object, Set<TrackerNode>>> nodesets = this._beanMap.entrySet();
        Iterator it = nodesets.iterator();
        while (it.hasNext()) {
            Map.Entry nodeset = (Map.Entry)it.next();
            Object bean = nodeset.getKey();
            ((Set)nodeset.getValue()).removeAll(removed);
            if (!((Set)nodeset.getValue()).isEmpty()) continue;
            it.remove();
            this._equalBeansMap.remove(bean);
        }
    }

    private void removeNodes(Collection<Set<TrackerNode>> nodesets, Collection<TrackerNode> removed) {
        Iterator<Set<TrackerNode>> it = nodesets.iterator();
        while (it.hasNext()) {
            Set<TrackerNode> nodeset = it.next();
            nodeset.removeAll(removed);
            if (!nodeset.isEmpty()) continue;
            it.remove();
        }
    }

    private Set<TrackerNode> getAllTrackerNodesByBean(Object bean) {
        LinkedHashSet<TrackerNode> results = new LinkedHashSet<TrackerNode>();
        this.getAllTrackerNodesByBean0(bean, results);
        return results;
    }

    private void getAllTrackerNodesByBean0(Object bean, Set<TrackerNode> results) {
        Set<Object> beans = this._equalBeansMap.getEqualBeans(bean);
        LinkedHashSet<TrackerNode> nodes = new LinkedHashSet<TrackerNode>();
        for (Object obj : beans) {
            nodes.addAll((Collection<TrackerNode>)this._beanMap.get(obj));
        }
        results.addAll(nodes);
        this.getAllTrackerNodesByBeanNodes(nodes, results);
    }

    private void getAllTrackerNodesByBeanNodes(Set<TrackerNode> nodes, Set<TrackerNode> results) {
        for (TrackerNode node : nodes) {
            Set<ReferenceBinding> refBindings = node.getReferenceBindings();
            for (ReferenceBinding refBinding : refBindings) {
                this.getAllTrackerNodesByBean0(refBinding, results);
            }
        }
    }

    public Set<Object> getEqualBeans(Object bean) {
        return this._equalBeansMap.getEqualBeans(bean);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._beanMap = new WeakIdentityMap<Object, Set<TrackerNode>>();
        this._equalBeansMap = new EqualBeansMap();
    }

    public void dump() {
        this.dumpCompMap();
        this.dumpBeanMap();
        this.dumpNullMap();
        this.dumpEqualBeansMap();
    }

    private void dumpBeanMap() {
        System.out.println("******* _beanMap: *********");
        System.out.println("******* size: " + this._beanMap.size());
        for (Object bean : this._beanMap.keySet()) {
            System.out.println("bean:" + bean + "------------");
            Set<TrackerNode> nodes = this._beanMap.get(bean);
            for (TrackerNode node : nodes) {
                this.dumpNodeTree(node, 4);
            }
        }
    }

    private void dumpCompMap() {
        System.out.println("******* _compMap: *********");
        System.out.println("******* size: " + this._compMap.size());
        for (Component comp : this._compMap.keySet()) {
            System.out.println("comp:" + comp + "------------");
            Map<Object, TrackerNode> nodes = this._compMap.get(comp);
            for (Map.Entry<Object, TrackerNode> entry : nodes.entrySet()) {
                System.out.println("----field:" + entry.getKey() + "");
                this.dumpNodeTree(entry.getValue(), 4);
            }
        }
    }

    private void dumpNullMap() {
        System.out.println("******* _nullMap: *********");
        System.out.println("******* size: " + this._nullMap.size());
        for (Object field : this._nullMap.keySet()) {
            System.out.println("field:" + field + "------");
            Set<TrackerNode> nodes = this._nullMap.get(field);
            for (TrackerNode node : nodes) {
                this.dumpNodeTree(node, 4);
            }
        }
    }

    private void dumpEqualBeansMap() {
        System.out.println("******* _equalBeansMap: *********");
        System.out.println("******* size: " + this._equalBeansMap.size());
        for (Map.Entry entry : this._equalBeansMap.entrySet()) {
            System.out.println("proxy:" + entry.getKey());
            System.out.println("val:" + ((EqualBeans)entry.getValue()).getBeans());
            System.out.println("----");
        }
    }

    private void dumpNodeTree(TrackerNode node, int indent) {
        this.dumpNode(node, indent);
        for (TrackerNode kid : node.getDirectDependents()) {
            this.dumpNodeTree(kid, indent + 4);
        }
    }

    private void dumpNode(TrackerNode node, int spaces) {
        System.out.println(this.dumpSpace(spaces) + node.getFieldScript() + ":" + node.getBean());
        this.dumpBindings(node, spaces);
        this.dumpPropNameMapping(node, spaces);
        this.dumpAssociate(node, spaces);
    }

    private void dumpNode0(TrackerNode node, int spaces) {
        System.out.println(this.dumpSpace(spaces) + node.getFieldScript() + ":" + node.getBean());
        this.dumpBindings(node, spaces);
        this.dumpPropNameMapping(node, spaces);
    }

    private void dumpAssociate(TrackerNode node, int spaces) {
        if (node.getAssociates().isEmpty()) {
            return;
        }
        System.out.println(this.dumpSpace(spaces) + "[dependents:");
        for (TrackerNode dependent : node.getAssociates()) {
            this.dumpNode0(dependent, spaces + 4);
        }
        System.out.println(this.dumpSpace(spaces) + "]");
    }

    private void dumpBindings(TrackerNode node, int spaces) {
        if (node.getBindings().isEmpty()) {
            return;
        }
        System.out.println(this.dumpSpace(spaces) + "[bindings:");
        for (Binding binding : node.getBindings()) {
            this.dumpBinding(binding, spaces + 4);
        }
        System.out.println(this.dumpSpace(spaces) + "]");
    }

    private void dumpBinding(Binding binding, int spaces) {
        if (binding instanceof PropertyBinding) {
            System.out.println(this.dumpSpace(spaces) + ((PropertyBinding)binding).getPropertyString() + ":" + binding);
        } else if (binding instanceof FormBinding) {
            System.out.println(this.dumpSpace(spaces) + ((FormBinding)binding).getPropertyString() + ":" + binding);
        } else if (binding instanceof ChildrenBinding) {
            System.out.println(this.dumpSpace(spaces) + ((ChildrenBinding)binding).getPropertyString() + ":" + binding);
        } else if (binding instanceof ReferenceBinding) {
            System.out.println(this.dumpSpace(spaces) + ((ReferenceBinding)binding).getPropertyString() + ":" + binding);
        }
    }

    private void dumpPropNameMapping(TrackerNode node, int spaces) {
        if (((TrackerNodeImpl)node).getPropNameMapping().size() == 0) {
            return;
        }
        System.out.println(this.dumpSpace(spaces) + "[propertys:");
        for (Map.Entry<Object, Object> entry : ((TrackerNodeImpl)node).getPropNameMapping().entrySet()) {
            this.dumpEntry(entry, spaces + 4);
        }
        System.out.println(this.dumpSpace(spaces) + "]");
    }

    private void dumpEntry(Map.Entry<Object, Object> entry, int spaces) {
        System.out.println(this.dumpSpace(spaces) + entry.getKey() + "=" + entry.getValue());
    }

    private String dumpSpace(int space) {
        char[] spaces = new char[space];
        Arrays.fill(spaces, ' ');
        return new String(spaces);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EqualBeans {
        private transient WeakReference<Object> _proxy;
        private transient WeakIdentityMap<Object, Boolean> _beanSet;

        public EqualBeans(Object proxy) {
            this._proxy = new WeakReference<Object>(proxy);
            this._beanSet = new WeakIdentityMap(2);
            this._beanSet.put(proxy, Boolean.TRUE);
        }

        public void put(Object value) {
            this._beanSet.put(value, Boolean.TRUE);
        }

        public Set<Object> getBeans() {
            return this._beanSet != null ? new IdentityHashSet(this._beanSet.keySet()) : Collections.emptySet();
        }

        public Object remove(Object value) {
            this._beanSet.remove(value);
            if (this._beanSet.isEmpty()) {
                this._beanSet = null;
            } else if (System.identityHashCode(this._proxy.get()) == System.identityHashCode(value)) {
                Iterator<Object> it = this._beanSet.keySet().iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj != null) {
                        this._proxy = new WeakReference<Object>(obj);
                        break;
                    }
                    it.remove();
                }
            }
            return this._proxy.get();
        }

        public boolean isEmpty() {
            return this._beanSet == null || this._beanSet.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EqualBeansMap {
        private transient WeakHashMap<Object, EqualBeans> _innerMap = new WeakHashMap();
        private transient WeakIdentityMap<Object, EqualBeans> _identityMap = new WeakIdentityMap();

        private EqualBeansMap() {
        }

        private void syncInnerMap(EqualBeans equalBeans, Object bean) {
            boolean found = false;
            WeakHashMap<Object, EqualBeans> newMap = new WeakHashMap<Object, EqualBeans>(this._innerMap.size());
            for (Map.Entry<Object, EqualBeans> entry : this._innerMap.entrySet()) {
                EqualBeans beans = entry.getValue();
                if (equalBeans.equals(beans)) {
                    found = true;
                    continue;
                }
                newMap.put(entry.getKey(), entry.getValue());
            }
            if (found) {
                this._innerMap = newMap;
                for (Object b : equalBeans.getBeans()) {
                    this._identityMap.remove(b);
                    this.put(b);
                }
            }
        }

        public void put(Object bean) {
            EqualBeans equalBeans = this._innerMap.get(bean);
            if (equalBeans == null) {
                equalBeans = this._identityMap.remove(bean);
                if (equalBeans != null) {
                    this.syncInnerMap(equalBeans, bean);
                    return;
                }
                equalBeans = new EqualBeans(bean);
                this._innerMap.put(bean, equalBeans);
            } else {
                equalBeans.put(bean);
            }
            this._identityMap.put(bean, equalBeans);
        }

        public void remove(Object bean) {
            EqualBeans equalBeans = this._innerMap.remove(bean);
            if (equalBeans != null) {
                this._identityMap.remove(bean);
                this.removeFromEqualBeansAndReput(equalBeans, bean);
            } else {
                equalBeans = this._identityMap.remove(bean);
                if (equalBeans != null) {
                    boolean found = false;
                    WeakHashMap<Object, EqualBeans> newMap = new WeakHashMap<Object, EqualBeans>(this._innerMap.size());
                    for (Map.Entry<Object, EqualBeans> entry : this._innerMap.entrySet()) {
                        EqualBeans beans = entry.getValue();
                        if (equalBeans.equals(beans)) {
                            found = true;
                            continue;
                        }
                        newMap.put(entry.getKey(), entry.getValue());
                    }
                    if (found) {
                        this._innerMap = newMap;
                        this.removeFromEqualBeansAndReput(equalBeans, bean);
                    }
                }
            }
        }

        private void removeFromEqualBeansAndReput(EqualBeans equalBeans, Object bean) {
            Object proxy = equalBeans.remove(bean);
            if (!equalBeans.isEmpty()) {
                this._innerMap.put(proxy, equalBeans);
            }
        }

        public Set<Object> getEqualBeans(Object bean) {
            EqualBeans equalBeans = this._innerMap.get(bean);
            if (equalBeans == null && (equalBeans = this._identityMap.remove(bean)) != null) {
                this.syncInnerMap(equalBeans, bean);
                equalBeans = this._identityMap.get(bean);
            }
            return equalBeans == null ? Collections.emptySet() : equalBeans.getBeans();
        }

        public int size() {
            return this._innerMap.size();
        }

        private Set<Map.Entry<Object, EqualBeans>> entrySet() {
            return this._innerMap.entrySet();
        }
    }
}

