/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.tracker.impl;

import java.util.Collection;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AnnotateBinderHelper;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.UiLifeCycle;

public class BindUiLifeCycle
implements UiLifeCycle {
    public void afterComponentAttached(Component comp, Page page) {
        Binder binder;
        Binder selfBinder;
        if (comp.getDesktop() != null && (selfBinder = (Binder)comp.getAttribute("$BINDER$")) == null && (binder = (Binder)comp.getAttribute("$BINDER$", true)) != null) {
            comp.addEventListener(10000, "onBindInit", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    Component comp = event.getTarget();
                    comp.removeEventListener("onBindInit", (EventListener)this);
                    if (comp.getParent() == null || comp.getPage() == null) {
                        return;
                    }
                    Binder innerBinder = (Binder)comp.getAttribute("$BINDER$");
                    if (innerBinder != null) {
                        return;
                    }
                    new AnnotateBinderHelper(binder).initComponentBindings(comp);
                    binder.loadComponent(comp, true);
                    if (comp.getAttribute("$VAR$") != null) {
                        comp.setAttribute("$BINDER$", (Object)binder);
                    }
                }
            });
            Events.postEvent((Event)new Event("onBindInit", comp));
        }
    }

    public void afterComponentDetached(Component comp, Page prevpage) {
        this.removeBindings(comp);
    }

    public void afterComponentMoved(Component parent, Component child, Component prevparent) {
    }

    public void afterPageAttached(Page page, Desktop desktop) {
    }

    public void afterPageDetached(Page page, Desktop prevdesktop) {
        Collection comps = page.getRoots();
        for (Component comp : comps) {
            this.removeBindings(comp);
        }
    }

    private void removeBindings(Component comp) {
        this.removeBindings0(comp);
        for (Component kid : comp.getChildren()) {
            if (kid == null) continue;
            this.removeBindings(kid);
        }
    }

    private void removeBindings0(Component comp) {
        Binder binder;
        Object installed = comp.removeAttribute("$RENDERER_INSTALLED$");
        if (installed != null) {
            BindELContext.removeModel(comp);
        }
        if ((binder = (Binder)comp.getAttribute("$BINDER$")) != null) {
            binder.removeBindings(comp);
        }
    }
}

