/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationMessagesImpl
implements ValidationMessages,
Collection<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Component, Map<String, List<Message>>> _attrMessageMap;
    private final Map<Component, Map<String, List<Message>>> _keyMessageMap;
    private final Map<String, List<Message>> _globalKeyMessageMap;
    private final List<Message> _messages = new LinkedList<Message>();

    public ValidationMessagesImpl() {
        this._attrMessageMap = new LinkedHashMap<Component, Map<String, List<Message>>>();
        this._keyMessageMap = new LinkedHashMap<Component, Map<String, List<Message>>>();
        this._globalKeyMessageMap = new LinkedHashMap<String, List<Message>>();
    }

    private List<Message> getAttrMessages(Component comp, String attr, boolean create) {
        Map<String, List<Message>> attrMap = this.getAttrMap(comp, create);
        if (attrMap == null) {
            return null;
        }
        List<Message> msgs = attrMap.get(attr);
        if (msgs == null && create) {
            msgs = new ArrayList<Message>(1);
            attrMap.put(attr, msgs);
        }
        return msgs;
    }

    private Map<String, List<Message>> getAttrMap(Component comp, boolean create) {
        Map<String, List<Message>> msgs = this._attrMessageMap.get(comp);
        if (msgs == null && create) {
            msgs = new LinkedHashMap<String, List<Message>>();
            this._attrMessageMap.put(comp, msgs);
        }
        return msgs;
    }

    private List<Message> getKeyMessages(Component comp, String key, boolean create) {
        Map<String, List<Message>> keyMap = this.getKeyMap(comp, create);
        if (keyMap == null) {
            return null;
        }
        List<Message> msgs = keyMap.get(key);
        if (msgs == null && create) {
            msgs = new ArrayList<Message>(1);
            keyMap.put(key, msgs);
        }
        return msgs;
    }

    private Map<String, List<Message>> getKeyMap(Component comp, boolean create) {
        Map<String, List<Message>> msgs = this._keyMessageMap.get(comp);
        if (msgs == null && create) {
            msgs = new LinkedHashMap<String, List<Message>>();
            this._keyMessageMap.put(comp, msgs);
        }
        return msgs;
    }

    private List<Message> getGlobalKeyMessages(String key, boolean create) {
        List<Message> msgs = this._globalKeyMessageMap.get(key);
        if (msgs == null && create) {
            msgs = new ArrayList<Message>(1);
            this._globalKeyMessageMap.put(key, msgs);
        }
        return msgs;
    }

    @Override
    public void clearMessages(Component comp) {
        Map<String, List<Message>> keyMap;
        Map<String, List<Message>> attrMap = this.getAttrMap(comp, false);
        if (attrMap != null) {
            for (List<Message> remove : attrMap.values()) {
                this._messages.removeAll(remove);
            }
            this._attrMessageMap.remove(comp);
        }
        if ((keyMap = this.getKeyMap(comp, false)) != null) {
            for (Map.Entry<String, List<Message>> entry : keyMap.entrySet()) {
                List<Message> gmsgs = this._globalKeyMessageMap.get(entry.getKey());
                if (gmsgs != null && gmsgs.size() > 0) {
                    gmsgs.removeAll((Collection)entry.getValue());
                }
                if (gmsgs == null || gmsgs.size() != 0) continue;
                this._globalKeyMessageMap.remove(entry.getKey());
            }
        }
        this._keyMessageMap.remove(comp);
    }

    @Override
    public void clearMessages(Component comp, String attr) {
        Map<String, List<Message>> attrMap = this.getAttrMap(comp, false);
        List<Message> remove = null;
        if (attrMap != null) {
            remove = attrMap.remove(attr);
            if (attrMap.size() == 0) {
                this._attrMessageMap.remove(comp);
            }
        }
        if (remove != null && remove.size() > 0) {
            this._messages.removeAll(remove);
            for (Message m : remove) {
                if (m.key == null) continue;
                List<Message> msgs = this.getKeyMessages(comp, m.key, false);
                if (msgs != null) {
                    Map<String, List<Message>> keyMap;
                    msgs.remove(m);
                    if (msgs.size() == 0 && (keyMap = this.getKeyMap(comp, false)) != null) {
                        keyMap.remove(m.key);
                    }
                }
                if ((msgs = this._globalKeyMessageMap.get(m.key)) == null) continue;
                msgs.remove(m);
                if (msgs.size() != 0) continue;
                this._globalKeyMessageMap.remove(m.key);
            }
        }
    }

    @Override
    public String[] getMessages(Component comp, String attr) {
        List<Message> msgs = this.getAttrMessages(comp, attr, false);
        if (msgs == null || msgs.size() == 0) {
            return null;
        }
        String[] smsgs = new String[msgs.size()];
        for (int i = 0; i < smsgs.length; ++i) {
            smsgs[i] = msgs.get((int)i).msg;
        }
        return smsgs;
    }

    @Override
    public String[] getMessages(Component comp) {
        Map<String, List<Message>> m = this.getAttrMap(comp, false);
        if (m == null || m.size() == 0) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>();
        for (Map.Entry<String, List<Message>> e : m.entrySet()) {
            for (Message mm : e.getValue()) {
                msgs.add(mm.msg);
            }
        }
        return msgs.size() == 0 ? null : msgs.toArray(new String[msgs.size()]);
    }

    @Override
    public String[] getMessages() {
        if (this._messages.size() == 0) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>(this._messages.size());
        for (Message mm : this._messages) {
            msgs.add(mm.msg);
        }
        return msgs.size() == 0 ? null : msgs.toArray(new String[msgs.size()]);
    }

    @Override
    public String[] getKeyMessages(Component comp, String key) {
        List<Message> msgs = this.getKeyMessages(comp, key, false);
        if (msgs == null || msgs.size() == 0) {
            return null;
        }
        String[] smsgs = new String[msgs.size()];
        for (int i = 0; i < smsgs.length; ++i) {
            smsgs[i] = msgs.get((int)i).msg;
        }
        return smsgs;
    }

    @Override
    public String[] getKeyMessages(String key) {
        List<Message> msgs = this._globalKeyMessageMap.get(key);
        if (msgs == null || msgs.size() == 0) {
            return null;
        }
        String[] smsgs = new String[msgs.size()];
        for (int i = 0; i < smsgs.length; ++i) {
            smsgs[i] = msgs.get((int)i).msg;
        }
        return smsgs;
    }

    @Override
    public void setMessages(Component comp, String attr, String key, String[] messages) {
        this.clearMessages(comp, attr);
        this.addMessages(comp, attr, key, messages);
    }

    @Override
    public void addMessages(Component comp, String attr, String key, String[] messages) {
        List<Message> attrMsgs = this.getAttrMessages(comp, attr, true);
        List<Message> keyMsgs = null;
        List<Message> globalMsgs = null;
        for (String s : messages) {
            Message msg = new Message(attr, key, s);
            this._messages.add(msg);
            attrMsgs.add(msg);
            if (key == null) continue;
            if (keyMsgs == null) {
                keyMsgs = this.getKeyMessages(comp, key, true);
                globalMsgs = this.getGlobalKeyMessages(key, true);
            }
            keyMsgs.add(msg);
            globalMsgs.add(msg);
        }
    }

    @Override
    public int size() {
        return this._messages.size();
    }

    @Override
    public boolean isEmpty() {
        return this._messages.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._messages.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return new ArrayList<Message>(this._messages).iterator();
    }

    @Override
    public Object[] toArray() {
        return this._messages.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._messages.toArray(a);
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._messages.contains(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("read only");
    }

    static class Message
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String attr;
        final String key;
        final String msg;

        public Message(String attr, String key, String msg) {
            this.attr = attr;
            this.key = key;
            this.msg = msg;
        }
    }
}

