/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AbstractForEachStatus;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.TemplateResolver;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolverImpl
implements TemplateResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _templateExpr;
    private final Map<String, Object> _templateArgs;
    private final Binder _binder;
    private final String _attr;
    private final Component _comp;
    private final ExpressionX _expression;
    private Binding _binding;
    private boolean _bindingResolved;

    public TemplateResolverImpl(Binder binder, Component comp, String attr, String templateExpr, Map<String, Object> templateArgs) {
        this._binder = binder;
        this._comp = comp;
        this._templateExpr = templateExpr;
        this._templateArgs = templateArgs;
        this._attr = attr;
        BindContext ctx = BindContextUtil.newBindContext(binder, null, false, null, this._comp, null);
        this._expression = binder.getEvaluatorX().parseExpressionX(ctx, templateExpr, Object.class);
    }

    public String getExpression() {
        return this._templateExpr;
    }

    private Template lookupTemplate(Component comp, String name) {
        if (comp == null) {
            return null;
        }
        Template template = comp.getTemplate(name);
        return template == null ? this.lookupTemplate(comp.getParent(), name) : template;
    }

    @Override
    public Template resolveTemplate(Component eachComp, final Object eachData, final int index, final int size) {
        Object value;
        block8: {
            Object oldStatus;
            Object oldEach;
            block7: {
                Template template;
                oldEach = null;
                oldStatus = null;
                try {
                    oldEach = eachComp.setAttribute("each", eachData);
                    oldStatus = eachComp.setAttribute("forEachStatus", (Object)new AbstractForEachStatus(){
                        private static final long serialVersionUID = 1L;

                        public int getIndex() {
                            return index;
                        }

                        public Object getEach() {
                            return eachData;
                        }

                        public Integer getEnd() {
                            if (size < 0) {
                                throw new UiException("end attribute is not supported");
                            }
                            return size;
                        }
                    });
                    BindEvaluatorX eval = this._binder.getEvaluatorX();
                    BindContext ctx = BindContextUtil.newBindContext(this._binder, null, false, null, eachComp, null);
                    value = eval.getValue(ctx, eachComp, this._expression);
                    if (!(value instanceof Template)) break block7;
                    template = (Template)value;
                }
                catch (Throwable throwable) {
                    eachComp.setAttribute("each", oldEach);
                    eachComp.setAttribute("forEachStatus", oldStatus);
                    throw throwable;
                }
                eachComp.setAttribute("each", oldEach);
                eachComp.setAttribute("forEachStatus", oldStatus);
                return template;
            }
            if (!(value instanceof String)) break block8;
            Template template = this.lookupTemplate(eachComp, (String)value);
            if (template == null && ((String)value).indexOf(46) > 0) {
                try {
                    template = (Template)this._comp.getPage().resolveClass((String)value).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Template template2 = template;
            eachComp.setAttribute("each", oldEach);
            eachComp.setAttribute("forEachStatus", oldStatus);
            return template2;
        }
        throw new UiException("unknow template type " + value);
    }

    @Override
    public void addTemplateTracking(Component eachComp) {
        if (!this._bindingResolved || this._binding == null) {
            List<Binding> bindings = ((BinderCtrl)((Object)this._binder)).getLoadPromptBindings(this._comp, this._attr);
            this._binding = bindings.size() > 0 ? bindings.get(bindings.size() - 1) : null;
            this._bindingResolved = true;
        }
        if (this._binding != null) {
            BindContext ctx = BindContextUtil.newBindContext(this._binder, this._binding, false, null, eachComp, null);
            BindEvaluatorX eval = this._binder.getEvaluatorX();
            ExpressionX exprX = eval.parseExpressionX(ctx, this._templateExpr, Object.class);
            eval.getValue(ctx, eachComp, exprX);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this._templateExpr).append("]").append(super.toString());
        return sb.toString();
    }
}

