/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.bind.Validator;
import org.zkoss.bind.validator.DeferredValidator;
import org.zkoss.lang.Classes;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.UiException;

public class SystemValidators {
    private static final Log _log = Log.lookup(SystemValidators.class);
    private static final Map<String, Validator> _validators = new HashMap<String, Validator>();
    private static boolean _init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initBuiltinValidators() {
        Map<String, Validator> map = _validators;
        synchronized (map) {
            SystemValidators.set0("beanValidator", new DeferredValidator("org.zkoss.bind.validator.BeanValidator"));
            _init = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (_init) {
            return;
        }
        Map<String, Validator> map = _validators;
        synchronized (map) {
            if (_init) {
                return;
            }
            SystemValidators.initBuiltinValidators();
            _init = true;
        }
    }

    public static void set(String name, Validator validator) {
        SystemValidators.init();
        SystemValidators.set0(name, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void set0(String name, Validator validator) {
        if (_log.debugable()) {
            _log.debug("set validator [%s]=[%s]", new Object[]{name, validator});
        }
        Map<String, Validator> map = _validators;
        synchronized (map) {
            _validators.put(name, validator);
        }
    }

    public static Validator get(String name) {
        SystemValidators.init();
        Validator v = _validators.get(name);
        if (v == null && name.indexOf(46) > 0) {
            try {
                v = (Validator)Classes.newInstanceByThread((String)name);
                SystemValidators.set(name, v);
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        return v;
    }
}

