/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindComposer;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormExt;
import org.zkoss.bind.GlobalCommandEvent;
import org.zkoss.bind.Phase;
import org.zkoss.bind.PhaseListener;
import org.zkoss.bind.Property;
import org.zkoss.bind.PropertyChangeEvent;
import org.zkoss.bind.SimpleForm;
import org.zkoss.bind.Validator;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXImpl;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BindingKey;
import org.zkoss.bind.impl.ChildrenBindingHandler;
import org.zkoss.bind.impl.CommandBindingImpl;
import org.zkoss.bind.impl.FormBindingHandler;
import org.zkoss.bind.impl.ImplicitObjectContributor;
import org.zkoss.bind.impl.InitChildrenBindingImpl;
import org.zkoss.bind.impl.InitFormBindingImpl;
import org.zkoss.bind.impl.InitPropertyBindingImpl;
import org.zkoss.bind.impl.LoadChildrenBindingImpl;
import org.zkoss.bind.impl.LoadFormBindingImpl;
import org.zkoss.bind.impl.LoadPropertyBindingImpl;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.ParamCall;
import org.zkoss.bind.impl.PropertyBindingHandler;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.impl.ReferenceBindingHandler;
import org.zkoss.bind.impl.ReferenceBindingImpl;
import org.zkoss.bind.impl.SaveFormBindingImpl;
import org.zkoss.bind.impl.SavePropertyBindingImpl;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.impl.SystemValidators;
import org.zkoss.bind.impl.TemplateRendererCtrl;
import org.zkoss.bind.impl.TemplateResolverImpl;
import org.zkoss.bind.impl.ValidationHelper;
import org.zkoss.bind.impl.WrongValuePropertyImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.CommandBinding;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.LoadChildrenBinding;
import org.zkoss.bind.sys.LoadPropertyBinding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.bind.sys.SaveBinding;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.sys.TemplateResolver;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.tracker.impl.TrackerImpl;
import org.zkoss.bind.xel.BindXelFactory;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Strings;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.CacheMap;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zel.MethodNotFoundException;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ExecutionInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinderImpl
implements Binder,
BinderCtrl,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;
    private static final Log _log = Log.lookup(BinderImpl.class);
    private static final Map<String, Object> RENDERERS = new HashMap<String, Object>();
    public static final String BINDING = "$BINDING$";
    public static final String BINDER = "$BINDER$";
    public static final String BINDCTX = "$BINDCTX$";
    public static final String VAR = "$VAR$";
    public static final String VM = "$VM$";
    public static final String NOTIFYS = "$NOTIFYS$";
    public static final String VALIDATES = "$VALIDATES$";
    public static final String SRCPATH = "$SRCPATH$";
    public static final String DEPENDS_ON_COMP = "$DEPENDS_ON_COMP";
    public static final String RENDERER_INSTALLED = "$RENDERER_INSTALLED$";
    public static final String LOAD_FORM_EXPRESSION = "$LOAD_FORM_EXPR$";
    public static final String LOAD_FORM_COMPONENT = "$LOAD_FORM_COMP$";
    public static final String IGNORE_TRACKER = "$IGNORE_TRACKER$";
    public static final String SAVE_BASE = "$SAVE_BASE$";
    public static final String ON_BIND_INIT = "onBindInit";
    public static final String MODEL = "$MODEL$";
    private static final String ON_POST_COMMAND = "onPostCommand";
    private static final String ON_VMSGS_CHANGED = "onVMsgsChanged";
    private static final String FORM_ID = "$FORM_ID$";
    private static final String CHILDREN_ATTR = "$CHILDREN$";
    private static final String ACTIVATOR = "$ACTIVATOR$";
    private static final int COMMAND_SUCCESS = 0;
    private static final int COMMAND_FAIL_VALIDATE = 1;
    private static final Map<Class<?>, List<Method>> _initMethodCache = new CacheMap(600, 1800000);
    private static final Map<Class<?>, Map<String, CachedItem<Method>>> _commandMethodCache = new CacheMap(200, 1800000);
    private static final Map<Class<?>, Map<String, CachedItem<Method>>> _globalCommandMethodCache = new CacheMap(200, 1800000);
    private Component _rootComp;
    private BindEvaluatorX _eval;
    private PhaseListener _phaseListener;
    private Tracker _tracker;
    private final Component _dummyTarget = new AbstractComponent();
    private final Map<Component, Map<String, List<Binding>>> _bindings = new HashMap<Component, Map<String, List<Binding>>>();
    private final FormBindingHandler _formBindingHandler = new FormBindingHandler();
    private final PropertyBindingHandler _propertyBindingHandler = new PropertyBindingHandler();
    private final ChildrenBindingHandler _childrenBindingHandler = new ChildrenBindingHandler();
    private final ReferenceBindingHandler _refBindingHandler;
    private Map<Component, Set<SaveBinding>> _assocFormSaveBindings;
    private Map<Component, Map<SaveBinding, Set<SaveBinding>>> _reversedAssocFormSaveBindings;
    private final Map<BindingKey, CommandEventListener> _listenerMap;
    private final String _quename;
    private final String _quescope;
    private final QueueListener _queueListener;
    private ValidationMessages _validationMessages;
    private Set<BindingKey> _hasValidators;
    private final Map<Component, Map<String, TemplateResolver>> _templateResolvers;
    private boolean _hasGetConverterMethod = true;
    private boolean _hasGetValidatorMethod = true;
    private boolean _init = false;
    private boolean _activating = false;
    private DeferredActivator _deferredActivator;
    private final ImplicitObjectContributor _implicitContributor;
    private static final String REF_HANDLER_CLASS_PROP = "org.zkoss.bind.ReferenceBindingHandler.class";
    private static final String IMPLICIT_CONTRIBUTOR_CLASS_PROP = "org.zkoss.bind.ImplicitObjectContributor.class";

    public BinderImpl() {
        this(null, null);
    }

    public BinderImpl(String qname, String qscope) {
        this._formBindingHandler.setBinder(this);
        this._propertyBindingHandler.setBinder(this);
        this._childrenBindingHandler.setBinder(this);
        this._refBindingHandler = MiscUtil.newInstanceFromProperty(REF_HANDLER_CLASS_PROP, null, ReferenceBindingHandler.class);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.setBinder(this);
        }
        this._implicitContributor = MiscUtil.newInstanceFromProperty(IMPLICIT_CONTRIBUTOR_CLASS_PROP, null, ImplicitObjectContributor.class);
        this._assocFormSaveBindings = new HashMap<Component, Set<SaveBinding>>();
        this._reversedAssocFormSaveBindings = new HashMap<Component, Map<SaveBinding, Set<SaveBinding>>>();
        this._hasValidators = new HashSet<BindingKey>();
        this._templateResolvers = new HashMap<Component, Map<String, TemplateResolver>>();
        this._listenerMap = new HashMap<BindingKey, CommandEventListener>();
        this._quename = qname != null && !Strings.isEmpty((String)qname) ? qname : "$ZKBIND_DEFQUE$";
        this._quescope = qscope != null && !Strings.isBlank((String)qscope) ? qscope : "desktop";
        this._queueListener = new QueueListener();
    }

    private void checkInit() {
        if (!this._init) {
            throw new UiException("binder is not initialized yet");
        }
    }

    @Override
    public void init(Component comp, Object viewModel) {
        this.init(comp, viewModel, null);
    }

    @Override
    public void init(Component comp, Object viewModel, Map<String, Object> initArgs) {
        if (this._init) {
            throw new UiException("binder is already initialized");
        }
        this._init = true;
        this._rootComp = comp;
        this.setViewModel(viewModel);
        this._dummyTarget.addEventListener(ON_POST_COMMAND, (EventListener)new PostCommandListener());
        this._dummyTarget.addEventListener(ON_VMSGS_CHANGED, (EventListener)new VMsgsChangedListener());
        this.subscribeQueue(this._quename, this._quescope, this._queueListener);
        if (viewModel instanceof Composer && !(viewModel instanceof BindComposer)) {
            _log.warning("you are using a composer [%s] as a view model", new Object[]{viewModel});
        }
        this.initViewModel(viewModel, initArgs);
        this._rootComp.setAttribute(ACTIVATOR, (Object)new Activator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewModel(Object viewModel, Map<String, Object> initArgs) {
        Class<?> clz = viewModel.getClass();
        List<Method> inits = this.getInitMethods(clz);
        if (inits.size() == 0) {
            return;
        }
        if (initArgs != null) {
            initArgs = BindEvaluatorXUtil.evalArgs(this.getEvaluatorX(), this._rootComp, initArgs);
        }
        for (Method m : inits) {
            BindContext ctx = BindContextUtil.newBindContext(this, null, false, null, this._rootComp, null);
            try {
                ParamCall parCall = this.createParamCall(ctx);
                if (initArgs != null) {
                    parCall.setBindingArgs(initArgs);
                }
                parCall.call(viewModel, m);
            }
            catch (Exception e) {
                Map<Class<?>, List<Method>> map = _initMethodCache;
                synchronized (map) {
                    _initMethodCache.remove(clz);
                }
                throw new UiException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Method> getInitMethods(Class<?> clz) {
        List<Method> inits = null;
        Map<Class<?>, List<Method>> map = _initMethodCache;
        synchronized (map) {
            inits = _initMethodCache.get(clz);
            if (inits != null) {
                return inits;
            }
            inits = new ArrayList<Method>();
            Class<?> curr = clz;
            String sign = null;
            HashSet<String> signs = new HashSet<String>();
            while (curr != null && !curr.equals(Object.class)) {
                Method currm = null;
                Init init = curr.getAnnotation(Init.class);
                for (Method m : curr.getDeclaredMethods()) {
                    Init i = m.getAnnotation(Init.class);
                    if (i == null) continue;
                    if (init != null) {
                        throw new UiException("more than one @Init in the class " + curr);
                    }
                    init = i;
                    currm = m;
                }
                if (currm != null) {
                    sign = MiscUtil.toInitMethodSignature(currm);
                    if (signs.contains(sign)) {
                        _log.warning("more than one init method that has same signature '%s' in the hierarchy of '%s', the method in extended class will be call more than once ", new Object[]{sign, clz});
                    } else {
                        signs.add(sign);
                    }
                    inits.add(0, currm);
                }
                curr = init != null && init.superclass() ? curr.getSuperclass() : null;
            }
            inits = Collections.unmodifiableList(inits);
            _initMethodCache.put(clz, inits);
        }
        return inits;
    }

    private void loadOnPropertyChange(Object base, String prop) {
        if (_log.debugable()) {
            _log.debug("loadOnPropertyChange:base=[%s],prop=[%s]", new Object[]{base, prop});
        }
        Tracker tracker = this.getTracker();
        Set<LoadBinding> bindings = tracker.getLoadBindings(base, prop);
        for (LoadBinding binding : bindings) {
            Component comp = binding.getComponent();
            if (comp == null || comp.getParent() == null || comp.getPage() == null) continue;
            BindContext ctx = BindContextUtil.newBindContext(this, binding, false, null, comp, null);
            if (binding instanceof PropertyBinding) {
                BindContextUtil.setConverterArgs(this, comp, ctx, (PropertyBinding)((Object)binding));
            }
            if (_log.debugable()) {
                _log.debug("loadOnPropertyChange:binding.load(),binding=[%s],context=[%s]", new Object[]{binding, ctx});
            }
            binding.load(ctx);
            if (this._validationMessages == null) continue;
            String attr = null;
            if (binding instanceof PropertyBinding) {
                attr = ((PropertyBinding)((Object)binding)).getFieldName();
            } else if (binding instanceof FormBinding) {
                attr = ((FormBinding)((Object)binding)).getFormId();
            }
            if (attr == null || !this.hasValidator(comp, attr)) continue;
            this._validationMessages.clearMessages(comp, attr);
        }
    }

    @Override
    public void setViewModel(Object vm) {
        this.checkInit();
        this._rootComp.setAttribute(VM, vm);
        this._hasGetConverterMethod = true;
        this._hasGetValidatorMethod = true;
    }

    @Override
    public Object getViewModel() {
        this.checkInit();
        return this._rootComp.getAttribute(VM);
    }

    @Override
    public Converter getConverter(String name) {
        this.checkInit();
        Converter converter = null;
        if (this._hasGetConverterMethod) {
            BindEvaluatorX eval = this.getEvaluatorX();
            ExpressionX vmc = eval.parseExpressionX(null, VM + ".getConverter('" + name + "')", Converter.class);
            try {
                converter = (Converter)eval.getValue(null, this._rootComp, vmc);
            }
            catch (MethodNotFoundException x) {
                this._hasGetConverterMethod = false;
            }
        }
        if (converter == null) {
            converter = SystemConverters.get(name);
        }
        if (converter == null) {
            throw new UiException("Cannot find converter:" + name);
        }
        return converter;
    }

    @Override
    public Validator getValidator(String name) {
        this.checkInit();
        Validator validator = null;
        if (this._hasGetValidatorMethod) {
            BindEvaluatorX eval = this.getEvaluatorX();
            ExpressionX vmv = eval.parseExpressionX(null, VM + ".getValidator('" + name + "')", Validator.class);
            try {
                validator = (Validator)eval.getValue(null, this._rootComp, vmv);
            }
            catch (MethodNotFoundException x) {
                this._hasGetValidatorMethod = false;
            }
        }
        if (validator == null) {
            validator = SystemValidators.get(name);
        }
        if (validator == null) {
            throw new UiException("Cannot find validator:" + name);
        }
        return validator;
    }

    protected Object getRenderer(String name) {
        Object renderer = RENDERERS.get(name);
        if (renderer == null && name.indexOf(46) > 0) {
            try {
                renderer = Classes.newInstanceByThread((String)name);
                RENDERERS.put(name, renderer);
            }
            catch (IllegalAccessException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return renderer;
    }

    @Override
    public BindEvaluatorX getEvaluatorX() {
        if (this._eval == null) {
            this._eval = new BindEvaluatorXImpl(null, BindXelFactory.class);
        }
        return this._eval;
    }

    @Override
    public void storeForm(Component comp, String id, Form form) {
        String oldid = (String)comp.getAttribute(FORM_ID, 0);
        if (oldid != null && !oldid.equals(id)) {
            throw new IllegalArgumentException("try to store 2 forms in same component id : 1st " + oldid + ", 2nd " + id);
        }
        Form oldForm = (Form)comp.getAttribute(id);
        if (oldForm == form) {
            return;
        }
        comp.setAttribute(FORM_ID, (Object)id);
        comp.setAttribute(id, (Object)form);
        if (form instanceof FormExt) {
            FormExt fex = (FormExt)((Object)form);
            comp.setAttribute(id + "Status", (Object)fex.getStatus());
            if (oldForm instanceof FormExt) {
                for (String fn : ((FormExt)((Object)oldForm)).getLoadFieldNames()) {
                    fex.addLoadFieldName(fn);
                }
                for (String fn : ((FormExt)((Object)oldForm)).getSaveFieldNames()) {
                    fex.addSaveFieldName(fn);
                }
            }
        }
    }

    @Override
    public Form getForm(Component comp, String id) {
        String oldid = (String)comp.getAttribute(FORM_ID, 0);
        if (oldid == null || !oldid.equals(id)) {
            return null;
        }
        return (Form)comp.getAttribute(id);
    }

    private void removeForm(Component comp) {
        String id = (String)comp.getAttribute(FORM_ID, 0);
        if (id != null) {
            comp.removeAttribute(FORM_ID);
            comp.removeAttribute(id);
            comp.removeAttribute(id + "Status");
        }
    }

    @Override
    public void addFormInitBinding(Component comp, String id, String initExpr, Map<String, Object> initArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException("form id is blank");
        }
        if (initExpr == null) {
            throw new IllegalArgumentException("initExpr is null for component " + comp + ", form " + id);
        }
        Form form = this.getForm(comp, id);
        if (form == null) {
            this.storeForm(comp, id, new SimpleForm());
        }
        this.addFormInitBinding0(comp, id, initExpr, initArgs);
    }

    private void addFormInitBinding0(Component comp, String formId, String initExpr, Map<String, Object> bindingArgs) {
        if (_log.debugable()) {
            _log.debug("add init-form-binding: comp=[%s],form=[%s],expr=[%s]", new Object[]{comp, formId, initExpr});
        }
        String attr = formId;
        InitFormBindingImpl binding = new InitFormBindingImpl(this, comp, attr, initExpr, bindingArgs);
        this.addBinding(comp, attr, binding);
        BindingKey bkey = this.getBindingKey(comp, attr);
        this._formBindingHandler.addInitBinding(bkey, binding);
    }

    @Override
    public void addFormLoadBindings(Component comp, String id, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException("form id is blank");
        }
        if (loadExpr == null) {
            throw new IllegalArgumentException("loadExpr is null for component " + comp + ", form " + id);
        }
        Form form = this.getForm(comp, id);
        if (form == null) {
            this.storeForm(comp, id, new SimpleForm());
        }
        this.addFormLoadBindings0(comp, id, loadExpr, beforeCmds, afterCmds, bindingArgs);
    }

    @Override
    public void addFormSaveBindings(Component comp, String id, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException("form id is blank");
        }
        if (saveExpr == null) {
            throw new IllegalArgumentException("saveExpr is null for component " + comp + ", form " + id);
        }
        Form form = this.getForm(comp, id);
        if (form == null) {
            this.storeForm(comp, id, new SimpleForm());
        }
        this.addFormSaveBindings0(comp, id, saveExpr, beforeCmds, afterCmds, bindingArgs, validatorExpr, validatorArgs);
    }

    private void addFormLoadBindings0(Component comp, String formId, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        String attr = formId;
        if (prompt) {
            LoadFormBindingImpl binding = new LoadFormBindingImpl(this, comp, formId, loadExpr, ConditionType.PROMPT, null, bindingArgs);
            this.addBinding(comp, attr, binding);
            BindingKey bkey = this.getBindingKey(comp, attr);
            this._formBindingHandler.addLoadPromptBinding(bkey, binding);
        } else {
            LoadFormBindingImpl binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = new LoadFormBindingImpl(this, comp, formId, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.debugable()) {
                        _log.debug("add before command-load-form-binding: comp=[%s],attr=[%s],expr=[%s],command=[%s]", new Object[]{comp, attr, loadExpr, cmd});
                    }
                    this._formBindingHandler.addLoadBeforeBinding(cmd, binding);
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = new LoadFormBindingImpl(this, comp, formId, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.debugable()) {
                        _log.debug("add after command-load-form-binding: comp=[%s],attr=[%s],expr=[%s],command=[%s]", new Object[]{comp, attr, loadExpr, cmd});
                    }
                    this._formBindingHandler.addLoadAfterBinding(cmd, binding);
                }
            }
        }
    }

    private void addFormSaveBindings0(Component comp, String formid, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        BindingKey bkey;
        SaveFormBindingImpl binding;
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        if (prompt) {
            throw new IllegalArgumentException("a save-form-binding have to set with a before|after command condition");
        }
        if (beforeCmds != null && beforeCmds.length > 0) {
            for (String cmd : beforeCmds) {
                binding = new SaveFormBindingImpl(this, comp, formid, saveExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, validatorExpr, validatorArgs);
                this.addBinding(comp, formid, binding);
                if (_log.debugable()) {
                    _log.debug("add before command-save-form-binding: comp=[%s],attr=[%s],expr=[%s],command=[%s]", new Object[]{comp, formid, saveExpr, cmd});
                }
                this._formBindingHandler.addSaveBeforeBinding(cmd, binding);
            }
        }
        if (afterCmds != null && afterCmds.length > 0) {
            for (String cmd : afterCmds) {
                binding = new SaveFormBindingImpl(this, comp, formid, saveExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, validatorExpr, validatorArgs);
                this.addBinding(comp, formid, binding);
                if (_log.debugable()) {
                    _log.debug("add after command-save-form-binding: comp=[%s],attr=[%s],expr=[%s],command=[%s]", new Object[]{comp, formid, saveExpr, cmd});
                }
                this._formBindingHandler.addSaveAfterBinding(cmd, binding);
            }
        }
        if (validatorExpr != null && !this._hasValidators.contains(bkey = this.getBindingKey(comp, formid))) {
            this._hasValidators.add(bkey);
        }
    }

    @Override
    public void addPropertyInitBinding(Component comp, String attr, String initExpr, Map<String, Object> initArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (initExpr == null) {
            throw new IllegalArgumentException("initExpr is null for " + attr + " of " + comp);
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + converterExpr + "'";
        }
        this.addPropertyInitBinding0(comp, attr, initExpr, initArgs, converterExpr, converterArgs);
        this.initRendererIfAny(comp, attr);
    }

    @Override
    public void addPropertyLoadBindings(Component comp, String attr, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException("loadExpr is null for component " + comp + ", attr " + attr);
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + converterExpr + "'";
        }
        this.addPropertyLoadBindings0(comp, attr, loadExpr, beforeCmds, afterCmds, bindingArgs, converterExpr, converterArgs);
        this.initRendererIfAny(comp, attr);
    }

    @Override
    public void addPropertySaveBindings(Component comp, String attr, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        this.checkInit();
        if (saveExpr == null) {
            throw new IllegalArgumentException("saveExpr is null for component " + comp + ", attr " + attr);
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + converterExpr + "'";
        }
        if (Strings.isBlank((String)validatorExpr) && (validatorExpr = this.getSystemValidator(comp, attr)) != null) {
            validatorExpr = "'" + validatorExpr + "'";
        }
        this.addPropertySaveBindings0(comp, attr, saveExpr, beforeCmds, afterCmds, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
    }

    private void addPropertyInitBinding0(Component comp, String attr, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getOverrideAnnotation(compCtrl, attr, "ZKBIND");
        String loadrep = null;
        Class attrType = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            loadrep = AnnotationUtil.testString((String[])attrs.get("LOAD_REPLACEMENT"), comp, attr, "LOAD_REPLACEMENT");
            String type = AnnotationUtil.testString((String[])attrs.get("LOAD_TYPE"), comp, attr, "LOAD_TYPE");
            if (type != null) {
                try {
                    attrType = Classes.forNameByThread((String)type);
                }
                catch (ClassNotFoundException e) {
                    throw new UiException(e.getMessage(), (Throwable)e);
                }
            }
        }
        String string = loadrep = loadrep == null ? attr : loadrep;
        if (_log.debugable()) {
            _log.debug("add init-binding: comp=[%s],attr=[%s],expr=[%s],converter=[%s]", new Object[]{comp, attr, initExpr, converterArgs});
        }
        InitPropertyBindingImpl binding = new InitPropertyBindingImpl(this, comp, attr, loadrep, attrType, initExpr, bindingArgs, converterExpr, converterArgs);
        this.addBinding(comp, attr, binding);
        BindingKey bkey = this.getBindingKey(comp, attr);
        this._propertyBindingHandler.addInitBinding(bkey, binding);
    }

    private String getSystemConverter(Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getOverrideAnnotation(compCtrl, attr, "ZKBIND");
        if (ann != null) {
            Map attrs = ann.getAttributes();
            return AnnotationUtil.testString((String[])attrs.get("CONVERTER"), comp, attr, "CONVERTER");
        }
        return null;
    }

    private String getSystemValidator(Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getOverrideAnnotation(compCtrl, attr, "ZKBIND");
        if (ann != null) {
            Map attrs = ann.getAttributes();
            return AnnotationUtil.testString((String[])attrs.get("VALIDATOR"), comp, attr, "VALIDATOR");
        }
        return null;
    }

    private void initRendererIfAny(Component comp, String attr) {
        String rendererName;
        Map attrs;
        Object installed = comp.getAttribute(RENDERER_INSTALLED);
        if (installed != null) {
            return;
        }
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getOverrideAnnotation(compCtrl, null, "ZKBIND");
        Map map = attrs = ann != null ? ann.getAttributes() : null;
        if (attrs != null && (rendererName = AnnotationUtil.testString((String[])attrs.get("RENDERER"), comp, attr, "RENDERER")) != null) {
            String[] values = null;
            values = rendererName.indexOf("=") != -1 ? rendererName.split("=", 2) : rendererName.split(":", 2);
            if (values != null) {
                Object renderer = this.getRenderer(values[1]);
                Object old = null;
                try {
                    old = Fields.get((Object)comp, (String)values[0]);
                }
                catch (NoSuchMethodException e1) {
                    // empty catch block
                }
                if (old == null) {
                    try {
                        Fields.set((Object)comp, (String)values[0], (Object)renderer, (boolean)false);
                    }
                    catch (Exception e) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                    if (renderer instanceof TemplateRendererCtrl) {
                        ((TemplateRendererCtrl)renderer).setAttributeName(attr);
                    }
                }
                comp.setAttribute(RENDERER_INSTALLED, (Object)"");
            }
        }
    }

    private void addPropertyLoadBindings0(Component comp, String attr, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getOverrideAnnotation(compCtrl, attr, "ZKBIND");
        String evtnm = null;
        String loadRep = null;
        Class attrType = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            String rw = AnnotationUtil.testString((String[])attrs.get("ACCESS"), comp, attr, "ACCESS");
            if (rw != null && !"both".equals(rw) && !"load".equals(rw)) {
                return;
            }
            evtnm = AnnotationUtil.testString((String[])attrs.get("LOAD_EVENT"), comp, attr, "LOAD_EVENT");
            loadRep = AnnotationUtil.testString((String[])attrs.get("LOAD_REPLACEMENT"), comp, attr, "LOAD_REPLACEMENT");
            String type = AnnotationUtil.testString((String[])attrs.get("LOAD_TYPE"), comp, attr, "LOAD_TYPE");
            if (type != null) {
                try {
                    attrType = Classes.forNameByThread((String)type);
                }
                catch (ClassNotFoundException e) {
                    throw new UiException(e.getMessage(), (Throwable)e);
                }
            }
        }
        String string = loadRep = loadRep == null ? attr : loadRep;
        if (prompt) {
            BindingKey bkey;
            if (_log.debugable()) {
                _log.debug("add event(prompt)-load-binding: comp=[%s],attr=[%s],expr=[%s],evtnm=[%s],converter=[%s]", new Object[]{comp, attr, loadExpr, evtnm, converterArgs});
            }
            LoadPropertyBindingImpl binding = new LoadPropertyBindingImpl(this, comp, attr, loadRep, attrType, loadExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs);
            this.addBinding(comp, attr, binding);
            if (evtnm != null) {
                this.registerCommandEventListener(comp, evtnm);
                this.addBinding(comp, evtnm, binding);
                bkey = this.getBindingKey(comp, evtnm);
                this._propertyBindingHandler.addLoadEventBinding(comp, bkey, binding);
            }
            bkey = this.getBindingKey(comp, attr);
            this._propertyBindingHandler.addLoadPromptBinding(comp, bkey, binding);
        } else {
            LoadPropertyBindingImpl binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = new LoadPropertyBindingImpl(this, comp, attr, loadRep, attrType, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.debugable()) {
                        _log.debug("add before command-load-binding: comp=[%s],att=r[%s],expr=[%s],converter=[%s]", new Object[]{comp, attr, loadExpr, converterExpr});
                    }
                    this._propertyBindingHandler.addLoadBeforeBinding(cmd, binding);
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = new LoadPropertyBindingImpl(this, comp, attr, loadRep, attrType, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.debugable()) {
                        _log.debug("add after command-load-binding: comp=[%s],att=r[%s],expr=[%s],converter=[%s]", new Object[]{comp, attr, loadExpr, converterExpr});
                    }
                    this._propertyBindingHandler.addLoadAfterBinding(cmd, binding);
                }
            }
        }
    }

    private void addPropertySaveBindings0(Component comp, String attr, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        BindingKey bkey;
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getOverrideAnnotation(compCtrl, attr, "ZKBIND");
        String evtnm = null;
        String saveRep = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            String rw = AnnotationUtil.testString((String[])attrs.get("ACCESS"), comp, attr, "ACCESS");
            if (!"both".equals(rw) && !"save".equals(rw)) {
                return;
            }
            evtnm = AnnotationUtil.testString((String[])attrs.get("SAVE_EVENT"), comp, attr, "SAVE_EVENT");
            saveRep = AnnotationUtil.testString((String[])attrs.get("SAVE_REPLACEMENT"), comp, attr, "SAVE_REPLACEMENT");
        }
        if (evtnm == null) {
            return;
        }
        String string = saveRep = saveRep == null ? attr : saveRep;
        if (prompt) {
            SavePropertyBindingImpl binding = new SavePropertyBindingImpl(this, comp, attr, saveRep, saveExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
            this.addBinding(comp, attr, binding);
            if (_log.debugable()) {
                _log.debug("add event(prompt)-save-binding: comp=[%s],attr=[%s],expr=[%s],evtnm=[%s],converter=[%s],validate=[%s]", new Object[]{comp, attr, saveExpr, evtnm, converterExpr, validatorExpr});
            }
            this.registerCommandEventListener(comp, evtnm);
            this.addBinding(comp, evtnm, binding);
            BindingKey bkey2 = this.getBindingKey(comp, evtnm);
            this._propertyBindingHandler.addSavePromptBinding(comp, bkey2, binding);
        } else {
            SavePropertyBindingImpl binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = new SavePropertyBindingImpl(this, comp, attr, saveRep, saveExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.debugable()) {
                        _log.debug("add before command-save-binding: comp=[%s],att=r[%s],expr=[%s],converter=[%s],validator=[%s]", new Object[]{comp, attr, saveExpr, converterExpr, validatorExpr});
                    }
                    this._propertyBindingHandler.addSaveBeforeBinding(cmd, binding);
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = new SavePropertyBindingImpl(this, comp, attr, saveRep, saveExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.debugable()) {
                        _log.debug("add after command-save-binding: comp=[%s],att=r[%s],expr=[%s],converter=[%s],validator=[%s]", new Object[]{comp, attr, saveExpr, converterExpr, validatorExpr});
                    }
                    this._propertyBindingHandler.addSaveAfterBinding(cmd, binding);
                }
            }
        }
        if (validatorExpr != null && !this._hasValidators.contains(bkey = this.getBindingKey(comp, attr))) {
            this._hasValidators.add(bkey);
        }
    }

    @Override
    @Deprecated
    public void addChildrenInitBinding(Component comp, String initExpr, Map<String, Object> initArgs) {
        this.addChildrenInitBinding(comp, initExpr, initArgs, null, null);
    }

    @Override
    public void addChildrenInitBinding(Component comp, String initExpr, Map<String, Object> initArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (initExpr == null) {
            throw new IllegalArgumentException("initExpr is null for children of " + comp);
        }
        this.addChildrenInitBinding0(comp, initExpr, initArgs, converterExpr, converterArgs);
    }

    @Override
    @Deprecated
    public void addChildrenLoadBindings(Component comp, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs) {
        this.addChildrenLoadBindings(comp, loadExpr, beforeCmds, afterCmds, bindingArgs, null, null);
    }

    @Override
    public void addChildrenLoadBindings(Component comp, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException("loadExpr is null for children of " + comp);
        }
        this.addChildrenLoadBindings0(comp, loadExpr, beforeCmds, afterCmds, bindingArgs, converterExpr, converterArgs);
    }

    private void addChildrenInitBinding0(Component comp, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        if (_log.debugable()) {
            _log.debug("add children-init-binding: comp=[%s],expr=[%s]", new Object[]{comp, initExpr});
        }
        InitChildrenBindingImpl binding = new InitChildrenBindingImpl(this, comp, initExpr, bindingArgs, converterExpr, converterArgs);
        this.addBinding(comp, CHILDREN_ATTR, binding);
        BindingKey bkey = this.getBindingKey(comp, CHILDREN_ATTR);
        this._childrenBindingHandler.addInitBinding(bkey, binding);
    }

    private void addChildrenLoadBindings0(Component comp, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        if (prompt) {
            if (_log.debugable()) {
                _log.debug("add event(prompt)-children-load-binding: comp=[%s],expr=[%s]", new Object[]{comp, loadExpr});
            }
            LoadChildrenBindingImpl binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs);
            this.addBinding(comp, CHILDREN_ATTR, binding);
            BindingKey bkey = this.getBindingKey(comp, CHILDREN_ATTR);
            this._childrenBindingHandler.addLoadPromptBinding(comp, bkey, binding);
        } else {
            LoadChildrenBindingImpl binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, CHILDREN_ATTR, binding);
                    if (_log.debugable()) {
                        _log.debug("add before command children-load-binding: comp=[%s],expr=[%s],cmd=[%s]", new Object[]{comp, loadExpr, cmd});
                    }
                    this._childrenBindingHandler.addLoadBeforeBinding(cmd, binding);
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, CHILDREN_ATTR, binding);
                    if (_log.debugable()) {
                        _log.debug("add after command children-load-binding: comp=[%s],expr=[%s],cmd=[%s]", new Object[]{comp, loadExpr, cmd});
                    }
                    this._childrenBindingHandler.addLoadAfterBinding(cmd, binding);
                }
            }
        }
    }

    @Override
    public void addReferenceBinding(Component comp, String attr, String loadExpr, Map<String, Object> bindingArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException("loadExpr is null for reference of " + comp);
        }
        this.addReferenceBinding0(comp, attr, loadExpr, bindingArgs);
    }

    private void addReferenceBinding0(Component comp, String attr, String loadExpr, Map<String, Object> bindingArgs) {
        if (_log.debugable()) {
            _log.debug("add reference-binding: comp=[%s],attr=[%s],expr=[%s]", new Object[]{comp, attr, loadExpr});
        }
        ReferenceBindingImpl binding = new ReferenceBindingImpl((Binder)this, loadExpr, comp);
        if (this._refBindingHandler == null) {
            throw new UiException("ref binding handler is not supported in current runtime.");
        }
        this._refBindingHandler.addReferenceBinding(comp, attr, binding);
        this.addBinding(comp, attr, binding);
    }

    private boolean isPrompt(String[] beforeCmds, String[] afterCmds) {
        return !(beforeCmds != null && beforeCmds.length != 0 || afterCmds != null && afterCmds.length != 0);
    }

    @Override
    public void addCommandBinding(Component comp, String evtnm, String commandExpr, Map<String, Object> args) {
        this.checkInit();
        CommandBindingImpl binding = new CommandBindingImpl(this, comp, evtnm, commandExpr, args);
        this.addBinding(comp, evtnm, binding);
        this.registerCommandEventListener(comp, evtnm, binding, false);
    }

    @Override
    public void addGlobalCommandBinding(Component comp, String evtnm, String commandExpr, Map<String, Object> args) {
        this.checkInit();
        CommandBindingImpl binding = new CommandBindingImpl(this, comp, evtnm, commandExpr, args);
        this.addBinding(comp, evtnm, binding);
        this.registerCommandEventListener(comp, evtnm, binding, true);
    }

    private void registerCommandEventListener(Component comp, String evtnm, CommandBinding command, boolean global) {
        CommandEventListener listener = this.getCommandEventListener(comp, evtnm);
        if (global) {
            listener.setGlobalCommand(command);
        } else {
            listener.setCommand(command);
        }
    }

    private void registerCommandEventListener(Component comp, String evtnm) {
        CommandEventListener listener = this.getCommandEventListener(comp, evtnm);
        listener.setPrompt(true);
    }

    private CommandEventListener getCommandEventListener(Component comp, String evtnm) {
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        CommandEventListener listener = this._listenerMap.get(bkey);
        if (listener == null) {
            listener = new CommandEventListener(comp);
            comp.addEventListener(evtnm, (EventListener)listener);
            this._listenerMap.put(bkey, listener);
        }
        return listener;
    }

    private void removeEventCommandListenerIfExists(Component comp, String evtnm) {
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        CommandEventListener listener = this._listenerMap.remove(bkey);
        if (listener != null) {
            comp.removeEventListener(evtnm, (EventListener)listener);
        }
    }

    @Override
    public boolean isActivating() {
        return this._activating;
    }

    private void notifyVMsgsChanged() {
        if (this._validationMessages != null) {
            Events.postEvent((int)-1, (Component)this._dummyTarget, (Event)new Event(ON_VMSGS_CHANGED));
        }
    }

    @Override
    public void sendCommand(String command, Map<String, Object> args) {
        this.checkInit();
        HashSet<Property> notifys = new HashSet<Property>();
        this.doCommand(this._rootComp, command, null, args, notifys);
        this.fireNotifyChanges(notifys);
    }

    private void fireNotifyChanges(Set<Property> notifys) {
        for (Property prop : notifys) {
            this.notifyChange(prop.getBase(), prop.getProperty());
        }
    }

    @Override
    public void postCommand(String command, Map<String, Object> args) {
        this.checkInit();
        Event evt = new Event(ON_POST_COMMAND, this._dummyTarget, (Object)new Object[]{command, args});
        Events.postEvent((Event)evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCommand(Component comp, String command, Event evt, Map<String, Object> commandArgs, Set<Property> notifys) {
        String evtnm;
        String string = evtnm = evt == null ? null : evt.getName();
        if (_log.debugable()) {
            _log.debug("Start doCommand comp=[%s],command=[%s],evtnm=[%s]", new Object[]{comp, command, evtnm});
        }
        BindContext ctx = BindContextUtil.newBindContext(this, null, false, command, comp, evt);
        BindContextUtil.setCommandArgs(this, comp, ctx, commandArgs);
        try {
            this.doPrePhase(Phase.COMMAND, ctx);
            boolean success = true;
            success = this.doValidate(comp, command, evt, ctx, notifys);
            if (!success) {
                int n = 1;
                return n;
            }
            this.doSaveBefore(comp, command, evt, ctx, notifys);
            this.doLoadBefore(comp, command, ctx);
            this.doExecute(comp, command, commandArgs, ctx, notifys);
            this.doSaveAfter(comp, command, evt, ctx, notifys);
            this.doLoadAfter(comp, command, ctx);
            if (_log.debugable()) {
                _log.debug("End doCommand");
            }
            int n = 0;
            return n;
        }
        finally {
            this.doPostPhase(Phase.COMMAND, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGlobalCommand(Component comp, String command, Map<String, Object> commandArgs, Set<Property> notifys) {
        if (_log.debugable()) {
            _log.debug("Start doGlobalCommand comp=[%s],command=[%s]", new Object[]{comp, command});
        }
        BindContext ctx = BindContextUtil.newBindContext(this, null, false, command, comp, null);
        BindContextUtil.setCommandArgs(this, comp, ctx, commandArgs);
        try {
            this.doPrePhase(Phase.GLOBAL_COMMAND, ctx);
            this.doGlobalCommandExecute(comp, command, commandArgs, ctx, notifys);
        }
        finally {
            this.doPostPhase(Phase.GLOBAL_COMMAND, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGlobalCommandExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        try {
            if (_log.debugable()) {
                _log.debug("before doGlobalCommandExecute comp=[%s],command=[%s]", new Object[]{comp, command});
            }
            this.doPrePhase(Phase.EXECUTE, ctx);
            Object viewModel = this.getViewModel();
            Method method = this.getGlobalCommandMethod(viewModel.getClass(), command);
            if (method != null) {
                ParamCall parCall = this.createParamCall(ctx);
                if (commandArgs != null) {
                    parCall.setBindingArgs(commandArgs);
                }
                parCall.call(viewModel, method);
                notifys.addAll(BindELContext.getNotifys(method, viewModel, null, null, ctx));
            } else if (_log.debugable()) {
                _log.debug("no global command method in [%s]", new Object[]{viewModel});
            }
            if (_log.debugable()) {
                _log.debug("after doGlobalCommandExecute notifys=[%s]", new Object[]{notifys});
            }
        }
        finally {
            this.doPostPhase(Phase.EXECUTE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getGlobalCommandMethod(Class<?> clz, String command) {
        CachedItem<Method> method;
        Map<String, CachedItem<Method>> methods = null;
        Map<Class<?>, Map<String, CachedItem<Method>>> map = _globalCommandMethodCache;
        synchronized (map) {
            methods = _globalCommandMethodCache.get(clz);
            if (methods == null) {
                methods = new HashMap<String, CachedItem<Method>>();
                _globalCommandMethodCache.put(clz, methods);
            }
        }
        Map<String, CachedItem<Method>> map2 = methods;
        synchronized (map2) {
            method = methods.get(command);
            if (method != null) {
                return (Method)method.value;
            }
            for (Method m : clz.getMethods()) {
                GlobalCommand cmd = m.getAnnotation(GlobalCommand.class);
                if (cmd == null) continue;
                String[] vals = cmd.value();
                if (vals.length == 0) {
                    vals = new String[]{m.getName()};
                }
                for (String val : vals) {
                    if (!command.equals(val)) continue;
                    if (method != null) {
                        throw new UiException("there are more than one method listen to global-command " + command + " in " + clz);
                    }
                    method = new CachedItem<Method>(m);
                }
            }
            if (method == null) {
                method = new CachedItem<Object>(null);
            }
            methods.put(command, method);
        }
        return (Method)method.value;
    }

    void doPrePhase(Phase phase, BindContext ctx) {
        if (this._phaseListener != null) {
            this._phaseListener.prePhase(phase, ctx);
        }
    }

    void doPostPhase(Phase phase, BindContext ctx) {
        if (this._phaseListener != null) {
            this._phaseListener.postPhase(phase, ctx);
        }
    }

    private boolean doSaveEvent(Component comp, Event evt, Set<Property> notifys) {
        String evtnm;
        String string = evtnm = evt == null ? null : evt.getName();
        if (_log.debugable()) {
            _log.debug("doSaveEvent comp=[%s],evtnm=[%s],notifys=[%s]", new Object[]{comp, evtnm, notifys});
        }
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        return this._propertyBindingHandler.doSaveEvent(bkey, comp, evt, notifys);
    }

    private void doLoadEvent(Component comp, String evtnm) {
        if (_log.debugable()) {
            _log.debug("doLoadEvent comp=[%s],evtnm=[%s]", new Object[]{comp, evtnm});
        }
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        this._propertyBindingHandler.doLoadEvent(bkey, comp, evtnm);
    }

    private boolean doValidate(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        HashSet<Property> validates = new HashSet<Property>();
        try {
            if (_log.debugable()) {
                _log.debug("doValidate comp=[%s],command=[%s],evt=[%s],context=[%s]", new Object[]{comp, command, evt, ctx});
            }
            this.doPrePhase(Phase.VALIDATE, ctx);
            ValidationHelper vHelper = new ValidationHelper(this, new ValidationHelper.InfoProvider(){

                @Override
                public Map<String, List<SaveFormBinding>> getSaveFormBeforeBindings() {
                    return BinderImpl.this._formBindingHandler.getSaveFormBeforeBindings();
                }

                @Override
                public Map<String, List<SaveFormBinding>> getSaveFormAfterBindings() {
                    return BinderImpl.this._formBindingHandler.getSaveFormAfterBindings();
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveBeforeBindings() {
                    return BinderImpl.this._propertyBindingHandler.getSaveBeforeBindings();
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveAfterBindings() {
                    return BinderImpl.this._propertyBindingHandler.getSaveAfterBindings();
                }

                @Override
                public BindingKey getBindingKey(Component comp, String attr) {
                    return BinderImpl.this.getBindingKey(comp, attr);
                }
            });
            vHelper.collectSaveBefore(comp, command, evt, validates);
            vHelper.collectSaveAfter(comp, command, evt, validates);
            if (validates.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (_log.debugable()) {
                _log.debug("doValidate validates=[%s]", new Object[]{validates});
            }
            boolean valid = true;
            Map<String, Property[]> properties = this._propertyBindingHandler.toCollectedProperties(validates);
            valid &= vHelper.validateSaveBefore(comp, command, properties, valid, notifys);
            valid &= vHelper.validateSaveAfter(comp, command, properties, valid, notifys);
            for (Property p : validates) {
                if (!(p instanceof WrongValuePropertyImpl)) continue;
                for (WrongValueException wve : ((WrongValuePropertyImpl)p).getWrongValueExceptions()) {
                    Component wvc = wve.getComponent();
                    if (wvc == null || (wve = ((ComponentCtrl)wvc).onWrongValue(wve)) == null) continue;
                    Component c = wve.getComponent();
                    if (c == null) {
                        c = wvc;
                    }
                    Clients.wrongValue((Component)c, (String)wve.getMessage());
                }
                valid = false;
            }
            boolean bl = valid;
            return bl;
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        finally {
            this.doPostPhase(Phase.VALIDATE, ctx);
        }
    }

    private ParamCall createParamCall(BindContext ctx) {
        Execution exec;
        ParamCall call = new ParamCall();
        call.setBinder(this);
        call.setBindContext(ctx);
        Component comp = ctx.getComponent();
        if (comp != null) {
            call.setComponent(comp);
        }
        if ((exec = Executions.getCurrent()) != null) {
            call.setExecution(exec);
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        try {
            ParamCall parCall;
            if (_log.debugable()) {
                _log.debug("before doExecute comp=[%s],command=[%s],notifys=[%s]", new Object[]{comp, command, notifys});
            }
            this.doPrePhase(Phase.EXECUTE, ctx);
            Object viewModel = this.getViewModel();
            Method method = this.getCommandMethod(viewModel.getClass(), command);
            if (method != null) {
                parCall = this.createParamCall(ctx);
                if (commandArgs != null) {
                    parCall.setBindingArgs(commandArgs);
                }
            } else {
                throw new UiException("cannot find any method that is annotated for the command " + command + " with @Command in " + viewModel);
            }
            parCall.call(viewModel, method);
            notifys.addAll(BindELContext.getNotifys(method, viewModel, null, null, ctx));
            if (_log.debugable()) {
                _log.debug("after doExecute notifys=[%s]", new Object[]{notifys});
            }
        }
        finally {
            this.doPostPhase(Phase.EXECUTE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getCommandMethod(Class<?> clz, String command) {
        CachedItem<Method> method;
        Map<String, CachedItem<Method>> methods = _commandMethodCache.get(clz);
        Map<Class<?>, Map<String, CachedItem<Method>>> map = _commandMethodCache;
        synchronized (map) {
            methods = _commandMethodCache.get(clz);
            if (methods == null) {
                methods = new HashMap<String, CachedItem<Method>>();
                _commandMethodCache.put(clz, methods);
            }
        }
        Map<String, CachedItem<Method>> map2 = methods;
        synchronized (map2) {
            method = methods.get(command);
            if (method != null) {
                return (Method)method.value;
            }
            for (Method m : clz.getMethods()) {
                Command cmd = m.getAnnotation(Command.class);
                if (cmd == null) continue;
                String[] vals = cmd.value();
                if (vals.length == 0) {
                    vals = new String[]{m.getName()};
                }
                for (String val : vals) {
                    if (!command.equals(val)) continue;
                    if (method != null) {
                        throw new UiException("there are more than one method listen to command " + command + " in " + clz);
                    }
                    method = new CachedItem<Method>(m);
                }
            }
            if (method == null) {
                method = new CachedItem<Object>(null);
            }
            methods.put(command, method);
        }
        return (Method)method.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveBefore(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        if (_log.debugable()) {
            _log.debug("doSaveBefore, comp=[%s],command=[%s],evt=[%s],notifys=[%s]", new Object[]{comp, command, evt, notifys});
        }
        try {
            this.doPrePhase(Phase.SAVE_BEFORE, ctx);
            this._propertyBindingHandler.doSaveBefore(comp, command, evt, notifys);
            this._formBindingHandler.doSaveBefore(comp, command, evt, notifys);
        }
        finally {
            this.doPostPhase(Phase.SAVE_BEFORE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveAfter(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        if (_log.debugable()) {
            _log.debug("doSaveAfter, comp=[%s],command=[%s],evt=[%s],notifys=[%s]", new Object[]{comp, command, evt, notifys});
        }
        try {
            this.doPrePhase(Phase.SAVE_AFTER, ctx);
            this._propertyBindingHandler.doSaveAfter(comp, command, evt, notifys);
            this._formBindingHandler.doSaveAfter(comp, command, evt, notifys);
        }
        finally {
            this.doPostPhase(Phase.SAVE_AFTER, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadBefore(Component comp, String command, BindContext ctx) {
        if (_log.debugable()) {
            _log.debug("doLoadBefore, comp=[%s],command=[%s]", new Object[]{comp, command});
        }
        try {
            this.doPrePhase(Phase.LOAD_BEFORE, ctx);
            this._propertyBindingHandler.doLoadBefore(comp, command);
            this._formBindingHandler.doLoadBefore(comp, command);
            this._childrenBindingHandler.doLoadBefore(comp, command);
        }
        finally {
            this.doPostPhase(Phase.LOAD_BEFORE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadAfter(Component comp, String command, BindContext ctx) {
        if (_log.debugable()) {
            _log.debug("doLoadAfter, comp=[%s],command=[%s]", new Object[]{comp, command});
        }
        try {
            this.doPrePhase(Phase.LOAD_AFTER, ctx);
            this._propertyBindingHandler.doLoadAfter(comp, command);
            this._formBindingHandler.doLoadAfter(comp, command);
            this._childrenBindingHandler.doLoadAfter(comp, command);
        }
        finally {
            this.doPostPhase(Phase.LOAD_AFTER, ctx);
        }
    }

    @Override
    public void removeBindings(Component comp) {
        Map<String, List<Binding>> attrMap;
        this.checkInit();
        if (this._rootComp == comp) {
            this.unsubscribeQueue(this._quename, this._quescope, this._queueListener);
            this._rootComp.removeAttribute(ACTIVATOR);
        }
        if (this._validationMessages != null) {
            this._validationMessages.clearMessages(comp);
        }
        if ((attrMap = this._bindings.remove(comp)) != null) {
            HashSet<Binding> removed = new HashSet<Binding>();
            for (Map.Entry<String, List<Binding>> entry : attrMap.entrySet()) {
                String key = entry.getKey();
                this.removeBindings(comp, key);
                removed.addAll((Collection<Binding>)entry.getValue());
            }
            if (!removed.isEmpty()) {
                this.removeBindings(removed);
            }
        }
        this.removeFormAssociatedSaveBinding(comp);
        this.removeForm(comp);
        this.removeTemplateResolver(comp);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.removeReferenceBinding(comp);
        }
        TrackerImpl tracker = (TrackerImpl)this.getTracker();
        tracker.removeTrackings(comp);
        comp.removeAttribute(BINDER);
    }

    @Override
    public void removeBindings(Component comp, String key) {
        this.checkInit();
        this.removeEventCommandListenerIfExists(comp, key);
        BindingKey bkey = this.getBindingKey(comp, key);
        HashSet<Binding> removed = new HashSet<Binding>();
        this._formBindingHandler.removeBindings(bkey, removed);
        this._propertyBindingHandler.removeBindings(bkey, removed);
        this._childrenBindingHandler.removeBindings(bkey, removed);
        if (this._validationMessages != null) {
            this._validationMessages.clearMessages(comp, key);
        }
        this._hasValidators.remove(bkey);
        this.removeTemplateResolver(comp, key);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.removeReferenceBinding(comp, key);
        }
        this.removeBindings(removed);
    }

    @Override
    public List<Binding> getLoadPromptBindings(Component comp, String attr) {
        List<LoadChildrenBinding> childrenLoadBindings;
        this.checkInit();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        BindingKey bkey = this.getBindingKey(comp, attr);
        List<LoadPropertyBinding> loadBindings = this._propertyBindingHandler.getLoadPromptBindings(bkey);
        if (loadBindings != null && loadBindings.size() > 0) {
            bindings.addAll(loadBindings);
        }
        if (bindings.size() == 0 && (childrenLoadBindings = this._childrenBindingHandler.getLoadPromptBindings(bkey)) != null && childrenLoadBindings.size() > 0) {
            bindings.addAll(childrenLoadBindings);
        }
        return bindings;
    }

    private void removeBindings(Collection<Binding> removed) {
        this._formBindingHandler.removeBindings(removed);
        this._propertyBindingHandler.removeBindings(removed);
        this._childrenBindingHandler.removeBindings(removed);
    }

    private void addBinding(Component comp, String attr, Binding binding) {
        List<Binding> bindings;
        Map<String, List<Binding>> attrMap = this._bindings.get(comp);
        if (attrMap == null) {
            attrMap = new LinkedHashMap<String, List<Binding>>();
            this._bindings.put(comp, attrMap);
        }
        if ((bindings = attrMap.get(attr)) == null) {
            bindings = new ArrayList<Binding>();
            attrMap.put(attr, bindings);
        }
        bindings.add(binding);
        comp.setAttribute(BINDER, (Object)this);
    }

    @Override
    public void setTemplate(Component comp, String attr, String templateExpr, Map<String, Object> templateArgs) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        if (resolvers == null) {
            resolvers = new HashMap<String, TemplateResolver>();
            this._templateResolvers.put(comp, resolvers);
        }
        resolvers.put(attr, new TemplateResolverImpl(this, comp, attr, templateExpr, templateArgs));
    }

    @Override
    public TemplateResolver getTemplateResolver(Component comp, String attr) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        return resolvers == null ? null : resolvers.get(attr);
    }

    private void removeTemplateResolver(Component comp, String attr) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        if (resolvers != null) {
            resolvers.remove(attr);
        }
    }

    private void removeTemplateResolver(Component comp) {
        this._templateResolvers.remove(comp);
    }

    @Override
    public Tracker getTracker() {
        if (this._tracker == null) {
            this._tracker = new TrackerImpl();
        }
        return this._tracker;
    }

    @Override
    public void loadComponent(Component comp, boolean loadinit) {
        this.loadComponentProperties(comp, loadinit);
        for (Component kid = comp.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            this.loadComponent(kid, loadinit);
        }
    }

    private void loadComponentProperties(Component comp, boolean loadinit) {
        Map<String, List<Binding>> compBindings = this._bindings.get(comp);
        if (compBindings != null) {
            BindingKey bkey;
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                this._formBindingHandler.doInit(comp, bkey);
                this._formBindingHandler.doLoad(comp, bkey);
            }
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                this._propertyBindingHandler.doInit(comp, bkey);
                this._propertyBindingHandler.doLoad(comp, bkey);
            }
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                this._childrenBindingHandler.doInit(comp, bkey);
                this._childrenBindingHandler.doLoad(comp, bkey);
            }
        }
    }

    @Override
    public void notifyChange(Object base, String attr) {
        this.checkInit();
        if (_log.debugable()) {
            _log.debug("notifyChange base=[%s],attr=[%s]", new Object[]{base, attr});
        }
        this.getEventQueue().publish((Event)new PropertyChangeEvent(this._rootComp, base, attr));
    }

    private void postGlobalCommand(String command, Map<String, Object> args) {
        if (_log.debugable()) {
            _log.debug("postGlobalCommand command=[%s], args=[%s]", new Object[]{command, args});
        }
        this.getEventQueue().publish((Event)new GlobalCommandEvent(this._rootComp, command, args));
    }

    @Override
    public void setPhaseListener(PhaseListener listener) {
        this._phaseListener = listener;
    }

    @Override
    public PhaseListener getPhaseListener() {
        return this._phaseListener;
    }

    private void subscribeQueue(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)true);
        que.subscribe(listener);
    }

    private void unsubscribeQueue(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)false);
        if (que != null) {
            que.unsubscribe(listener);
        }
    }

    protected EventQueue<Event> getEventQueue() {
        return EventQueues.lookup((String)this._quename, (String)this._quescope, (boolean)true);
    }

    private BindingKey getBindingKey(Component comp, String attr) {
        return new BindingKey(comp, attr);
    }

    private void removeFormAssociatedSaveBinding(Component comp) {
        this._assocFormSaveBindings.remove(comp);
        Map<SaveBinding, Set<SaveBinding>> associated = this._reversedAssocFormSaveBindings.remove(comp);
        if (associated != null) {
            Set<Map.Entry<SaveBinding, Set<SaveBinding>>> entries = associated.entrySet();
            for (Map.Entry<SaveBinding, Set<SaveBinding>> entry : entries) {
                entry.getValue().remove(entry.getKey());
            }
        }
    }

    @Override
    public void addFormAssociatedSaveBinding(Component associatedComp, String formId, SaveBinding saveBinding, String fieldName) {
        this.checkInit();
        Component formComp = this.lookupAossicatedFormComponent(formId, associatedComp);
        if (formComp == null) {
            throw new UiException("cannot find any form " + formId + " with " + associatedComp);
        }
        Set<SaveBinding> bindings = this._assocFormSaveBindings.get(formComp);
        if (bindings == null) {
            bindings = new LinkedHashSet<SaveBinding>();
            this._assocFormSaveBindings.put(formComp, bindings);
        }
        bindings.add(saveBinding);
        Map<SaveBinding, Set<SaveBinding>> reverseMap = this._reversedAssocFormSaveBindings.get(associatedComp);
        if (reverseMap == null) {
            reverseMap = new HashMap<SaveBinding, Set<SaveBinding>>();
            this._reversedAssocFormSaveBindings.put(associatedComp, reverseMap);
        }
        reverseMap.put(saveBinding, bindings);
        ((SavePropertyBindingImpl)saveBinding).setFormFieldInfo(formComp, formId, fieldName);
    }

    private Component lookupAossicatedFormComponent(String formId, Component associatedComp) {
        Component p;
        String fid = null;
        for (p = associatedComp; !(p == null || (fid = (String)p.getAttribute(FORM_ID)) != null && fid.equals(formId)); p = p.getParent()) {
        }
        return p;
    }

    @Override
    public Set<SaveBinding> getFormAssociatedSaveBindings(Component comp) {
        this.checkInit();
        Set<SaveBinding> bindings = this._assocFormSaveBindings.get(comp);
        if (bindings == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<SaveBinding>(bindings);
    }

    @Override
    public boolean hasValidator(Component comp, String attr) {
        BindingKey bkey = this.getBindingKey(comp, attr);
        return this._hasValidators.contains(bkey);
    }

    @Override
    public Component getView() {
        this.checkInit();
        return this._rootComp;
    }

    @Override
    public ValidationMessages getValidationMessages() {
        return this._validationMessages;
    }

    @Override
    public void setValidationMessages(ValidationMessages messages) {
        this._validationMessages = messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void didActivate() {
        this._activating = true;
        try {
            _log.debug("didActivate : [%s]", new Object[]{this});
            this.loadComponent(this._rootComp, false);
        }
        finally {
            this._activating = false;
        }
    }

    private class DeferredActivator
    implements ExecutionInit,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DeferredActivator() {
        }

        public void init(Execution exec, Execution parent) throws Exception {
            Desktop desktop = exec.getDesktop();
            desktop.removeListener((Object)this);
            BinderImpl.this._deferredActivator = null;
            BinderImpl.this.didActivate();
        }
    }

    private class Activator
    implements ComponentActivationListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Activator() {
        }

        public void didActivate(Component comp) {
            if (BinderImpl.this._rootComp.equals(comp) && BinderImpl.this._deferredActivator == null) {
                BinderImpl.this.subscribeQueue(BinderImpl.this._quename, BinderImpl.this._quescope, (EventListener<Event>)BinderImpl.this._queueListener);
                comp.getDesktop().addListener((Object)(BinderImpl.this._deferredActivator = new DeferredActivator()));
            }
        }

        public void willPassivate(Component comp) {
            if (BinderImpl.this._rootComp.equals(comp)) {
                _log.debug("willPassivate : [%s]", new Object[]{comp});
                if (BinderImpl.this._deferredActivator != null) {
                    comp.getDesktop().removeListener((Object)BinderImpl.this._deferredActivator);
                    BinderImpl.this._deferredActivator = null;
                }
                BinderImpl.this.unsubscribeQueue(BinderImpl.this._quename, BinderImpl.this._quescope, (EventListener<Event>)BinderImpl.this._queueListener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedItem<T> {
        final T value;

        public CachedItem(T value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostCommandListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PostCommandListener() {
        }

        public void onEvent(Event event) throws Exception {
            Object[] data = (Object[])event.getData();
            String command = (String)data[0];
            Map args = (Map)data[1];
            BinderImpl.this.sendCommand(command, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VMsgsChangedListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private VMsgsChangedListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (BinderImpl.this._validationMessages != null) {
                HashSet<PropertyImpl> notify = new HashSet<PropertyImpl>();
                notify.add(new PropertyImpl(BinderImpl.this._validationMessages, ".", null));
                BinderImpl.this.fireNotifyChanges(notify);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommandEventListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean _prompt = false;
        private CommandBinding _commandBinding;
        private CommandBinding _globalCommandBinding;
        private final Component _target;

        CommandEventListener(Component target) {
            this._target = target;
        }

        private void setCommand(CommandBinding command) {
            this._commandBinding = command;
        }

        private void setGlobalCommand(CommandBinding command) {
            this._globalCommandBinding = command;
        }

        private void setPrompt(boolean prompt) {
            this._prompt = prompt;
        }

        public void onEvent(Event event) throws Exception {
            try {
                this.onEvent0(event);
            }
            catch (Exception x) {
                _log.error(x.getMessage(), (Throwable)x);
                throw x;
            }
        }

        private void onEvent0(Event event) throws Exception {
            BindEvaluatorX eval;
            Component comp = this._target;
            String evtnm = event.getName();
            LinkedHashSet notifys = new LinkedHashSet();
            int cmdResult = 0;
            boolean promptResult = true;
            String command = null;
            if (_log.debugable()) {
                _log.debug("====Start command event [%s]", new Object[]{event});
            }
            if (this._prompt) {
                promptResult = BinderImpl.this.doSaveEvent(comp, event, notifys);
            }
            if (this._commandBinding != null && !Strings.isEmpty((String)(command = (String)(eval = BinderImpl.this.getEvaluatorX()).getValue(null, comp, ((CommandBindingImpl)this._commandBinding).getCommand())))) {
                Map<String, Object> implicit = null;
                if (BinderImpl.this._implicitContributor != null) {
                    implicit = BinderImpl.this._implicitContributor.contirbuteCommandObject(BinderImpl.this, this._commandBinding, event);
                }
                Map<String, Object> args = BindEvaluatorXUtil.evalArgs(eval, comp, this._commandBinding.getArgs(), implicit);
                cmdResult = BinderImpl.this.doCommand(comp, command, event, args, notifys);
            }
            if (this._prompt && promptResult) {
                if (_log.debugable()) {
                    _log.debug("This is a prompt command");
                }
                BinderImpl.this.doLoadEvent(comp, evtnm);
            }
            BinderImpl.this.notifyVMsgsChanged();
            if (_log.debugable()) {
                _log.debug("There are [%s] property need to be notify after event = [%s], command = [%s]", new Object[]{notifys.size(), evtnm, command});
            }
            BinderImpl.this.fireNotifyChanges(notifys);
            if (cmdResult == 0 && this._globalCommandBinding != null && !Strings.isEmpty((String)(command = (String)(eval = BinderImpl.this.getEvaluatorX()).getValue(null, comp, ((CommandBindingImpl)this._globalCommandBinding).getCommand())))) {
                Map<String, Object> args = BindEvaluatorXUtil.evalArgs(eval, comp, this._globalCommandBinding.getArgs());
                BinderImpl.this.postGlobalCommand(command, args);
            }
            if (_log.debugable()) {
                _log.debug("====End command event [%s]", new Object[]{event});
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private QueueListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (event instanceof PropertyChangeEvent) {
                PropertyChangeEvent evt = (PropertyChangeEvent)event;
                BinderImpl.this.loadOnPropertyChange(evt.getBase(), evt.getProperty());
            } else if (event instanceof GlobalCommandEvent) {
                GlobalCommandEvent evt = (GlobalCommandEvent)event;
                LinkedHashSet notifys = new LinkedHashSet();
                BinderImpl.this.doGlobalCommand(BinderImpl.this._rootComp, evt.getCommand(), evt.getArgs(), notifys);
                BinderImpl.this.fireNotifyChanges(notifys);
                BinderImpl.this.notifyVMsgsChanged();
            }
        }
    }
}

