/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.lang.Strings;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateBinderHelper {
    private final Binder _binder;
    private static final String INIT_ANNO = "init";
    private static final String BIND_ANNO = "bind";
    private static final String LOAD_ANNO = "load";
    private static final String SAVE_ANNO = "save";
    private static final String REFERENCE_ANNO = "ref";
    private static final String ID_ANNO = "id";
    private static final String VALIDATOR_ANNO = "validator";
    private static final String CONVERTER_ANNO = "converter";
    private static final String TEMPLATE_ANNO = "template";
    private static final String COMMAND_ANNO = "command";
    private static final String GLOBAL_COMMAND_ANNO = "global-command";
    public static final String FORM_ATTR = "form";
    public static final String VIEW_MODEL_ATTR = "viewModel";
    public static final String BINDER_ATTR = "binder";
    public static final String CHILDREN_ATTR = "children";
    public static final String CHILDREN_KEY = "$CHILDREN$";

    public AnnotateBinderHelper(Binder binder) {
        this._binder = binder;
    }

    public void initComponentBindings(Component comp) {
        this.processAllComponentsBindings(comp);
    }

    private void processAllComponentsBindings(Component comp) {
        Binder selfBinder = (Binder)comp.getAttribute("$BINDER$");
        if (selfBinder != null) {
            return;
        }
        this.processComponentBindings0(comp);
        for (Component kid : comp.getChildren()) {
            this.processAllComponentsBindings(kid);
        }
    }

    private void processComponentBindings0(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        List props = compCtrl.getAnnotatedProperties();
        for (String propName : props) {
            if (this.isEventProperty(propName)) {
                this.processCommandBinding(comp, propName);
                this.processGlobalCommandBinding(comp, propName);
                continue;
            }
            if (FORM_ATTR.equals(propName)) {
                this.processFormBindings(comp);
                continue;
            }
            if (CHILDREN_ATTR.equals(propName)) {
                this.processChildrenBindings(comp);
                continue;
            }
            if (VIEW_MODEL_ATTR.equals(propName) || BINDER_ATTR.equals(propName)) continue;
            this.processPropertyBindings(comp, propName);
        }
    }

    private boolean isEventProperty(String propName) {
        return propName.startsWith("on") && propName.length() >= 3 && Character.isUpperCase(propName.charAt(2));
    }

    private void processCommandBinding(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(propName, COMMAND_ANNO);
        if (anncol.size() == 0) {
            return;
        }
        if (anncol.size() > 1) {
            throw new IllegalSyntaxException("Allow only one command binding for event " + propName + " of " + compCtrl);
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        HashMap<String, String[]> args = null;
        ArrayList<String> cmdExprs = new ArrayList<String>();
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                cmdExprs.add(AnnotationUtil.testString(tagExpr, comp, propName, tag));
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        for (String cmd : cmdExprs) {
            this._binder.addCommandBinding(comp, propName, cmd, parsedArgs);
        }
    }

    private void processGlobalCommandBinding(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(propName, GLOBAL_COMMAND_ANNO);
        if (anncol.size() == 0) {
            return;
        }
        if (anncol.size() > 1) {
            throw new IllegalSyntaxException("Allow only one global-command binding for event " + propName + " of " + compCtrl);
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        HashMap<String, String[]> args = null;
        ArrayList<String> cmdExprs = new ArrayList<String>();
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                cmdExprs.add(AnnotationUtil.testString(tagExpr, comp, propName, tag));
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        for (String cmd : cmdExprs) {
            this._binder.addGlobalCommandBinding(comp, propName, cmd, parsedArgs);
        }
    }

    private void processPropertyBindings(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        ExpressionAnnoInfo validatorInfo = this.parseValidator(compCtrl, propName);
        ExpressionAnnoInfo converterInfo = this.parseConverter(compCtrl, propName);
        Collection initannos = compCtrl.getAnnotations(propName, INIT_ANNO);
        if (initannos.size() > 1) {
            throw new IllegalSyntaxException("Allow only one @init for " + propName + " of " + comp);
        }
        if (initannos.size() == 1) {
            this.processPropertyInit(comp, propName, (Annotation)initannos.iterator().next(), converterInfo);
        }
        Collection annos = compCtrl.getAnnotations(propName);
        for (Annotation anno : annos) {
            if (anno.getName().equals(BIND_ANNO)) {
                this.processPropertyPromptBindings(comp, propName, anno, converterInfo, validatorInfo);
                continue;
            }
            if (anno.getName().equals(LOAD_ANNO)) {
                this.processPropertyLoadBindings(comp, propName, anno, converterInfo);
                continue;
            }
            if (anno.getName().equals(SAVE_ANNO)) {
                this.processPropertySaveBindings(comp, propName, anno, converterInfo, validatorInfo);
                continue;
            }
            if (!anno.getName().equals(REFERENCE_ANNO)) continue;
            this.processReferenceBinding(comp, propName, anno);
        }
        ExpressionAnnoInfo templateInfo = this.parseTemplate(compCtrl, propName);
        if (templateInfo != null) {
            this._binder.setTemplate(comp, propName, templateInfo.expr, templateInfo.args);
        }
    }

    private void processReferenceBinding(Component comp, String propName, Annotation anno) {
        String loadExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : anno.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, comp, propName, tag);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addReferenceBinding(comp, propName, loadExpr, parsedArgs);
    }

    private void processPropertyInit(Component comp, String propName, Annotation anno, ExpressionAnnoInfo converterInfo) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : anno.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, comp, propName, tag);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addPropertyInitBinding(comp, propName, initExpr, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
    }

    private void processPropertyPromptBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo, ExpressionAnnoInfo validatorInfo) {
        String expr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                expr = AnnotationUtil.testString(tagExpr, comp, propName, tag);
                continue;
            }
            if ("before".equals(tag)) {
                throw new IllegalSyntaxException("@bind is for prompt binding only, doesn't support before commands, check property " + propName + " of " + comp);
            }
            if ("after".equals(tag)) {
                throw new IllegalSyntaxException("@bind is for prompt binding only, doesn't support after commands, check property " + propName + " of " + comp);
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addPropertyLoadBindings(comp, propName, expr, null, null, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        this._binder.addPropertySaveBindings(comp, propName, expr, null, null, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
    }

    private void addCommand(Component comp, List<String> cmds, String[] cmdExprs) {
        for (String cmdExpr : cmdExprs) {
            this.addCommand(comp, cmds, cmdExpr);
        }
    }

    private void addCommand(Component comp, List<String> cmds, String cmdExpr) {
        cmds.add(BindEvaluatorXUtil.eval(this._binder.getEvaluatorX(), comp, cmdExpr, String.class));
    }

    private void processPropertyLoadBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, comp, propName, tag);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addPropertyLoadBindings(comp, propName, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
    }

    private void processPropertySaveBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo, ExpressionAnnoInfo validatorInfo) {
        String saveExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                saveExpr = AnnotationUtil.testString(tagExpr, comp, propName, tag);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addPropertySaveBindings(comp, propName, saveExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
    }

    private void processFormBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        BindEvaluatorX eval = this._binder.getEvaluatorX();
        ExpressionAnnoInfo validatorInfo = this.parseValidator(compCtrl, FORM_ATTR);
        String formId = null;
        Collection idannos = compCtrl.getAnnotations(FORM_ATTR, ID_ANNO);
        if (idannos.size() == 0) {
            throw new IllegalSyntaxException("@id is not found for a form binding of " + compCtrl);
        }
        if (idannos.size() > 1) {
            throw new IllegalSyntaxException("Allow only one @id for a form binding of " + compCtrl);
        }
        Annotation idanno = (Annotation)idannos.iterator().next();
        String idExpr = idanno.getAttribute("value");
        if (idExpr != null) {
            formId = BindEvaluatorXUtil.eval(eval, comp, idExpr, String.class);
        }
        if (formId == null) {
            throw new UiException("value of @id is not found for a form binding of " + compCtrl + ", exprssion is " + idExpr);
        }
        Collection initannos = compCtrl.getAnnotations(FORM_ATTR, INIT_ANNO);
        if (initannos.size() > 1) {
            throw new IllegalSyntaxException("Allow only one @init for form of " + comp);
        }
        if (initannos.size() == 1) {
            this.processFormInit(comp, formId, (Annotation)initannos.iterator().next());
        }
        Collection annos = compCtrl.getAnnotations(FORM_ATTR);
        for (Annotation anno : annos) {
            if (anno.getName().equals(LOAD_ANNO)) {
                this.processFormLoadBindings(comp, formId, anno);
                continue;
            }
            if (!anno.getName().equals(SAVE_ANNO)) continue;
            this.processFormSaveBindings(comp, formId, anno, validatorInfo);
        }
    }

    private void processFormInit(Component comp, String formId, Annotation ann) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, comp, formId, tag);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addFormInitBinding(comp, formId, initExpr, parsedArgs);
    }

    private void processFormLoadBindings(Component comp, String formId, Annotation ann) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, comp, formId, tag);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addFormLoadBindings(comp, formId, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs);
    }

    private void processFormSaveBindings(Component comp, String formId, Annotation ann, ExpressionAnnoInfo validatorInfo) {
        String saveExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                saveExpr = AnnotationUtil.testString(tagExpr, comp, formId, tag);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addFormSaveBindings(comp, formId, saveExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
    }

    private void processChildrenBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        ExpressionAnnoInfo converterInfo = this.parseConverter(compCtrl, CHILDREN_ATTR);
        Collection initannos = compCtrl.getAnnotations(CHILDREN_ATTR, INIT_ANNO);
        if (initannos.size() > 1) {
            throw new IllegalSyntaxException("Allow only one @init for children of " + comp);
        }
        if (initannos.size() == 1) {
            this.processChildrenInit(comp, (Annotation)initannos.iterator().next(), converterInfo);
        }
        Collection annos = compCtrl.getAnnotations(CHILDREN_ATTR);
        for (Annotation anno : annos) {
            if (anno.getName().equals(BIND_ANNO)) {
                this.processChildrenPromptBindings(comp, anno, converterInfo);
                continue;
            }
            if (!anno.getName().equals(LOAD_ANNO)) continue;
            this.processChildrenLoadBindings(comp, anno, converterInfo);
        }
        ExpressionAnnoInfo templateInfo = this.parseTemplate(compCtrl, CHILDREN_ATTR);
        if (templateInfo != null) {
            this._binder.setTemplate(comp, CHILDREN_KEY, templateInfo.expr, templateInfo.args);
        }
    }

    private void processChildrenInit(Component comp, Annotation anno, ExpressionAnnoInfo converterInfo) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : anno.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, comp, CHILDREN_ATTR, tag);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addChildrenInitBinding(comp, initExpr, parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
    }

    private String getDefaultChildBindingConverter() {
        if (SystemConverters.get("childrenBinding") != null) {
            return "'childrenBinding'";
        }
        return null;
    }

    private void processChildrenPromptBindings(Component comp, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String expr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                expr = AnnotationUtil.testString(tagExpr, comp, CHILDREN_ATTR, tag);
                continue;
            }
            if ("before".equals(tag)) {
                throw new IllegalSyntaxException("@bind is for prompt binding only, doesn't support before commands, check property children of " + comp);
            }
            if ("after".equals(tag)) {
                throw new IllegalSyntaxException("@bind is for prompt binding only, doesn't support after commands, check property children of " + comp);
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addChildrenLoadBindings(comp, expr, null, null, parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
    }

    private void processChildrenLoadBindings(Component comp, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, comp, CHILDREN_ATTR, tag);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        this._binder.addChildrenLoadBindings(comp, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
    }

    private ExpressionAnnoInfo parseConverter(ComponentCtrl compCtrl, String propName) {
        Collection annos = compCtrl.getAnnotations(propName, CONVERTER_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException("Allow only one converter for " + propName + " of " + compCtrl);
        }
        Annotation anno = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : anno.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, (Component)compCtrl, propName, tag);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException("Must specify a converter for " + propName + " of " + compCtrl);
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private ExpressionAnnoInfo parseValidator(ComponentCtrl compCtrl, String propName) {
        Collection annos = compCtrl.getAnnotations(propName, VALIDATOR_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException("Allow only one validator for " + propName + " of " + compCtrl);
        }
        Annotation anno = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : anno.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, (Component)compCtrl, propName, tag);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException("Must specify a validator for " + propName + " of " + compCtrl);
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private ExpressionAnnoInfo parseTemplate(ComponentCtrl compCtrl, String propName) {
        Collection annos = compCtrl.getAnnotations(propName, TEMPLATE_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException("Allow only one template for " + propName + " of " + compCtrl);
        }
        Annotation anno = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : anno.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, (Component)compCtrl, propName, tag);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException("Must specify a template for " + propName + " of " + compCtrl);
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private static class ExpressionAnnoInfo {
        Map<String, Object> args;
        String expr;

        private ExpressionAnnoInfo() {
        }
    }
}

