/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.action;

import java.io.IOException;
import org.zkoss.web.mesg.MWeb;
import org.zkoss.web.servlet.dsp.DspException;
import org.zkoss.web.servlet.dsp.action.AbstractAction;
import org.zkoss.web.servlet.dsp.action.ActionContext;
import org.zkoss.xml.XMLs;

public class Out
extends AbstractAction {
    private String _value = null;
    private int _maxlength;
    private boolean _escapeXML = true;
    private boolean _nbsp;
    private boolean _pre;

    public boolean getEscapeXML() {
        return this._escapeXML;
    }

    public void setEscapeXML(boolean escapeXML) {
        this._escapeXML = escapeXML;
    }

    public boolean getNbsp() {
        return this._escapeXML;
    }

    public void setNbsp(boolean nbsp) {
        this._nbsp = nbsp;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        this._maxlength = maxlength;
    }

    public void setPre(boolean pre) {
        this._pre = pre;
    }

    public boolean isPre() {
        return this._pre;
    }

    @Override
    public void render(ActionContext ac, boolean nested) throws DspException, IOException {
        int len;
        if (!this.isEffective()) {
            return;
        }
        if (nested) {
            throw new DspException(MWeb.DSP_NESTED_ACTION_NOT_ALLOWED, new Object[]{this, new Integer(ac.getLineNumber())});
        }
        int n = len = this._value != null ? this._value.length() : 0;
        if (len == 0 || this._nbsp && this._value.trim().length() == 0) {
            if (this._nbsp) {
                ac.getOut().write("&nbsp;");
            }
            return;
        }
        Object value = this._value;
        if (this._maxlength > 0 && len > this._maxlength) {
            int j;
            for (j = this._maxlength; j > 0 && Character.isWhitespace(((String)value).charAt(j - 1)); --j) {
            }
            value = ((String)value).substring(0, j) + "...";
        }
        if (this._escapeXML) {
            StringBuffer sb = null;
            len = ((String)value).length();
            for (int j = 0; j < len; ++j) {
                char cc = ((String)value).charAt(j);
                String replace = this._pre && cc == ' ' ? "&nbsp;" : XMLs.escapeXML((char)cc);
                if (replace != null) {
                    if (sb == null) {
                        sb = new StringBuffer(((String)value).length() + 10);
                        sb.append(((String)value).substring(0, j));
                    }
                    sb.append(replace);
                    continue;
                }
                if (sb == null) continue;
                sb.append(cc);
            }
            if (sb != null) {
                value = sb.toString();
            }
        }
        ac.getOut().write((String)value);
    }

    public String toString() {
        return "out";
    }
}

