/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel;

import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.zel.BeanNameELResolver;
import org.zkoss.zel.BeanNameResolver;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.EvaluationListener;
import org.zkoss.zel.ExpressionFactory;
import org.zkoss.zel.StandardELContext;
import org.zkoss.zel.Util;
import org.zkoss.zel.ValueExpression;

public class ELManager {
    private StandardELContext context = null;

    public static ExpressionFactory getExpressionFactory() {
        return Util.getExpressionFactory();
    }

    public StandardELContext getELContext() {
        if (this.context == null) {
            this.context = new StandardELContext(ELManager.getExpressionFactory());
        }
        return this.context;
    }

    public ELContext setELContext(ELContext context) {
        StandardELContext oldContext = this.context;
        this.context = new StandardELContext(context);
        return oldContext;
    }

    public void addBeanNameResolver(BeanNameResolver beanNameResolver) {
        this.getELContext().addELResolver(new BeanNameELResolver(beanNameResolver));
    }

    public void addELResolver(ELResolver resolver) {
        this.getELContext().addELResolver(resolver);
    }

    public void mapFunction(String prefix, String function, Method method) {
        this.getELContext().getFunctionMapper().mapFunction(prefix, function, method);
    }

    public void setVariable(String variable, ValueExpression expression) {
        this.getELContext().getVariableMapper().setVariable(variable, expression);
    }

    public void importStatic(String staticMemberName) throws ELException {
        this.getELContext().getImportHandler().importStatic(staticMemberName);
    }

    public void importClass(String className) throws ELException {
        this.getELContext().getImportHandler().importClass(className);
    }

    public void importPackage(String packageName) {
        this.getELContext().getImportHandler().importPackage(packageName);
    }

    public Object defineBean(String name, Object bean) {
        Map<String, Object> localBeans = this.getELContext().getLocalBeans();
        if (bean == null) {
            return localBeans.remove(name);
        }
        return localBeans.put(name, bean);
    }

    public void addEvaluationListener(EvaluationListener listener) {
        this.getELContext().addEvaluationListener(listener);
    }
}

