/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class DualCollection<T>
extends AbstractCollection<T>
implements Serializable {
    private final Collection<T> _first;
    private final Collection<T> _second;

    public static final <M> Collection<M> combine(Collection<M> first, Collection<M> second) {
        if (first == second) {
            return first;
        }
        if (first != null) {
            if (second != null) {
                return new DualCollection<M>(first, second);
            }
            return first;
        }
        return second;
    }

    public DualCollection(Collection<T> first, Collection<T> second) {
        this._first = first != null ? first : Collections.emptyList();
        this._second = second != null ? second : Collections.emptyList();
    }

    @Override
    public int size() {
        return this._first.size() + this._second.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    private class Iter
    implements Iterator<T> {
        private Iterator<T> _it;
        private boolean _bSecond;

        private Iter() {
            this._it = DualCollection.this._first.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._it.hasNext() || !this._bSecond && !DualCollection.this._second.isEmpty();
        }

        @Override
        public T next() {
            if (!this._bSecond && !this._it.hasNext()) {
                this._it = DualCollection.this._second.iterator();
                this._bSecond = true;
            }
            return this._it.next();
        }

        @Override
        public void remove() {
            this._it.remove();
        }
    }
}

