/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.text;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.zkoss.text.DateFormatInfo;
import org.zkoss.util.Locales;

public class DateFormats {
    private static final InheritableThreadLocal<DateFormatInfo> _thdLocale = new InheritableThreadLocal();

    public static DateFormatInfo setLocalFormatInfo(DateFormatInfo info) {
        DateFormatInfo old = (DateFormatInfo)_thdLocale.get();
        _thdLocale.set(info);
        return old;
    }

    public static DateFormatInfo getLocalFormatInfo() {
        return (DateFormatInfo)_thdLocale.get();
    }

    public static String getDateFormat(int style, Locale locale, String defaultFormat) {
        String fmt;
        String fmt2;
        DateFormatInfo info;
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        if ((info = DateFormats.getLocalFormatInfo()) != null && (fmt2 = info.getDateFormat(style, locale)) != null) {
            return fmt2;
        }
        DateFormat df = DateFormat.getDateInstance(style, locale);
        if (df instanceof SimpleDateFormat && (fmt = ((SimpleDateFormat)df).toPattern()) != null && !"M/d/yy h:mm a".equals(fmt)) {
            return fmt;
        }
        return defaultFormat != null ? defaultFormat : "M/d/yy";
    }

    public static final String getTimeFormat(int style, Locale locale, String defaultFormat) {
        String fmt;
        String fmt2;
        DateFormatInfo info;
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        if ((info = DateFormats.getLocalFormatInfo()) != null && (fmt2 = info.getTimeFormat(style, locale)) != null) {
            return fmt2;
        }
        DateFormat df = DateFormat.getTimeInstance(style, locale);
        if (df instanceof SimpleDateFormat && (fmt = ((SimpleDateFormat)df).toPattern()) != null && !"M/d/yy h:mm a".equals(fmt)) {
            return fmt;
        }
        return "h:mm a";
    }

    public static final String getDateTimeFormat(int dateStyle, int timeStyle, Locale locale, String defaultFormat) {
        String fmt;
        String fmt2;
        DateFormatInfo info;
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        if ((info = DateFormats.getLocalFormatInfo()) != null && (fmt2 = info.getDateTimeFormat(dateStyle, timeStyle, locale)) != null) {
            return fmt2;
        }
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        if (df instanceof SimpleDateFormat && (fmt = ((SimpleDateFormat)df).toPattern()) != null) {
            return fmt;
        }
        return defaultFormat != null ? defaultFormat : "M/d/yy h:mm a";
    }

    public static final String format(Date d, boolean dateOnly) {
        return DateFormats.getDateFormat(dateOnly).format(d);
    }

    public static final Date parse(String s, boolean dateOnly) throws ParseException {
        return DateFormats.getDateFormat(dateOnly).parse(s);
    }

    private static final DateFormat getDateFormat(boolean dateOnly) {
        Locale locale = Locales.getCurrent();
        return dateOnly ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale);
    }
}

