/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.mesg;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.MCommon;
import org.zkoss.mesg.MessageConst;
import org.zkoss.text.MessageFormats;
import org.zkoss.util.Locales;
import org.zkoss.util.resource.Labels;
import org.zkoss.util.resource.PropertyBundle;

public class Messages
implements MessageConst {
    private static final Logger log = LoggerFactory.getLogger(Messages.class);
    private static Formatter _formatter;

    protected Messages() {
    }

    public static final String get(int code) {
        return Messages.get(code, null, Messages.getLocale());
    }

    public static final String get(int code, Object fmtArg) {
        return Messages.get(code, new Object[]{fmtArg}, Messages.getLocale());
    }

    public static final String get(int code, Object[] fmtArgs) {
        return Messages.get(code, fmtArgs, Messages.getLocale());
    }

    private static final Locale getLocale() {
        return Locales.getCurrent();
    }

    private static final String getFromBundle(int code, Locale locale) {
        MessageConst.BundleInfo bi = MessageConst.Aide.getBundleInfo(code);
        String label = Labels.getLabel(Messages.getLabelKey(bi, code));
        if (label != null) {
            return label;
        }
        PropertyBundle rb = PropertyBundle.getBundle(bi.filename, locale, true);
        if (rb != null) {
            return rb.getProperty(Integer.toHexString(code - Messages.getType(code)));
        }
        throw new IllegalStateException("Missing resource: " + bi + " locale=" + locale);
    }

    private static final String getLabelKey(MessageConst.BundleInfo bi, int code) {
        String nm = bi.klass.getName();
        int j = nm.lastIndexOf(46);
        return (j >= 0 ? nm.substring(j + 1) : nm) + '.' + Integer.toHexString(code & 0xFFFF);
    }

    private static final String getNotFound(int code, Locale locale) {
        if (code == 0) {
            return "";
        }
        try {
            log.error("Message code not found: " + Integer.toHexString(code) + " not in " + locale + ":" + MessageConst.Aide.getBundleInfo(code));
            String hexcode = Integer.toHexString(code);
            String s = Messages.getFromBundle(MCommon.MESSAGE_CODE_NOT_FOUND, locale);
            return s != null ? MessageFormats.format(s, new Object[]{hexcode}, locale) : "Unknown message code: " + hexcode;
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return "Unknown message code: " + Integer.toHexString(code);
        }
    }

    public static String get(int code, Object[] fmtArgs, Locale locale) {
        try {
            String s = Messages.getFromBundle(code, locale);
            if (s == null) {
                return Messages.getNotFound(code, locale);
            }
            if (fmtArgs != null && fmtArgs.length > 0) {
                Object[] args = new Object[fmtArgs.length];
                Formatter formatter = _formatter;
                for (int j = 0; j < fmtArgs.length; ++j) {
                    Object arg = fmtArgs[j];
                    args[j] = formatter != null ? formatter.format(arg) : (arg == null || arg == Objects.UNKNOWN ? "" : (arg instanceof Object[] ? Objects.toString(arg) : arg));
                }
                s = MessageFormats.format(s, args, locale);
            }
            return s;
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return Messages.getNotFound(code, locale);
        }
    }

    public static Formatter getFormatter() {
        return _formatter;
    }

    public static void setFormatter(Formatter fmt) {
        _formatter = fmt;
    }

    public static final int getType(int code) {
        return code & 0xFFFF0000;
    }

    public static interface Formatter {
        public Object format(Object var1);
    }
}

