/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zkoss.idom.Binary;
import org.zkoss.idom.CData;
import org.zkoss.idom.Comment;
import org.zkoss.idom.DOMException;
import org.zkoss.idom.Element;
import org.zkoss.idom.EntityReference;
import org.zkoss.idom.Group;
import org.zkoss.idom.Item;
import org.zkoss.idom.ProcessingInstruction;
import org.zkoss.idom.Text;
import org.zkoss.idom.Textual;
import org.zkoss.idom.impl.AbstractItem;
import org.zkoss.idom.impl.FacadeNodeList;
import org.zkoss.util.NotableLinkedList;

public abstract class AbstractGroup
extends AbstractItem
implements Group {
    protected List<Item> _children = this.newChildren();
    private transient ElementMap _elemMap;

    protected AbstractGroup() {
    }

    protected List<Item> newChildren() {
        return new ChildArray();
    }

    @Override
    public final List<Item> getChildren() {
        return this._children;
    }

    @Override
    public final List<Item> detachChildren() {
        ArrayList<Item> list = new ArrayList<Item>(this._children);
        Iterator<Item> it = this._children.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        return list;
    }

    public final boolean anyElement() {
        if (this._elemMap != null) {
            return this._elemMap.any();
        }
        for (Item o : this._children) {
            if (!(o instanceof Element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Set<String> getElementNames() {
        if (this._elemMap != null) {
            return this._elemMap.names();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Item o : this._children) {
            if (!(o instanceof Element)) continue;
            set.add(((Element)o).getName());
        }
        return set;
    }

    @Override
    public final List<Element> getElements() {
        LinkedList<Element> lst = new LinkedList<Element>();
        for (Item o : this._children) {
            if (!(o instanceof Element)) continue;
            lst.add((Element)o);
        }
        return lst;
    }

    @Override
    public final int getElementIndex(int indexFrom, String namespace, String name, int mode) {
        if (indexFrom < 0 || indexFrom >= this._children.size()) {
            return -1;
        }
        Pattern ptn = (mode & 1) != 0 ? Pattern.compile(name) : null;
        ListIterator<Item> it = this._children.listIterator(indexFrom);
        int j = indexFrom;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Element && AbstractGroup.match((Element)o, namespace, name, ptn, mode)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    @Override
    public final int getElementIndex(int indexFrom, String tname) {
        return this.getElementIndex(indexFrom, null, tname, 4);
    }

    @Override
    public final Element getElement(String namespace, String name, int mode) {
        if (this._elemMap != null && namespace == null && mode == 4) {
            return this.getElement(name);
        }
        int j = this.getElementIndex(0, namespace, name, mode);
        if (j >= 0) {
            return (Element)this._children.get(j);
        }
        if ((mode & 0x100) != 0) {
            for (Item o : this._children) {
                Element elem;
                if (!(o instanceof Group) || (elem = ((Group)o).getElement(namespace, name, mode)) == null) continue;
                return elem;
            }
        }
        return null;
    }

    @Override
    public final Element getElement(String tname) {
        if (this._elemMap != null) {
            return this._elemMap.get(tname);
        }
        int j = this.getElementIndex(0, tname);
        return j >= 0 ? (Element)this._children.get(j) : null;
    }

    @Override
    public final List<Element> getElements(String namespace, String name, int mode) {
        if (this._elemMap != null && namespace == null && mode == 4) {
            return this.getElements(name);
        }
        Pattern ptn = (mode & 1) != 0 ? Pattern.compile(name) : null;
        LinkedList<Element> list = new LinkedList<Element>();
        for (Item item : this._children) {
            Element e;
            if (!(item instanceof Element) || !AbstractGroup.match(e = (Element)item, namespace, name, ptn, mode)) continue;
            list.add(e);
        }
        if ((mode & 0x100) != 0) {
            for (Item o : this._children) {
                if (!(o instanceof Group)) continue;
                list.addAll(((Group)o).getElements(namespace, name, mode));
            }
        }
        return list;
    }

    @Override
    public final List<Element> getElements(String tname) {
        if (this._elemMap != null) {
            return this._elemMap.getAll(tname);
        }
        return this.getElements(null, tname, 4);
    }

    @Override
    public final String getElementValue(String namespace, String name, int mode, boolean trim) {
        Element child = this.getElement(namespace, name, mode);
        return child != null ? child.getText(trim) : null;
    }

    @Override
    public final String getElementValue(String tname, boolean trim) {
        Element child = this.getElement(tname);
        return child != null ? child.getText(trim) : null;
    }

    @Override
    public final int coalesce(boolean recursive) {
        int count = 0;
        Item found = null;
        StringBuffer sb = new StringBuffer();
        Iterator<Item> it = this._children.iterator();
        while (it.hasNext()) {
            Item newFound;
            Item o = it.next();
            Item item = newFound = o instanceof Textual && ((Textual)((Object)o)).isCoalesceable() ? o : null;
            if (newFound != null && found != null && found.getClass().equals(o.getClass())) {
                if (sb.length() == 0) {
                    sb.append(found.getText());
                }
                sb.append(o.getText());
                it.remove();
                ++count;
                continue;
            }
            if (sb.length() > 0) {
                found.setText(sb.toString());
                sb.setLength(0);
            }
            found = newFound;
        }
        if (sb.length() > 0 && found != null) {
            found.setText(sb.toString());
        }
        sb = null;
        if (recursive) {
            for (Item o : this._children) {
                if (!(o instanceof Group)) continue;
                count += ((Group)o).coalesce(recursive);
            }
        }
        return count;
    }

    @Override
    public final NodeList getChildNodes() {
        return new FacadeNodeList(this._children);
    }

    @Override
    public final Node getFirstChild() {
        return this._children.isEmpty() ? null : (Node)((Object)this._children.get(0));
    }

    @Override
    public final Node getLastChild() {
        int sz = this._children.size();
        return sz == 0 ? null : (Node)((Object)this._children.get(sz - 1));
    }

    @Override
    public final boolean hasChildNodes() {
        return !this._children.isEmpty();
    }

    @Override
    public final Node insertBefore(Node newChild, Node refChild) {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        int j = this._children.indexOf(refChild);
        if (j < 0) {
            throw new DOMException(8, this.getLocator());
        }
        this._children.add(j, (Item)((Object)newChild));
        return newChild;
    }

    @Override
    public final Node replaceChild(Node newChild, Node oldChild) {
        int j = this._children.indexOf(oldChild);
        if (j < 0) {
            throw new DOMException(8, this.getLocator());
        }
        return (Node)((Object)this._children.set(j, (Item)((Object)newChild)));
    }

    @Override
    public final Node removeChild(Node oldChild) {
        int j = this._children.indexOf(oldChild);
        if (j < 0) {
            throw new DOMException(8, this.getLocator());
        }
        return (Node)((Object)this._children.remove(j));
    }

    @Override
    public final Node appendChild(Node newChild) {
        this._children.add((Item)((Object)newChild));
        return newChild;
    }

    @Override
    public Object clone() {
        AbstractGroup group = (AbstractGroup)super.clone();
        group._children = group.newChildren();
        for (Item src : this._children) {
            group._children.add((Item)src.clone());
        }
        if (group._children instanceof ChildArray) {
            ((ChildArray)group._children).afterClone();
        }
        return group;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this._children instanceof ChildArray) {
            ((ChildArray)this._children).afterUnmarshal();
        }
    }

    protected class ChildArray
    extends NotableLinkedList<Item> {
        protected ChildArray() {
            AbstractGroup.this._elemMap = new ElementMap();
        }

        private void afterUnmarshal() {
            AbstractGroup.this._elemMap = new ElementMap();
            for (Object o : this) {
                if (!(o instanceof Element)) continue;
                AbstractGroup.this._elemMap.put((Element)o, null);
            }
        }

        private void afterClone() {
            this.afterUnmarshal();
        }

        @Override
        protected void onAdd(Item newElement, Item followingElement) {
            this.checkAdd(newElement, followingElement, false);
        }

        @Override
        protected void onSet(Item newElement, Item replaced) {
            assert (replaced != null);
            this.checkAdd(newElement, replaced, true);
        }

        private void checkAdd(Item newVal, Item other, boolean replace) {
            if (!(newVal instanceof Element || newVal instanceof Text || newVal instanceof CData || newVal instanceof Comment || newVal instanceof EntityReference || newVal instanceof Binary || newVal instanceof ProcessingInstruction)) {
                throw new DOMException(3, "Invalid type", AbstractGroup.this.getLocator());
            }
            Item newItem = newVal;
            if (newItem.getParent() != null) {
                throw new DOMException(3, "Item, " + newItem.toString() + ", owned by " + newItem.getParent() + " " + newItem.getLocator() + "; detach or clone it", AbstractGroup.this.getLocator());
            }
            if (newItem instanceof Group) {
                for (Group p = AbstractGroup.this; p != null; p = p.getParent()) {
                    if (p != newItem) continue;
                    throw new DOMException(3, "Add to itself", AbstractGroup.this.getLocator());
                }
            }
            if (newItem instanceof Element) {
                Element eOther;
                if (other != null && !(other instanceof Element)) {
                    eOther = null;
                    boolean bFirstElemFind = false;
                    for (Object node : this) {
                        if (bFirstElemFind) {
                            if (!(node instanceof Element)) continue;
                            eOther = (Element)node;
                            break;
                        }
                        if (node != other) continue;
                        bFirstElemFind = true;
                    }
                } else {
                    eOther = (Element)other;
                }
                AbstractGroup.this._elemMap.put((Element)newItem, eOther);
            }
            if (replace) {
                this.onRemove(other);
            }
            newItem.setParent(AbstractGroup.this);
        }

        @Override
        protected void onRemove(Item item) {
            Item removeItem = item;
            removeItem.setParent(null);
            if (removeItem instanceof Element) {
                AbstractGroup.this._elemMap.remove((Element)removeItem);
            }
        }
    }

    protected static class ElementMap {
        private final Map<String, List<Element>> _map = new LinkedHashMap<String, List<Element>>();

        protected ElementMap() {
        }

        public final void put(Element e, Element following) {
            String name = e.getName();
            List<Element> valueList = this._map.get(name);
            if (valueList == null) {
                valueList = new LinkedList<Element>();
                this._map.put(name, valueList);
            }
            if (following != null && name.equals(following.getName())) {
                ListIterator<Element> it = valueList.listIterator();
                while (it.hasNext()) {
                    if (it.next() != following) continue;
                    it.previous();
                    it.add(e);
                    return;
                }
            }
            valueList.add(e);
        }

        public final Element get(String name) {
            List<Element> vals = this._map.get(name);
            return vals != null && !vals.isEmpty() ? vals.get(0) : null;
        }

        public final List<Element> getAll(String name) {
            List<Element> vals = this._map.get(name);
            if (vals != null) {
                return Collections.unmodifiableList(vals);
            }
            return Collections.emptyList();
        }

        public final void remove(Element e) {
            List<Element> vals = this._map.get(e.getName());
            vals.remove(e);
            if (vals.isEmpty()) {
                this._map.remove(e.getName());
            }
        }

        public final boolean any() {
            return !this._map.isEmpty();
        }

        public final Set<String> names() {
            return this._map.keySet();
        }

        public final int size() {
            int sz = 0;
            for (List<Element> lst : this._map.values()) {
                sz += lst.size();
            }
            return sz;
        }
    }
}

