/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.json;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
extends LinkedHashMap<Object, Object>
implements Map<Object, Object>,
JSONAware {
    private static final long serialVersionUID = -503443796854799292L;

    public static String toJSONString(Map map) {
        if (map == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator iter = map.entrySet().iterator();
        sb.append('{');
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Map.Entry entry = iter.next();
            JSONObject.toJSONString(String.valueOf(entry.getKey()), entry.getValue(), sb);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String toJSONString() {
        return JSONObject.toJSONString(this);
    }

    private static String toJSONString(String key, Object value, StringBuffer sb) {
        sb.append('\"');
        if (key == null) {
            sb.append("null");
        } else {
            JSONValue.escape(key, sb);
        }
        sb.append('\"').append(':');
        sb.append(JSONValue.toJSONString(value));
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public static String toString(String key, Object value) {
        StringBuffer sb = new StringBuffer();
        JSONObject.toJSONString(key, value, sb);
        return sb.toString();
    }
}

