/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.zkoss.util.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComodifiableIterator<F, T>
implements Iterator<T> {
    private final List<F> _visited = new LinkedList<F>();
    private List<F> _lastVisited;
    private final Collection<F> _col;
    private Iterator<F> _it;
    private F _next;
    private Converter<F, T> _converter;
    private boolean _nextAvail;
    private static final Converter _identityConverter = new Converter(){

        public Object convert(Object o) {
            return o;
        }
    };

    ComodifiableIterator(Collection<F> col, Converter<F, T> converter) {
        this._col = col;
        this._it = col.iterator();
        this._converter = converter != null ? converter : _identityConverter;
    }

    @Override
    public boolean hasNext() {
        if (this._nextAvail) {
            return true;
        }
        while (!this._col.isEmpty()) {
            F o;
            try {
                o = this._it.next();
            }
            catch (NoSuchElementException ex) {
                return false;
            }
            catch (ConcurrentModificationException ex) {
                this._lastVisited = new LinkedList<F>(this._visited);
                this._it = this._col.iterator();
                continue;
            }
            if (this.removeFromLastVisited(o)) continue;
            this._visited.add(o);
            this._next = o;
            this._nextAvail = true;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        F o;
        if (this._nextAvail) {
            this._nextAvail = false;
            return this._converter.convert(this._next);
        }
        while (true) {
            try {
                o = this._it.next();
            }
            catch (ConcurrentModificationException ex) {
                this._lastVisited = new LinkedList<F>(this._visited);
                this._it = this._col.iterator();
                continue;
            }
            if (!this.removeFromLastVisited(o)) break;
        }
        this._visited.add(o);
        return this._converter.convert(o);
    }

    private boolean removeFromLastVisited(F o) {
        if (this._lastVisited != null) {
            Iterator<F> it = this._lastVisited.iterator();
            while (it.hasNext()) {
                if (it.next() != o) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public void remove() {
        this._it.remove();
        this._nextAvail = false;
    }
}

