/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

public class Checksums {
    public static final String SKIPS = "DEOX";

    public static final String toReadable(long val, String skips) {
        int patch;
        if (skips == null) {
            skips = SKIPS;
        }
        int mod = 36 - skips.length();
        if (val < 0L) {
            val = -val;
        }
        if ((patch = (int)val) < 0) {
            patch = -patch;
        }
        StringBuffer sb = new StringBuffer(32);
        int digits = 0;
        while (true) {
            int v;
            if (val == 0L) {
                if (digits == 4) {
                    digits = 0;
                    sb.append('-');
                }
                while (digits++ != 3) {
                    v = patch % mod;
                    patch /= mod;
                    sb.append(Checksums.toReadableChar(v, skips));
                }
                sb.append(Checksums.getChecksum(sb, skips));
                return sb.toString();
            }
            if (digits++ == 4) {
                digits = 1;
                sb.append('-');
            }
            v = (int)(val % (long)mod);
            val /= (long)mod;
            sb.append(Checksums.toReadableChar(v, skips));
        }
    }

    public static final char toReadableChar(int val, String skips) {
        char sk;
        if (val < 10) {
            return (char)(val + 48);
        }
        if (skips == null) {
            skips = SKIPS;
        }
        char cc = (char)(val + 55);
        int sklen = skips.length();
        for (int j = 0; j < sklen && cc >= (sk = skips.charAt(j)); cc = (char)(cc + '\u0001'), ++j) {
        }
        return cc;
    }

    public static final char getChecksum(String val, String skips) {
        if (skips == null) {
            skips = SKIPS;
        }
        int len = val.length();
        int cksum = 0;
        for (int j = 0; j < len; ++j) {
            char cc = val.charAt(j);
            if (cc == '-' || cc == ' ') continue;
            cksum = cksum * 27 + cc;
        }
        if (cksum < 0) {
            cksum = -cksum;
        }
        return Checksums.toReadableChar(cksum % (36 - skips.length()), skips);
    }

    public static final char getChecksum(StringBuffer val, String skips) {
        if (skips == null) {
            skips = SKIPS;
        }
        int len = val.length();
        int cksum = 0;
        for (int j = 0; j < len; ++j) {
            char cc = val.charAt(j);
            if (cc == '-' || cc == ' ') continue;
            cksum = cksum * 27 + cc;
        }
        if (cksum < 0) {
            cksum = -cksum;
        }
        return Checksums.toReadableChar(cksum % (36 - skips.length()), skips);
    }
}

