/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.text;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.util.Locales;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormats {
    public static final String format(String pattern, Object[] args, Locale locale) {
        return MessageFormats.getFormat(pattern, locale).format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    private static MessageFormat getFormat(String pattern, Locale locale) {
        if (locale == null) {
            locale = MessageFormats.getLocale();
        }
        return new MessageFormat(pattern, locale);
    }

    private static final Locale getLocale() {
        return Locales.getCurrent();
    }

    public static final String format(String pattern, Object[] args) {
        return MessageFormats.format(pattern, args, null);
    }

    public static final StringBuffer format(StringBuffer result, String pattern, Object[] args, Locale locale) {
        return MessageFormats.getFormat(pattern, locale).format(args, result, (FieldPosition)null);
    }

    public static final StringBuffer format(StringBuffer result, String pattern, Object[] args) {
        return MessageFormats.format(result, pattern, args, null);
    }

    public static final NameInfo parseByName(String pattern) {
        int k;
        LinkedHashMap<String, Integer> names = new LinkedHashMap<String, Integer>();
        int len = pattern.length();
        StringBuffer sb = new StringBuffer(len + 32);
        int j = 0;
        while ((k = Strings.anyOf(pattern, "'{", j)) < len) {
            int m;
            int l;
            char cc = pattern.charAt(k);
            if (cc == '\'') {
                l = pattern.indexOf(39, k + 1);
                if (l < 0) break;
                sb.append(pattern.substring(j, l + 1));
                j = l + 1;
                continue;
            }
            l = Strings.anyOf(pattern, ",}", k + 1);
            if (l >= len || (m = pattern.indexOf(125, l)) < 0) break;
            String nm = pattern.substring(k + 1, l);
            Integer pos = (Integer)names.get(nm);
            if (pos == null) {
                pos = new Integer(names.size());
                names.put(nm, pos);
            }
            sb.append(pattern.substring(j, k + 1)).append(pos).append(pattern.substring(l, m + 1));
            j = m + 1;
        }
        if (j < len) {
            sb.append(pattern.substring(j));
        }
        return new NameInfo(sb.toString(), names.keySet());
    }

    public static final String formatByName(String pattern, Map<String, ?> mapping, Locale locale) {
        NameInfo ni = MessageFormats.parseByName(pattern);
        Object[] args = new Object[ni.names.length];
        int j = args.length;
        while (--j >= 0) {
            args[j] = mapping.get(ni.names[j]);
        }
        return MessageFormats.format(ni.pattern, args, locale);
    }

    public static final String formatByName(String pattern, Map<String, ?> mapping) {
        return MessageFormats.formatByName(pattern, mapping, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameInfo {
        public final String pattern;
        public final String[] names;

        NameInfo(String pattern, Collection<String> names) {
            this.pattern = pattern;
            this.names = names.toArray(new String[names.size()]);
        }

        NameInfo(String pattern, String[] names) {
            this.pattern = pattern;
            this.names = names;
        }
    }
}

