/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    private final Writer _writer;
    private final String _charset;
    private final byte[] _bs;
    private int _cnt;
    private int _type;

    public WriterOutputStream(Writer writer, String charset) {
        if (writer == null) {
            throw new IllegalArgumentException("null");
        }
        this._writer = writer;
        this._bs = new byte[3];
        this._charset = charset == null ? "UTF-8" : charset;
    }

    public WriterOutputStream(Writer writer) {
        this(writer, null);
    }

    public void write(byte[] b) throws IOException {
        this._writer.write(new String(b, this._charset));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._writer.write(new String(b, 0, b.length, this._charset));
    }

    public void write(int b) throws IOException {
        if (this._type != 0) {
            if (!"UTF-8".equals(this._charset) || (b & 0xC0) == 128) {
                this._bs[this._cnt++] = (byte)b;
                if (this._cnt == this._type) {
                    this._writer.write(new String(this._bs, 0, this._type, this._charset));
                    this._type = 0;
                }
                return;
            }
            for (int j = 0; j < this._cnt; ++j) {
                this._writer.write(this._bs[j]);
            }
            this._type = 0;
        } else if ("UTF-8".equals(this._charset)) {
            if ((b & 0xE0) == 192 || (b & 0xF0) == 224) {
                this._type = (b & 0xF0) == 224 ? 3 : 2;
                this._bs[0] = (byte)b;
                this._cnt = 1;
                return;
            }
        } else if ((b & 0x80) != 0) {
            this._type = 2;
            this._bs[0] = (byte)b;
            this._cnt = 1;
            return;
        }
        this._writer.write(b);
    }

    public void flush() throws IOException {
        if (this._type != 0) {
            for (int j = 0; j < this._cnt; ++j) {
                this._writer.write(this._bs[j]);
            }
            this._type = 0;
        }
        this._writer.flush();
        super.flush();
    }

    public void close() throws IOException {
        this.flush();
        this._writer.close();
        super.close();
    }
}

