/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.zkoss.idom.Document;
import org.zkoss.idom.input.IDOMFactory;
import org.zkoss.idom.input.SAXHandler;
import org.zkoss.lang.Exceptions;

public class SAXBuilder {
    private static final Logger log = LoggerFactory.getLogger(SAXBuilder.class);
    private final SAXParser _parser;
    private IDOMFactory _factory;
    private boolean _ignoreWhitespaces = false;
    private boolean _expandEntities = true;
    private boolean _coalescing = false;
    private boolean _ignoreComments = false;
    private ErrorHandler _errHandler = null;
    private EntityResolver _resolver = null;

    public SAXBuilder(SAXParser parser) {
        if (parser == null) {
            throw new NullPointerException("parser");
        }
        this._parser = parser;
    }

    public SAXBuilder(boolean nsaware, boolean validate) throws ParserConfigurationException, SAXException {
        SAXParserFactory fty = SAXParserFactory.newInstance();
        SAXBuilder.setSafeFeature(fty, "http://xml.org/sax/features/namespace-prefixes", true);
        SAXBuilder.setSafeFeature(fty, "http://xml.org/sax/features/namespaces", nsaware);
        fty.setNamespaceAware(nsaware);
        SAXBuilder.setSafeFeature(fty, "http://xml.org/sax/features/validation", validate);
        SAXBuilder.setSafeFeature(fty, "http://apache.org/xml/features/validation/schema", validate);
        fty.setValidating(validate);
        this._parser = fty.newSAXParser();
    }

    private static void setSafeFeature(SAXParserFactory fty, String feature, boolean value) {
        block2: {
            try {
                fty.setFeature(feature, value);
            }
            catch (Throwable ex) {
                if (!feature.startsWith("http://xml.org")) break block2;
                log.warn("Ignored: " + fty + " doesn't support " + feature + ". Cause: " + Exceptions.getMessage(ex));
            }
        }
    }

    public SAXBuilder(boolean nsaware, boolean validate, boolean smartIgnore) throws ParserConfigurationException, SAXException {
        this(nsaware, validate);
        if (smartIgnore) {
            this.setIgnoringComments(true);
            this.setCoalescing(true);
            if (validate) {
                this.setIgnoringElementContentWhitespace(true);
            }
        }
    }

    public final boolean isIgnoringElementContentWhitespace() {
        return this._ignoreWhitespaces;
    }

    public final void setIgnoringElementContentWhitespace(boolean ignore) {
        this._ignoreWhitespaces = ignore;
    }

    public final boolean isExpandEntityReferences() {
        return this._expandEntities;
    }

    public final void setExpandEntityReferences(boolean expand) {
        this._expandEntities = expand;
    }

    public final boolean isCoalescing() {
        return this._coalescing;
    }

    public final void setCoalescing(boolean coalescing) {
        this._coalescing = coalescing;
    }

    public final boolean isIgnoringComments() {
        return this._ignoreComments;
    }

    public final void setIgnoringComments(boolean ignoreComments) {
        this._ignoreComments = ignoreComments;
    }

    public final void setErrorHandler(ErrorHandler eh) {
        this._errHandler = eh;
    }

    public final ErrorHandler getErrorHandler() {
        return this._errHandler;
    }

    public final void setEntityResolver(EntityResolver er) {
        this._resolver = er;
    }

    public final EntityResolver getEntityResolver() {
        return this._resolver;
    }

    public final boolean isNamespaceAware() {
        return this._parser.isNamespaceAware();
    }

    public final boolean isValidating() {
        return this._parser.isValidating();
    }

    public final IDOMFactory getIDOMFactory() {
        return this._factory;
    }

    public final void setIDOMFactory(IDOMFactory factory) {
        this._factory = factory;
    }

    public final SAXParser getParser() {
        return this._parser;
    }

    public final Document build(File src) throws SAXException, IOException {
        SAXHandler handler = this.newHandler();
        this._parser.parse(src, (DefaultHandler)handler);
        return handler.getDocument();
    }

    public final Document build(InputStream src) throws SAXException, IOException {
        SAXHandler handler = this.newHandler();
        this._parser.parse(src, (DefaultHandler)handler);
        return handler.getDocument();
    }

    public final Document build(InputSource src) throws SAXException, IOException {
        SAXHandler handler = this.newHandler();
        this._parser.parse(src, (DefaultHandler)handler);
        return handler.getDocument();
    }

    public final Document build(String uri) throws SAXException, IOException {
        SAXHandler handler = this.newHandler();
        this._parser.parse(uri, (DefaultHandler)handler);
        return handler.getDocument();
    }

    public final Document build(URL url) throws SAXException, IOException {
        SAXHandler handler = this.newHandler();
        this._parser.parse(url.toExternalForm(), (DefaultHandler)handler);
        return handler.getDocument();
    }

    public final Document build(Reader src) throws SAXException, IOException {
        SAXHandler handler = this.newHandler();
        this._parser.parse(new InputSource(src), (DefaultHandler)handler);
        return handler.getDocument();
    }

    protected SAXHandler newHandler() throws SAXException {
        SAXHandler handler = new SAXHandler(this._factory);
        handler.setIgnoringElementContentWhitespace(this._ignoreWhitespaces);
        handler.setExpandEntityReferences(this._expandEntities);
        handler.setCoalescing(this._coalescing);
        handler.setIgnoringComments(this._ignoreComments);
        handler.setErrorHandler(this._errHandler);
        handler.setEntityResolver(this._resolver);
        this.setSafeProperty("http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler", handler);
        if (!this.isExpandEntityReferences()) {
            this.setSafeProperty("http://xml.org/sax/properties/declaration-handler", null, handler);
        }
        return handler;
    }

    private void setSafeProperty(String name, String auxnm, Object value) {
        try {
            this._parser.setProperty(name, value);
            return;
        }
        catch (Throwable t) {
            Throwable ex = t;
            if (auxnm != null) {
                try {
                    this._parser.setProperty(auxnm, value);
                    return;
                }
                catch (Throwable t2) {
                    // empty catch block
                }
            }
            if (name.startsWith("http://xml.org")) {
                log.warn("Ignored: " + this._parser + " doesn't support " + name + ". Cause: " + Exceptions.getMessage(ex));
            }
            return;
        }
    }
}

