/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.util.logging.Log;

public class Library {
    private static final Log log = Log.lookup(Library.class);
    private static final Map<String, String> _props = new HashMap<String, String>();

    private Library() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String key) {
        String v;
        Map<String, String> map = _props;
        synchronized (map) {
            v = _props.get(key);
        }
        try {
            return v != null || key == null || key.length() == 0 ? v : System.getProperty(key);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String key, String def) {
        String v;
        Map<String, String> map = _props;
        synchronized (map) {
            v = _props.get(key);
        }
        try {
            return v != null ? v : System.getProperty(key, def);
        }
        catch (SecurityException ex) {
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException();
        }
        Map<String, String> map = _props;
        synchronized (map) {
            return _props.put(key, value);
        }
    }

    public static int getIntProperty(String key, int defVal) {
        String val = Library.getProperty(key);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (Throwable t) {
                log.warning("Failed to parse " + key + ": not an integer, " + val);
            }
        }
        return defVal;
    }
}

