/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.lang.SystemException;
import org.zkoss.util.Cache;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Maps;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBundle {
    private static final Log log = Log.lookup(PropertyBundle.class);
    private static final Cache<Key, PropertyBundle> _cache = new CacheMap<Key, PropertyBundle>();
    private final Map<String, String> _map;
    private final Locale _locale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PropertyBundle getBundle(String baseName, Locale locale, Locator locator, boolean caseInsensitive) {
        if (baseName == null || locator == null) {
            throw new IllegalArgumentException();
        }
        Key key = new Key(baseName, locale, locator, caseInsensitive);
        Cache<Key, PropertyBundle> cache = _cache;
        synchronized (cache) {
            PropertyBundle bundle = _cache.get(key);
            if (bundle != null) {
                return bundle;
            }
        }
        PropertyBundle bundle = new PropertyBundle(baseName, locale, locator, caseInsensitive);
        if (bundle._map == null) {
            return null;
        }
        Cache<Key, PropertyBundle> cache2 = _cache;
        synchronized (cache2) {
            _cache.put(key, bundle);
        }
        return bundle;
    }

    public static final PropertyBundle getBundle(String baseName, Locale locale, Locator locator) {
        return PropertyBundle.getBundle(baseName, locale, locator, false);
    }

    public static final PropertyBundle getBundle(String baseName, Locale locale, boolean caseInsensitive) {
        return PropertyBundle.getBundle(baseName, locale, Locators.getDefault(), caseInsensitive);
    }

    public static final PropertyBundle getBundle(String baseName, Locale locale) {
        return PropertyBundle.getBundle(baseName, locale, false);
    }

    protected PropertyBundle(String baseName, Locale locale, Locator locator, boolean caseInsensitive) {
        try {
            Locators.StreamLocation loc = Locators.locateAsStream(baseName + ".properties", locale, locator);
            if (loc != null) {
                this._map = new HashMap<String, String>(32);
                Maps.load(this._map, loc.stream, caseInsensitive);
                this._locale = loc.locale;
            } else {
                this._map = null;
                this._locale = null;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw SystemException.Aide.wrap((Throwable)ex, "Unable to load " + baseName + ".properties");
        }
    }

    public final String getProperty(String key) {
        return this._map.get(key);
    }

    public final Map<String, String> getProperties() {
        return this._map;
    }

    public final Locale getLocale() {
        return this._locale;
    }

    static {
        _cache.setMaxSize(100);
    }

    private static class Key {
        private String baseName;
        private Locale locale;
        private Locator locator;
        private boolean caseInsensitive;

        private Key(String baseName, Locale locale, Locator locator, boolean caseInsensitive) {
            this.baseName = baseName;
            this.locale = locale;
            this.locator = locator;
            this.caseInsensitive = caseInsensitive;
        }

        public int hashCode() {
            return this.baseName.hashCode() ^ (this.locale != null ? this.locale.hashCode() : 0) ^ this.locator.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return k.baseName.equals(this.baseName) && Objects.equals(k.locale, this.locale) && k.locator.equals(this.locator) && k.caseInsensitive == this.caseInsensitive;
        }
    }
}

