/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotableLinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Cloneable,
Serializable {
    private final LinkedList<E> _list = new LinkedList();

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListIter(index);
    }

    protected void onAdd(E newElement, E followingElement) {
    }

    protected void onSet(E newElement, E replaced) {
    }

    protected void onRemove(E element) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIter
    implements ListIterator<E> {
        private final ListIterator<E> _iter;
        private E _last;
        private boolean _lastReady;

        private ListIter(int index) {
            this._iter = NotableLinkedList.this._list.listIterator(index);
        }

        @Override
        public void add(E o) {
            Object nxt;
            if (this.hasNext()) {
                nxt = this.next();
                this.previous();
            } else {
                nxt = null;
            }
            NotableLinkedList.this.onAdd(o, nxt);
            this._iter.add(o);
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this._iter.hasPrevious();
        }

        @Override
        public E next() {
            this._last = this._iter.next();
            this._lastReady = true;
            return this._last;
        }

        @Override
        public E previous() {
            this._last = this._iter.previous();
            this._lastReady = true;
            return this._last;
        }

        @Override
        public int nextIndex() {
            return this._iter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this._iter.previousIndex();
        }

        @Override
        public void remove() {
            if (this._lastReady) {
                NotableLinkedList.this.onRemove(this._last);
            }
            this._iter.remove();
            this._lastReady = false;
        }

        @Override
        public void set(E o) {
            if (this._lastReady) {
                NotableLinkedList.this.onSet(o, this._last);
            }
            this._iter.set(o);
        }
    }
}

