/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.fsm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.fsm.StateCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateMachine<E, C, IN> {
    protected final Map<E, StateCtx<E, C, IN>> _states = new HashMap<E, StateCtx<E, C, IN>>();
    protected E _current;
    protected boolean _run;
    protected int _step;
    protected boolean _debug = false;

    public StateMachine() {
        this.init();
        this.reset();
    }

    public StateMachine<E, C, IN> setDebugMode(boolean mode) {
        this._debug = mode;
        return this;
    }

    public StateCtx<E, C, IN> setState(E token, StateCtx<E, C, IN> state) {
        if (state == null) {
            throw new IllegalArgumentException("State cannot be null. Use removeState() to remove a state.");
        }
        this._states.put(token, state.setMaster(this));
        return state;
    }

    public StateCtx<E, C, IN> removeState(E token) {
        return this._states.remove(token).setMaster(null);
    }

    public StateCtx<E, C, IN> getState(E token) {
        return this.getState(token, true);
    }

    public StateCtx<E, C, IN> getState(E token, boolean autoCreate) {
        StateCtx<E, C, IN> result = this._states.get(token);
        if (result == null && autoCreate) {
            result = new StateCtx().setMaster(this);
            this._states.put(token, result);
        }
        return result;
    }

    protected void init() {
    }

    protected abstract E getLandingState(IN var1, C var2);

    protected abstract C getClass(IN var1);

    protected void onReset() {
    }

    protected void onStart(IN input, C inputClass, E landing) {
    }

    protected void beforeStep(IN input, C inputClass, E origin) {
    }

    protected void afterStep(IN input, C inputClass, E origin, E destination) {
    }

    protected void onStop(boolean endOfInput) {
    }

    protected void onReject(IN input) {
        throw new StateMachineException(this._step, this._current, input);
    }

    protected void onDebug(String message) {
    }

    public final void run(Iterator<IN> inputs) {
        this._run = true;
        while (this._run && inputs.hasNext()) {
            this.run(inputs.next());
        }
        boolean endOfInput = !inputs.hasNext();
        this.onStop(endOfInput);
        if (this._current != null) {
            this.getState(this._current).onStop(endOfInput);
        }
        this.doDebug("");
        this.doDebug("Stop");
        this.doDebug("");
    }

    public final void run(IN input) {
        C inputClass = this.getClass(input);
        this.doDebug("");
        this.doDebug("Step " + this._step);
        this.doDebug("* Input: " + input + " (" + inputClass + ")");
        E origin = this._current;
        E destination = null;
        this.beforeStep(input, inputClass, origin);
        if (inputClass == null) {
            this.doReject(input);
            return;
        }
        if (origin == null) {
            destination = this.getLandingState(input, inputClass);
            if (destination == null) {
                this.doReject(input);
                return;
            }
            this.onStart(input, inputClass, destination);
            this.getState(destination).onLand(input, inputClass, origin);
        } else {
            StateCtx<E, C, IN> state = this.getState(origin);
            if (state.isLeaving(input, inputClass)) {
                destination = state.getDestination(input, inputClass);
                if (destination == null) {
                    this.doReject(input);
                    return;
                }
                state.onLeave(input, inputClass, destination);
                state.doTransit(input, inputClass);
                this.getState(destination).onLand(input, inputClass, origin);
            } else if (state.isReturning(input, inputClass)) {
                destination = origin;
                state.onReturn(input, inputClass);
            } else {
                state.onReject(input, inputClass);
                this.doReject(input);
                return;
            }
        }
        this._current = destination;
        this.doDebug("* State: " + origin + " -> " + destination);
        this.afterStep(input, inputClass, origin, destination);
        ++this._step;
    }

    public final void start(Iterator<IN> inputs) {
        this.reset();
        this.run((IN)inputs);
    }

    public final void start(IN input) {
        this.reset();
        this.run(input);
    }

    public final void terminate() {
        this.reset();
    }

    public E getCurrentState() {
        return this._current;
    }

    public boolean isTerminated() {
        return !this._run && this._current == null;
    }

    public boolean isSuspended() {
        return !this._run && this._current != null;
    }

    protected final void suspend() {
        this._run = false;
    }

    protected final void doReject(IN input) {
        this._run = false;
        this.onReject(input);
    }

    protected final void doDebug(String message) {
        if (this._debug) {
            this.onDebug(message);
        }
    }

    private final void reset() {
        this._current = null;
        this._run = false;
        this._step = 0;
        this.doDebug("");
        this.doDebug("Reset");
        this.onReset();
    }

    final void terminateAt(IN input) {
        this.getState(this._current).onLeave(input, null, null);
        this.reset();
    }

    public static class StateMachineException
    extends RuntimeException {
        private static final long serialVersionUID = -6580348498729948101L;
        private int _step;
        private Object _state;
        private Object _input;

        public StateMachineException(int step, Object state, Object input) {
            this(step, state, input, "Rejected at step " + step + " with current state: " + state + ", input: " + input);
        }

        public StateMachineException(int step, Object state, Object input, String message) {
            super(message);
            this._step = step;
            this._state = state;
            this._input = input;
        }

        public StateMachineException(String message) {
            super(message);
        }

        public int getStep() {
            return this._step;
        }

        public Object getState() {
            return this._state;
        }

        public Object getInput() {
            return this._input;
        }
    }
}

