/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel.util;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Generics;
import org.zkoss.lang.SystemException;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.Locator;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.VariableResolverX;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.util.SimpleXelContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluators {
    private static final Log log = Log.lookup(Evaluators.class);
    private static final Map<String, Object> _evals = new HashMap<String, Object>(8);
    private static boolean _loaded;

    private Evaluators() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Class<? extends ExpressionFactory> getEvaluatorClass(String name) {
        Object clsnm;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("empty or null");
        }
        if (!_loaded) {
            Evaluators.load();
        }
        String evalnm = name.toLowerCase();
        Map<String, Object> map = _evals;
        synchronized (map) {
            clsnm = _evals.get(evalnm);
        }
        if (clsnm == null) {
            throw new SystemException("Evaluator not found: " + name);
        }
        if (clsnm instanceof Class) {
            Class cls = (Class)clsnm;
            if (!ExpressionFactory.class.isAssignableFrom(cls)) {
                throw new SystemException(cls + " must implements " + ExpressionFactory.class);
            }
            return Generics.cast(cls);
        }
        try {
            return Generics.cast(Classes.forNameByThread((String)clsnm));
        }
        catch (ClassNotFoundException ex) {
            throw new SystemException("Failed to load class " + clsnm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean exists(String name) {
        if (name == null) {
            return false;
        }
        if (!_loaded) {
            Evaluators.load();
        }
        name = name.toLowerCase();
        Map<String, Object> map = _evals;
        synchronized (map) {
            return _evals.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String add(String name, String evalcls) {
        Object old;
        if (name == null || name.length() == 0 || evalcls == null || evalcls.length() == 0) {
            throw new IllegalArgumentException("emty or null");
        }
        if (log.debugable()) {
            log.debug("Evaluator is added: " + name + ", " + evalcls);
        }
        String evalnm = name.toLowerCase();
        Map<String, Object> map = _evals;
        synchronized (map) {
            old = _evals.put(evalnm, evalcls);
        }
        return old instanceof Class ? ((Class)old).getName() : (String)old;
    }

    public static final String add(Element config) {
        String name = IDOMs.getRequiredElementValue(config, "evaluator-name");
        String clsnm = IDOMs.getRequiredElementValue(config, "evaluator-class");
        return Evaluators.add(name, clsnm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final synchronized void load() {
        if (_loaded) {
            return;
        }
        try {
            ClassLocator loc = new ClassLocator();
            Enumeration<URL> en = loc.getResources("metainfo/xel/config.xml");
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                if (log.debugable()) {
                    log.debug("Loading " + url);
                }
                try {
                    Document doc = new SAXBuilder(false, false, true).build(url);
                    if (!IDOMs.checkVersion(doc, url)) continue;
                    Evaluators.parseConfig(doc.getRootElement(), loc);
                }
                catch (Exception ex) {
                    log.error("Failed to parse " + url, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
        finally {
            _loaded = true;
        }
    }

    private static void parseConfig(Element root, Locator loc) {
        Iterator<Element> it = root.getElements("xel-config").iterator();
        while (it.hasNext()) {
            Evaluators.add(it.next());
        }
    }

    public static Object resolveVariable(XelContext ctx, VariableResolver resolver, Object base, Object name) {
        if (resolver instanceof VariableResolverX) {
            if (ctx == null) {
                ctx = new SimpleXelContext(resolver);
            }
            return ((VariableResolverX)resolver).resolveVariable(ctx, base, name);
        }
        if (resolver != null && base == null && name != null) {
            return resolver.resolveVariable(name.toString());
        }
        return null;
    }

    public static Object resolveVariable(XelContext ctx, Object base, Object name) {
        if (ctx != null) {
            VariableResolver resolver = ctx.getVariableResolver();
            if (resolver instanceof VariableResolverX) {
                return ((VariableResolverX)resolver).resolveVariable(ctx, base, name);
            }
            if (resolver != null && base == null && name != null) {
                return resolver.resolveVariable(name.toString());
            }
        }
        return null;
    }

    public static Object resolveVariable(VariableResolver resolver, String name) {
        return resolver != null ? Evaluators.resolveVariable(new SimpleXelContext(resolver), null, name) : null;
    }
}

