/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.zkoss.util.Locales;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.Locator;

public class Locators {
    private static final Log log = Log.lookup(Locators.class);
    private static final Locator _locator = new ClassLocator();

    public static final Locator getDefault() {
        return _locator;
    }

    public static final URLLocation locate(String file, Locale locale, Locator locator) {
        return (URLLocation)Locators.myLocate(file, locale, locator, false);
    }

    public static final StreamLocation locateAsStream(String file, Locale locale, Locator locator) {
        return (StreamLocation)Locators.myLocate(file, locale, locator, true);
    }

    private static final Object myLocate(String file, Locale locale, Locator locator, boolean asStream) {
        int jslash;
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        int jdot = (jslash = file.lastIndexOf(47)) >= 0 ? file.indexOf(46, jslash + 1) : file.indexOf(46);
        String ext = jdot >= 0 ? file.substring(jdot) : "";
        int jul = Locales.indexOfUnderline(file, jslash >= 0 ? jslash + 1 : 0);
        String base = file.substring(0, jul >= 0 && (jdot < 0 || jul < jdot) ? jul : (jdot >= 0 ? jdot : file.length()));
        if (log.debugable()) {
            log.debug("svl=" + file + " base=" + base + " ext=" + ext);
        }
        int baseLen = base.length();
        StringBuffer sb = new StringBuffer(baseLen + 16).append(base);
        String[] args = new String[1];
        String[] secs = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
        int j = secs.length;
        while (--j >= -1) {
            Locale l;
            if (j >= 0 && secs[j].length() == 0) continue;
            sb.setLength(baseLen);
            for (int k = 0; k <= j; ++k) {
                sb.append('_').append(secs[k]);
            }
            sb.append(ext);
            args[0] = sb.toString();
            Object found = asStream ? locator.getResourceAsStream(args[0]) : locator.getResource(args[0]);
            if (found == null) continue;
            if (j >= 0) {
                sb.setLength(0);
                for (int k = 0; k <= j; ++k) {
                    if (k > 0) {
                        sb.append('_');
                    }
                    sb.append(secs[k]);
                }
                l = Locales.getLocale(sb.toString(), '_');
            } else {
                l = null;
            }
            if (asStream) {
                return new StreamLocation((InputStream)found, l);
            }
            return new URLLocation((URL)found, args[0].equals(file) ? file : args[0], l);
        }
        return null;
    }

    public static class StreamLocation {
        public final InputStream stream;
        public final Locale locale;

        public StreamLocation(InputStream stream, Locale locale) {
            this.stream = stream;
            this.locale = locale;
        }

        public String toString() {
            return "[l=" + this.locale + ']';
        }
    }

    public static class URLLocation {
        public final URL url;
        public final String file;
        public final Locale locale;

        public URLLocation(URL url, String file, Locale locale) {
            this.url = url;
            this.file = file;
            this.locale = locale;
        }

        public String toString() {
            return "[url: " + this.url + " file=" + this.file + " l=" + this.locale + ']';
        }
    }
}

