/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import com.sun.jna.Native;
import java.io.IOException;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.unix.LibC;

public class UnixProcess
extends PidProcess {
    public UnixProcess(int pid) {
        super(pid);
    }

    @Override
    public boolean isAlive() throws IOException {
        if (LibC.INSTANCE.getpgid(this.pid) != -1) {
            return true;
        }
        int errno = Native.getLastError();
        if (errno == 3) {
            return false;
        }
        throw new IOException("Error getting target process group - errno = " + errno);
    }

    @Override
    public void destroy(boolean forceful) throws IOException {
        this.kill(forceful ? 9 : 15);
    }

    public boolean kill(int signal) throws IOException {
        if (LibC.INSTANCE.kill(this.pid, signal) != -1) {
            return true;
        }
        int errno = Native.getLastError();
        if (errno == 3) {
            return false;
        }
        throw new IOException("Error killing target process with signal " + signal + " - errno = " + errno);
    }
}

