/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import com.sun.jna.Pointer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.process.ReflectionUtil;
import org.zeroturnaround.process.SunPidUtil;
import org.zeroturnaround.process.win.Kernel32;
import org.zeroturnaround.process.win.W32API;

public final class PidUtil {
    private static final Logger log = LoggerFactory.getLogger(PidUtil.class);

    public static int getMyPid() {
        Integer result = MyPidHolder.MY_PID;
        if (result == null) {
            throw new UnsupportedOperationException("Could not detect my process ID.");
        }
        return result;
    }

    private static int getPidFromProcessName(String processName) {
        Pattern pattern = Pattern.compile("^([0-9]+)@.+$", 2);
        Matcher matcher = pattern.matcher(processName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new IllegalArgumentException("Invalid process name " + processName);
    }

    public static int getPid(Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Process must be provided.");
        }
        int result = PidUtil.doGetPid(process);
        log.debug("Found PID for {}: {}", (Object)process, (Object)result);
        return result;
    }

    private static int doGetPid(Process process) {
        String type;
        try {
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
                return PidUtil.getPIdOnJava9(process);
            }
            type = process.getClass().getName();
            if (type.equals("java.lang.UNIXProcess")) {
                return PidUtil.getPidFromUnixProcess(process);
            }
            if (type.equals("java.lang.Win32Process") || type.equals("java.lang.ProcessImpl")) {
                return PidUtil.getPidFromWin32Process(process);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not detect PID from " + process, e);
        }
        throw new IllegalArgumentException("Unknown process class " + type);
    }

    private static int getPidFromUnixProcess(Process process) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = process.getClass().getDeclaredField("pid");
        f.setAccessible(true);
        return f.getInt(process);
    }

    private static int getPidFromWin32Process(Process process) throws NoSuchFieldException, IllegalAccessException {
        return PidUtil.getPidFromHandle(PidUtil.getHandle(process));
    }

    private static long getHandle(Process process) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = process.getClass().getDeclaredField("handle");
        f.setAccessible(true);
        return f.getLong(process);
    }

    private static int getPidFromHandle(long value) {
        Kernel32 kernel = Kernel32.INSTANCE;
        W32API.HANDLE handle = new W32API.HANDLE();
        handle.setPointer(Pointer.createConstant((long)value));
        return kernel.GetProcessId(handle);
    }

    private static int getPIdOnJava9(Process process) {
        return PidUtil.toInt((Long)ReflectionUtil.invokeWithoutDeclaredExceptions(Java9Pid.PROCESS_PID, process, new Object[0]));
    }

    private static int getCurrentPIdOnJava9() throws Exception {
        Object handle = Java9Pid.PROCESS_HANDLE_CURRENT.invoke(null, new Object[0]);
        return PidUtil.toInt((Long)Java9Pid.PROCESS_HANDLE_PID.invoke(handle, new Object[0]));
    }

    private static int toInt(long pid) {
        if (pid < Integer.MIN_VALUE || pid > Integer.MAX_VALUE) {
            throw new IllegalStateException("PID is out of range: " + pid);
        }
        return (int)pid;
    }

    private static class Java9Pid {
        private static final Method PROCESS_PID;
        private static final Method PROCESS_HANDLE_CURRENT;
        private static final Method PROCESS_HANDLE_PID;

        private Java9Pid() {
        }

        static {
            try {
                PROCESS_PID = Process.class.getMethod("pid", new Class[0]);
                Class<?> handle = Class.forName("java.lang.ProcessHandle");
                PROCESS_HANDLE_CURRENT = handle.getMethod("current", new Class[0]);
                PROCESS_HANDLE_PID = handle.getMethod("pid", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MyPidHolder {
        private static final Integer MY_PID = MyPidHolder.findMyPid();

        private MyPidHolder() {
        }

        private static Integer findMyPid() {
            Integer result = null;
            try {
                if (SystemUtils.IS_JAVA_9) {
                    result = PidUtil.getCurrentPIdOnJava9();
                } else {
                    RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
                    result = SunPidUtil.tryGetPid(rtb);
                    if (result == null) {
                        String processName = rtb.getName();
                        result = PidUtil.getPidFromProcessName(processName);
                        log.debug("My process name: {}", (Object)processName);
                    }
                }
                log.debug("My PID: {}", (Object)result);
            }
            catch (Exception e) {
                log.error("Could not detect my PID:", (Throwable)e);
            }
            return result;
        }
    }
}

