/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.stream.ExecuteStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WaitForProcess
implements Callable<ProcessResult> {
    private static final Logger log = LoggerFactory.getLogger(WaitForProcess.class);
    private final Process process;
    private final Set<Integer> allowedExitValues;
    private final ExecuteStreamHandler streams;
    private final ByteArrayOutputStream out;
    private final ProcessListener listener;

    public WaitForProcess(Process process, Set<Integer> allowedExitValues, ExecuteStreamHandler streams, ByteArrayOutputStream out, ProcessListener listener) {
        this.process = process;
        this.allowedExitValues = allowedExitValues;
        this.streams = streams;
        this.out = out;
        this.listener = listener;
    }

    public Process getProcess() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessResult call() throws IOException, InterruptedException {
        try {
            int exit;
            boolean finished = false;
            try {
                exit = this.process.waitFor();
                finished = true;
                log.debug("{} stopped with exit code {}", (Object)this, (Object)exit);
            }
            finally {
                if (!finished) {
                    log.debug("Stopping {}...", (Object)this);
                    this.process.destroy();
                }
                if (this.streams != null) {
                    this.streams.stop();
                }
                this.closeStreams(this.process);
            }
            byte[] output = this.out == null ? null : this.out.toByteArray();
            ProcessResult result = new ProcessResult(exit, output);
            this.checkExit(result);
            ProcessResult processResult = result;
            return processResult;
        }
        finally {
            this.listener.afterStop(this.process);
        }
    }

    private void checkExit(ProcessResult result) {
        if (this.allowedExitValues != null && !this.allowedExitValues.contains(result.exitValue())) {
            throw new InvalidExitValueException(result, this.allowedExitValues);
        }
    }

    private void closeStreams(Process process) throws IOException {
        IOException caught = null;
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process input stream:", (Throwable)e);
            caught = e;
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process output stream:", (Throwable)e);
            caught = e;
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process error stream:", (Throwable)e);
            caught = e;
        }
        if (caught != null) {
            throw caught;
        }
    }

    public String toString() {
        return this.process.toString();
    }
}

