/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class I18N {
    private ResourceBundle stdMessages = null;
    private Locale locale = null;
    private Map<String, ResourceBundle> addonMessages = new HashMap<String, ResourceBundle>();
    private static final Logger logger = Logger.getLogger(I18N.class);

    public I18N(Locale locale) {
        this.setLocale(locale);
    }

    public void addMessageBundle(String prefix, ResourceBundle bundle) {
        logger.debug((Object)("Adding message bundle with prefix: " + prefix));
        if (this.addonMessages.containsKey(prefix)) {
            logger.error((Object)("Adding message bundle with duplicate prefix: " + prefix));
        }
        this.addonMessages.put(prefix, bundle);
    }

    public void removeMessageBundle(String prefix) {
        logger.debug((Object)("Removing message bundle with prefix: " + prefix));
        if (this.addonMessages.containsKey(prefix)) {
            this.addonMessages.remove(prefix);
        } else {
            logger.debug((Object)("Message bundle not found, prefix: " + prefix));
        }
    }

    public ResourceBundle getMessageBundle(String prefix) {
        return this.addonMessages.get(prefix);
    }

    public String getString(String key) {
        String prefix;
        ResourceBundle bundle;
        if (key.indexOf(".") > 0 && (bundle = this.addonMessages.get(prefix = key.substring(0, key.indexOf(".")))) != null && bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        return this.stdMessages.getString(key);
    }

    public String getHtmlWrappedString(String key) {
        String values = this.getString(key);
        if (values == null) {
            return null;
        }
        return "<html><p>" + values + "</p></html>";
    }

    public char getChar(String key) {
        try {
            String str = this.getString(key);
            if (str.length() > 0) {
                return str.charAt(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return '\u0000';
    }

    public void setLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return;
        }
        this.locale = locale;
        this.stdMessages = ResourceBundle.getBundle("Messages", locale, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    }

    public Locale getLocal() {
        return this.locale;
    }

    public boolean containsKey(String key) {
        String prefix;
        ResourceBundle bundle;
        if (key.indexOf(".") > 0 && (bundle = this.addonMessages.get(prefix = key.substring(0, key.indexOf(".")))) != null && bundle.containsKey(key)) {
            return true;
        }
        return this.stdMessages.containsKey(key);
    }

    public String getString(String key, Object ... params) {
        try {
            return MessageFormat.format(this.getString(key), params);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }
}

