/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import org.zaproxy.zap.network.DefaultHttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRedirectionValidator;

public class HttpRequestConfig {
    private final boolean followRedirects;
    private final HttpRedirectionValidator redirectionValidator;

    HttpRequestConfig(boolean followRedirects, HttpRedirectionValidator redirectionValidator) {
        this.followRedirects = followRedirects;
        this.redirectionValidator = redirectionValidator;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public HttpRedirectionValidator getRedirectionValidator() {
        return this.redirectionValidator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HttpRequestConfig configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Parameter configuration must not be null.");
        }
        return new Builder(configuration);
    }

    public static class Builder {
        private boolean followRedirects;
        private HttpRedirectionValidator redirectionValidator;

        private Builder() {
            this.followRedirects = false;
            this.redirectionValidator = DefaultHttpRedirectionValidator.INSTANCE;
        }

        private Builder(HttpRequestConfig config) {
            this.followRedirects = config.isFollowRedirects();
            this.redirectionValidator = config.getRedirectionValidator();
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setRedirectionValidator(HttpRedirectionValidator redirectionValidator) {
            if (redirectionValidator == null) {
                throw new IllegalArgumentException("Parameter redirectionValidator must not be null.");
            }
            this.redirectionValidator = redirectionValidator;
            this.followRedirects = true;
            return this;
        }

        public HttpRequestConfig build() {
            return new HttpRequestConfig(this.followRedirects, this.redirectionValidator);
        }
    }
}

