/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.sessions.ExtensionSessionManagement;
import org.zaproxy.zap.extension.users.ContextUserAuthManager;
import org.zaproxy.zap.extension.users.ContextUsersPanel;
import org.zaproxy.zap.extension.users.UsersAPI;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;

public class ExtensionUserManagement
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    public static final String CONTEXT_CONFIG_USERS = "context.users";
    public static final String CONTEXT_CONFIG_USERS_USER = "context.users.user";
    public static final int EXTENSION_ORDER = 57;
    public static final String NAME = "ExtensionUserManagement";
    private static final Logger log = Logger.getLogger(ExtensionUserManagement.class);
    private Map<Integer, ContextUsersPanel> userPanelsMap = new HashMap<Integer, ContextUsersPanel>();
    private Map<Integer, ContextUserAuthManager> contextManagers = new HashMap<Integer, ContextUserAuthManager>();
    private UsersAPI api;
    private static final List<Class<?>> EXTENSION_DEPENDENCIES;
    private ExtensionHttpSessions extensionHttpSessions;

    public ExtensionUserManagement() {
        this.initialize();
    }

    protected ExtensionHttpSessions getExtensionHttpSessions() {
        if (this.extensionHttpSessions == null) {
            this.extensionHttpSessions = (ExtensionHttpSessions)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHttpSessions");
            if (this.extensionHttpSessions == null) {
                log.error((Object)("Http Sessions Extension should be enabled for the " + ExtensionUserManagement.class.getSimpleName() + " to work."));
            }
        }
        return this.extensionHttpSessions;
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(57);
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        Model.getSingleton().addContextDataFactory(this);
        if (this.getView() != null) {
            this.getView().addContextPanelFactory(this);
        }
        this.api = new UsersAPI(this);
        extensionHook.addApiImplementor(this.api);
    }

    @Override
    public List<Class<?>> getDependencies() {
        return EXTENSION_DEPENDENCIES;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context ctx) {
        return this.getContextPanel(ctx.getIndex());
    }

    private ContextUsersPanel getContextPanel(int contextId) {
        ContextUsersPanel panel = this.userPanelsMap.get(contextId);
        if (panel == null) {
            panel = new ContextUsersPanel(this, contextId);
            this.userPanelsMap.put(contextId, panel);
        }
        return panel;
    }

    public ContextUserAuthManager getContextUserAuthManager(int contextId) {
        ContextUserAuthManager manager = this.contextManagers.get(contextId);
        if (manager == null) {
            manager = new ContextUserAuthManager(contextId);
            this.contextManagers.put(contextId, manager);
        }
        return manager;
    }

    public List<User> getUIConfiguredUsers(int contextId) {
        ContextUsersPanel panel = this.userPanelsMap.get(contextId);
        if (panel != null) {
            return Collections.unmodifiableList(panel.getUsersTableModel().getUsers());
        }
        return null;
    }

    public UsersTableModel getUIConfiguredUsersModel(int contextId) {
        ContextUsersPanel panel = this.userPanelsMap.get(contextId);
        if (panel != null) {
            return panel.getUsersTableModel();
        }
        return null;
    }

    @Override
    public void discardContexts() {
        this.contextManagers.clear();
        this.userPanelsMap.clear();
    }

    @Override
    public void discardContext(Context ctx) {
        this.contextManagers.remove(ctx.getIndex());
        this.userPanelsMap.remove(ctx.getIndex());
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            List<String> encodedUsers = session.getContextDataStrings(context.getIndex(), 300);
            ContextUserAuthManager usersManager = this.getContextUserAuthManager(context.getIndex());
            for (String e : encodedUsers) {
                User u = User.decode(context.getIndex(), e);
                usersManager.addUser(u);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Unable to load Users.", (Throwable)ex);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            ArrayList<String> encodedUsers = new ArrayList<String>();
            ContextUserAuthManager m = this.contextManagers.get(context.getIndex());
            if (m != null) {
                for (User u : m.getUsers()) {
                    encodedUsers.add(User.encode(u));
                }
                session.setContextData(context.getIndex(), 300, encodedUsers);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Unable to persist Users.", (Throwable)ex);
        }
    }

    public void removeSharedContextUsers(Context sharedContext) {
        this.getContextPanel(sharedContext.getIndex()).getUsersTableModel().removeAllUsers();
    }

    public void addSharedContextUser(Context sharedContext, User user) {
        this.getContextPanel(sharedContext.getIndex()).getUsersTableModel().addUser(user);
    }

    public List<User> getSharedContextUsers(Context sharedContext) {
        return this.getContextPanel(sharedContext.getIndex()).getUsersTableModel().getUsers();
    }

    public void removeContextUsers(int contextId) {
        this.getContextUserAuthManager(contextId).removeAllUsers();
    }

    @Override
    public void exportContextData(Context ctx, Configuration config) {
        ContextUserAuthManager m = this.contextManagers.get(ctx.getIndex());
        if (m != null) {
            for (User u : m.getUsers()) {
                config.addProperty(CONTEXT_CONFIG_USERS_USER, (Object)User.encode(u));
            }
        }
    }

    @Override
    public void importContextData(Context ctx, Configuration config) {
        List list = config.getList(CONTEXT_CONFIG_USERS_USER);
        ContextUserAuthManager m = this.getContextUserAuthManager(ctx.getIndex());
        for (Object o : list) {
            User usersManager = User.decode(ctx.getIndex(), o.toString());
            m.addUser(usersManager);
        }
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionSessionManagement>> dependencies = new ArrayList<Class<ExtensionSessionManagement>>(3);
        dependencies.add(ExtensionHttpSessions.class);
        dependencies.add(ExtensionAuthentication.class);
        dependencies.add(ExtensionSessionManagement.class);
        EXTENSION_DEPENDENCIES = Collections.unmodifiableList(dependencies);
    }
}

