/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.utils.Enableable;

public abstract class PluginPassiveScanner
extends Enableable
implements PassiveScanner {
    private static final String PSCANS_KEY = "pscans.pscanner";
    private static final String ID_KEY = "id";
    private static final String CLASSNAME_KEY = "classname";
    private static final String LEVEL_KEY = "level";
    private static final String ENABLED_KEY = "enabled";
    private static final Integer[] DEFAULT_HISTORY_TYPES = new Integer[]{1, 15, 2, 10};
    private static final Set<Integer> DEFAULT_HISTORY_TYPES_SET = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(DEFAULT_HISTORY_TYPES)));
    private Plugin.AlertThreshold level = Plugin.AlertThreshold.DEFAULT;
    private Plugin.AlertThreshold defaultLevel = Plugin.AlertThreshold.MEDIUM;
    private Configuration config = null;
    private AddOn.Status status = AddOn.Status.unknown;

    public PluginPassiveScanner() {
        super(true);
    }

    public void setConfig(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("Parameter config must not be null.");
        }
        this.config = config;
        this.loadFrom(config);
    }

    public void loadFrom(Configuration conf) {
        List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(PSCANS_KEY);
        for (HierarchicalConfiguration sub : fields) {
            if (!this.isPluginConfiguration((Configuration)sub)) continue;
            this.setLevel(Plugin.AlertThreshold.valueOf(sub.getString(LEVEL_KEY, Plugin.AlertThreshold.DEFAULT.name())));
            this.setEnabled(sub.getBoolean(ENABLED_KEY, true));
            break;
        }
    }

    private boolean isPluginConfiguration(Configuration configuration) {
        return configuration.containsKey(ID_KEY) && this.getPluginId() == configuration.getInt(ID_KEY) || this.getClass().getCanonicalName().equals(configuration.getString(CLASSNAME_KEY, ""));
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void save() {
        Configuration conf = this.getConfig();
        if (conf == null) {
            throw new IllegalStateException("No configuration has been set.");
        }
        this.saveTo(conf);
    }

    public void saveTo(Configuration conf) {
        boolean removed = false;
        List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(PSCANS_KEY);
        for (HierarchicalConfiguration sub : fields) {
            if (!this.isPluginConfiguration((Configuration)sub)) continue;
            sub.getRootNode().getParentNode().removeChild(sub.getRootNode());
            removed = true;
            break;
        }
        boolean persistId = false;
        String entryKey = "pscans.pscanner(" + (removed ? fields.size() - 1 : fields.size()) + ").";
        if (this.getLevel() != Plugin.AlertThreshold.MEDIUM) {
            conf.setProperty(entryKey + LEVEL_KEY, (Object)this.getLevel().name());
            persistId = true;
        }
        if (!this.isEnabled()) {
            conf.setProperty(entryKey + ENABLED_KEY, (Object)Boolean.FALSE);
            persistId = true;
        }
        if (persistId) {
            conf.setProperty(entryKey + ID_KEY, (Object)this.getPluginId());
        }
    }

    @Override
    public Plugin.AlertThreshold getLevel() {
        if (Plugin.AlertThreshold.DEFAULT.equals((Object)this.level)) {
            return this.defaultLevel;
        }
        return this.level;
    }

    public Plugin.AlertThreshold getLevel(boolean incDefault) {
        return this.level;
    }

    @Override
    public void setLevel(Plugin.AlertThreshold level) {
        if (level == null) {
            throw new IllegalArgumentException("Parameter level must not be null.");
        }
        this.level = level;
    }

    public void setDefaultLevel(Plugin.AlertThreshold level) {
        if (level == null || level == Plugin.AlertThreshold.DEFAULT) {
            throw new IllegalArgumentException("Parameter level must not be null or DEFAULT.");
        }
        this.defaultLevel = level;
    }

    public int getPluginId() {
        return -1;
    }

    public AddOn.Status getStatus() {
        return this.status;
    }

    public void setStatus(AddOn.Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Parameter status must not be null.");
        }
        this.status = status;
    }

    public static Set<Integer> getDefaultHistoryTypes() {
        return DEFAULT_HISTORY_TYPES_SET;
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(historyType);
    }
}

