/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.lang;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.lang.LangImporter;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.ViewLocale;

public class OptionsLangPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelLang = null;
    private JLabel languageLabel = null;
    private JLabel importLabel = null;
    private JLabel restartLabel = null;
    private JButton selectionButton = null;
    private JButton importButton = null;
    private JComboBox<ViewLocale> localeSelect = null;
    private ZapTextField fileTextField = null;
    private Document fileTextFieldDoc = null;

    public OptionsLangPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("options.lang.title"));
        this.add((Component)this.getPanelLang(), this.getPanelLang().getName());
    }

    private JPanel getPanelLang() {
        if (this.panelLang == null) {
            this.panelLang = new JPanel();
            this.panelLang.setName(Constant.messages.getString("options.lang.title"));
            this.panelLang.setLayout(new GridBagLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelLang.setSize(409, 268);
            }
            this.languageLabel = new JLabel(Constant.messages.getString("options.lang.selector.label"));
            this.importLabel = new JLabel(Constant.messages.getString("options.lang.importer.label"));
            this.restartLabel = new JLabel(Constant.messages.getString("options.lang.label.restart"));
            this.panelLang.add((Component)this.languageLabel, this.getGridBagConstraints(0, 0, 0.5, 0.0, 0, 0, 0));
            this.panelLang.add(this.getLocaleSelect(), this.getGridBagConstraints(1, 0, 0.5, 0.0, 0, 0, 0));
            this.panelLang.add((Component)this.importLabel, this.getGridBagConstraints(0, 1, 1.0, 0.0, 2, 0, 0));
            this.panelLang.add((Component)this.getFileTextField(), this.getGridBagConstraints(0, 2, 1.0, 0.0, 2, 0, 0));
            JPanel buttons = new JPanel();
            buttons.setLayout(new BoxLayout(buttons, 0));
            buttons.add(Box.createHorizontalGlue());
            buttons.add(this.getImportButton());
            buttons.add(this.getSelectionButton());
            this.panelLang.add((Component)buttons, this.getGridBagConstraints(0, 3, 0.5, 0.0, 2, 0, 12));
            this.panelLang.add((Component)this.restartLabel, this.getGridBagConstraints(0, 4, 1.0, 0.0, 2, 0, 0));
            this.panelLang.add((Component)new JLabel(""), this.getGridBagConstraints(0, 5, 1.0, 1.0, 2, 1, 0));
        }
        return this.panelLang;
    }

    private GridBagConstraints getGridBagConstraints(int x, int y, double weightx, double weighty, int columnWidth, int fill, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridwidth = columnWidth > 0 ? columnWidth : 1;
        gbc.fill = fill > 0 ? fill : 2;
        gbc.anchor = anchor > 0 ? anchor : 18;
        return gbc;
    }

    private ZapTextField getFileTextField() {
        if (this.fileTextField == null) {
            this.fileTextField = new ZapTextField();
            this.fileTextFieldDoc = this.fileTextField.getDocument();
            this.fileTextFieldDoc.addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updated(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updated(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updated(e);
                }

                private void updated(DocumentEvent e) {
                    try {
                        String inputString = e.getDocument().getText(0, e.getDocument().getLength());
                        OptionsLangPanel.this.importButton.setEnabled(inputString.endsWith(".zaplang"));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.fileTextField;
    }

    private JButton getSelectionButton() {
        if (this.selectionButton == null) {
            this.selectionButton = new JButton();
            this.selectionButton.setText(Constant.messages.getString("options.lang.importer.browse"));
            this.selectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsLangPanel.this.browseButtonActionPerformed(evt);
                }
            });
        }
        return this.selectionButton;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton();
            this.importButton.setEnabled(false);
            this.importButton.setText(Constant.messages.getString("options.lang.importer.button"));
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!OptionsLangPanel.this.fileTextField.getText().equals("")) {
                        LangImporter.importLanguagePack(OptionsLangPanel.this.fileTextField.getText());
                        OptionsLangPanel.this.fileTextField.setText("");
                        OptionsLangPanel.this.fileTextField.discardAllEdits();
                        OptionsLangPanel.this.loadLocales();
                    }
                }
            });
        }
        return this.importButton;
    }

    private JComboBox<ViewLocale> getLocaleSelect() {
        if (this.localeSelect == null) {
            this.localeSelect = new JComboBox();
            this.loadLocales();
        }
        return this.localeSelect;
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Constant.messages.getString("options.lang.file.chooser.description");
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".zaplang");
            }
        });
        int state = fc.showOpenDialog(null);
        if (state == 0) {
            this.fileTextField.setText(fc.getSelectedFile().toString());
            this.fileTextField.discardAllEdits();
        }
    }

    private void loadLocales() {
        this.localeSelect.removeAllItems();
        for (ViewLocale locale : LocaleUtils.getAvailableViewLocales()) {
            this.localeSelect.addItem(locale);
        }
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        ViewLocale locale = LocaleUtils.getViewLocale(options.getViewParam().getLocale());
        this.localeSelect.setSelectedItem(locale);
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        ViewLocale selectedLocale = (ViewLocale)this.localeSelect.getSelectedItem();
        if (selectedLocale != null) {
            options.getViewParam().setLocale(selectedLocale.getLocale());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.language";
    }
}

