/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public class PopupMenuPurgeHistory
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = -155358408946131183L;
    private final ExtensionHistory extension;

    public PopupMenuPurgeHistory(ExtensionHistory extension) {
        super(Constant.messages.getString("history.purge.popup"), true);
        this.extension = extension;
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.HISTORY_PANEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performHistoryReferenceActions(List<HistoryReference> hrefs) {
        int result;
        if (hrefs.size() > 1 && (result = this.extension.getView().showConfirmDialog(Constant.messages.getString("history.purge.warning"))) != 0) {
            return;
        }
        ExtensionHistory extensionHistory = this.extension;
        synchronized (extensionHistory) {
            for (HistoryReference href : hrefs) {
                this.purgeHistory(href);
            }
        }
    }

    @Override
    public void performAction(HistoryReference href) {
    }

    private void purgeHistory(HistoryReference ref) {
        if (ref == null) {
            return;
        }
        this.extension.removeFromHistoryList(ref);
        ExtensionAlert extAlert = (ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert");
        if (extAlert != null) {
            extAlert.deleteHistoryReferenceAlerts(ref);
        }
        this.extension.delete(ref);
        SiteNode node = ref.getSiteNode();
        if (node == null) {
            return;
        }
        SiteMap map = Model.getSingleton().getSession().getSiteTree();
        if (node.getHistoryReference() == ref) {
            this.extension.purge(map, node);
        } else {
            node.getPastHistoryReference().remove(ref);
            map.removeHistoryReference(ref.getHistoryId());
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

