/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.ext.ExtensionExtension;
import org.zaproxy.zap.extension.ext.ExtensionParam;
import org.zaproxy.zap.extension.ext.OptionsExtensionTableModel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsExtensionPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JTable tableExt = null;
    private JScrollPane jScrollPane = null;
    private JPanel detailsPane = null;
    private JLabel extName = new JLabel();
    private JLabel extAuthor = new JLabel();
    private JLabel extURL = new JLabel();
    private JTextArea extDescription = new JTextArea();
    private OptionsExtensionTableModel extensionModel = null;
    private JScrollPane extDescScrollPane = null;
    private JButton urlLaunchButton = null;
    private static Logger log = Logger.getLogger(OptionsExtensionPanel.class);

    public OptionsExtensionPanel(ExtensionExtension ext) {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        JLabel jLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setSize(409, 268);
        this.setName(Constant.messages.getString("options.ext.title"));
        jLabel.setText(Constant.messages.getString("options.ext.label.enable"));
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.75;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.25;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.ipadx = 0;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints3.anchor = 18;
        this.add((Component)jLabel, gridBagConstraints1);
        this.add((Component)this.getJScrollPane(), gridBagConstraints2);
        this.add((Component)this.getDetailsPane(), gridBagConstraints3);
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        ExtensionParam extParam = optionsParam.getExtensionParam();
        List<Extension> exts = this.extensionModel.getExtensions();
        for (Extension ext : exts) {
            ext.setEnabled(extParam.isExtensionEnabled(ext.getName()));
        }
        this.extensionModel.fireTableRowsUpdated(0, this.extensionModel.getRowCount());
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        HashMap<String, Boolean> extensionsState = new HashMap<String, Boolean>();
        List<Extension> exts = this.extensionModel.getExtensions();
        for (Extension ext : exts) {
            extensionsState.put(ext.getName(), ext.isEnabled());
        }
        optionsParam.getExtensionParam().setExtensionsState(extensionsState);
    }

    private JTable getTableExtension() {
        if (this.tableExt == null) {
            this.tableExt = new JTable();
            this.tableExt.setModel(this.getExtensionModel());
            this.tableExt.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableExt.getColumnModel().getColumn(0).setPreferredWidth(DisplayUtils.getScaledSize(70));
            this.tableExt.getColumnModel().getColumn(1).setPreferredWidth(DisplayUtils.getScaledSize(70));
            this.tableExt.getColumnModel().getColumn(2).setPreferredWidth(DisplayUtils.getScaledSize(120));
            this.tableExt.getColumnModel().getColumn(3).setPreferredWidth(DisplayUtils.getScaledSize(220));
            ListSelectionListener sl = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent arg0) {
                    Extension ext;
                    if (OptionsExtensionPanel.this.tableExt.getSelectedRow() > -1 && (ext = ((OptionsExtensionTableModel)OptionsExtensionPanel.this.tableExt.getModel()).getExtension(OptionsExtensionPanel.this.tableExt.getSelectedRow())) != null) {
                        try {
                            OptionsExtensionPanel.this.extName.setText(ext.getUIName());
                            OptionsExtensionPanel.this.extDescription.setText(ext.getDescription());
                            if (ext.getAuthor() != null) {
                                OptionsExtensionPanel.this.extAuthor.setText(ext.getAuthor());
                            } else {
                                OptionsExtensionPanel.this.extAuthor.setText("");
                            }
                            if (ext.getURL() != null) {
                                OptionsExtensionPanel.this.extURL.setText(ext.getURL().toString());
                                OptionsExtensionPanel.this.getUrlLaunchButton().setEnabled(true);
                            } else {
                                OptionsExtensionPanel.this.extURL.setText("");
                                OptionsExtensionPanel.this.getUrlLaunchButton().setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
            this.tableExt.getSelectionModel().addListSelectionListener(sl);
            this.tableExt.getColumnModel().getSelectionModel().addListSelectionListener(sl);
        }
        return this.tableExt;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableExtension());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private JPanel getDetailsPane() {
        if (this.detailsPane == null) {
            this.detailsPane = new JPanel();
            this.detailsPane.setBorder(BorderFactory.createEtchedBorder(0));
            this.detailsPane.setLayout(new GridBagLayout());
            this.detailsPane.add((Component)new JLabel(Constant.messages.getString("options.ext.label.name")), LayoutHelper.getGBC(0, 1, 1, 0.25));
            this.detailsPane.add((Component)this.extName, LayoutHelper.getGBC(1, 1, 1, 0.75));
            this.detailsPane.add((Component)new JLabel(Constant.messages.getString("options.ext.label.author")), LayoutHelper.getGBC(0, 2, 1, 0.25));
            this.detailsPane.add((Component)this.extAuthor, LayoutHelper.getGBC(1, 2, 1, 0.75));
            this.detailsPane.add((Component)new JLabel(Constant.messages.getString("options.ext.label.url")), LayoutHelper.getGBC(0, 3, 1, 0.25));
            if (DesktopUtils.canOpenUrlInBrowser()) {
                this.detailsPane.add((Component)this.getUrlLaunchButton(), LayoutHelper.getGBC(1, 3, 1, 0.0, 0.0, 0));
            } else {
                this.detailsPane.add((Component)this.extURL, LayoutHelper.getGBC(1, 3, 1, 0.5));
            }
            this.detailsPane.add((Component)this.getExtDescJScrollPane(), LayoutHelper.getGBC(0, 4, 2, 1.0, 1.0));
        }
        return this.detailsPane;
    }

    private JButton getUrlLaunchButton() {
        if (this.urlLaunchButton == null) {
            this.urlLaunchButton = new JButton(Constant.messages.getString("options.ext.button.openurl"));
            this.urlLaunchButton.setEnabled(false);
            this.urlLaunchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (OptionsExtensionPanel.this.extURL.getText() != null) {
                        DesktopUtils.openUrlInBrowser(OptionsExtensionPanel.this.extURL.getText());
                    }
                }
            });
        }
        return this.urlLaunchButton;
    }

    private JScrollPane getExtDescJScrollPane() {
        if (this.extDescScrollPane == null) {
            this.extDescScrollPane = new JScrollPane();
            this.extDescScrollPane.setViewportView(this.extDescription);
            this.extDescription.setEditable(false);
            this.extDescription.setLineWrap(true);
        }
        return this.extDescScrollPane;
    }

    private OptionsExtensionTableModel getExtensionModel() {
        if (this.extensionModel == null) {
            this.extensionModel = new OptionsExtensionTableModel();
        }
        return this.extensionModel;
    }

    protected boolean enableExtension(String name, boolean enable) {
        Extension ext = this.getExtensionModel().getExtension(name);
        if (ext != null) {
            ext.setEnabled(enable);
            return true;
        }
        return false;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.ext";
    }
}

