/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.security.KeyStore;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.dynssl.SslCertificateUtils;

public class DynSSLParam
extends AbstractParam {
    static final String PARAM_ROOT_CA = "dynssl.param.rootca";
    private KeyStore rootca = null;
    private final Logger logger = Logger.getLogger(DynSSLParam.class);

    @Override
    protected void parse() {
        try {
            String rootcastr = this.getConfig().getString(PARAM_ROOT_CA, null);
            if (rootcastr != null) {
                this.setRootca(rootcastr);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Couldn't load Root CA parameter.", (Throwable)e);
        }
    }

    public void setRootca(String rootca) {
        try {
            this.setRootca(SslCertificateUtils.string2Keystore(rootca));
        }
        catch (Exception e) {
            this.logger.error((Object)"Couldn't save Root CA parameter.", (Throwable)e);
        }
    }

    public KeyStore getRootca() {
        return this.rootca;
    }

    public void setRootca(KeyStore rootca) {
        this.rootca = rootca;
        if (rootca != null) {
            try {
                this.getConfig().setProperty(PARAM_ROOT_CA, (Object)SslCertificateUtils.keyStore2String(rootca));
            }
            catch (Exception e) {
                this.logger.error((Object)"Couldn't save Root CA parameter.", (Throwable)e);
            }
        }
    }
}

