/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.callback;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.callback.CallbackParam;
import org.zaproxy.zap.extension.callback.ExtensionCallback;
import org.zaproxy.zap.utils.ZapPortNumberSpinner;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsCallbackPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panel = null;
    private ExtensionCallback ext;
    private JComboBox<String> localAddress = null;
    private JComboBox<String> remoteAddress = null;
    private ZapTextField testURL = null;
    private JCheckBox randomPort = null;
    private ZapPortNumberSpinner spinnerPort = null;

    public OptionsCallbackPanel(ExtensionCallback ext) {
        this.ext = ext;
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("callback.options.title"));
        this.add((Component)this.getCallbackPanel(), this.getCallbackPanel().getName());
    }

    private JPanel getCallbackPanel() {
        if (this.panel == null) {
            JLabel jLabel6 = new JLabel();
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 0.5;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.ipadx = 50;
            gridBagConstraints5.ipady = 0;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.ipadx = 0;
            gridBagConstraints6.ipady = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.weightx = 0.5;
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.weightx = 0.5;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.ipadx = 50;
            gridBagConstraints7.ipady = 0;
            gridBagConstraints7.anchor = 13;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            jLabel6.setText(Constant.messages.getString("options.proxy.local.label.browser"));
            gridBagConstraints15.anchor = 18;
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 4;
            gridBagConstraints15.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridwidth = 2;
            JLabel localAddrLabel = new JLabel(Constant.messages.getString("callback.options.label.localaddress"));
            localAddrLabel.setLabelFor(this.getLocalAddress());
            this.panel.add((Component)localAddrLabel, LayoutHelper.getGBC(0, 0, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add(this.getLocalAddress(), LayoutHelper.getGBC(1, 0, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel remoteAddrLabel = new JLabel(Constant.messages.getString("callback.options.label.remoteaddress"));
            remoteAddrLabel.setLabelFor(this.getRemoteAddress());
            this.panel.add((Component)remoteAddrLabel, LayoutHelper.getGBC(0, 1, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add(this.getRemoteAddress(), LayoutHelper.getGBC(1, 1, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel rndPortLabel = new JLabel(Constant.messages.getString("callback.options.label.rndport"));
            rndPortLabel.setLabelFor(this.getSpinnerPort());
            this.panel.add((Component)rndPortLabel, LayoutHelper.getGBC(0, 2, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getRandomPort(), LayoutHelper.getGBC(1, 2, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel portLabel = new JLabel(Constant.messages.getString("callback.options.label.port"));
            portLabel.setLabelFor(this.getSpinnerPort());
            this.panel.add((Component)portLabel, LayoutHelper.getGBC(0, 3, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getSpinnerPort(), LayoutHelper.getGBC(1, 3, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel testUrlLabel = new JLabel(Constant.messages.getString("callback.options.label.testurl"));
            testUrlLabel.setLabelFor(this.getTestURL());
            this.panel.add((Component)testUrlLabel, LayoutHelper.getGBC(0, 4, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getTestURL(), LayoutHelper.getGBC(1, 4, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 20, 2, 0.5, 1.0));
        }
        return this.panel;
    }

    private JComboBox<String> getLocalAddress() {
        if (this.localAddress == null) {
            this.localAddress = new JComboBox();
        }
        return this.localAddress;
    }

    private JComboBox<String> getRemoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = new JComboBox();
            this.remoteAddress.setEditable(true);
        }
        return this.remoteAddress;
    }

    private ZapTextField getTestURL() {
        if (this.testURL == null) {
            this.testURL = new ZapTextField();
            this.testURL.setEditable(false);
            this.testURL.setFocusable(true);
        }
        return this.testURL;
    }

    private JCheckBox getRandomPort() {
        if (this.randomPort == null) {
            this.randomPort = new JCheckBox();
            this.randomPort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    OptionsCallbackPanel.this.getSpinnerPort().setEnabled(!OptionsCallbackPanel.this.randomPort.isSelected());
                }
            });
        }
        return this.randomPort;
    }

    private ZapPortNumberSpinner getSpinnerPort() {
        if (this.spinnerPort == null) {
            this.spinnerPort = new ZapPortNumberSpinner(0);
        }
        return this.spinnerPort;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        CallbackParam proxyParam = optionsParam.getParamSet(CallbackParam.class);
        List<String> allAddrs = proxyParam.getAvailableAddresses(false);
        this.localAddress.removeAllItems();
        this.localAddress.addItem("0.0.0.0");
        for (String addr : allAddrs) {
            this.localAddress.addItem(addr);
        }
        this.localAddress.setSelectedItem(proxyParam.getLocalAddress());
        this.remoteAddress.removeAllItems();
        for (String addr : allAddrs) {
            this.remoteAddress.addItem(addr);
        }
        this.remoteAddress.setSelectedItem(proxyParam.getRemoteAddress());
        if (proxyParam.getPort() == 0) {
            this.getRandomPort().setSelected(true);
            this.getSpinnerPort().setEnabled(false);
            this.getSpinnerPort().setValue(this.ext.getPort());
        } else {
            this.getSpinnerPort().setEnabled(true);
            this.getSpinnerPort().setValue(proxyParam.getPort());
        }
        this.getTestURL().setText(this.ext.getTestUrl());
    }

    @Override
    public void validateParam(Object obj) throws Exception {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        CallbackParam proxyParam = optionsParam.getParamSet(CallbackParam.class);
        proxyParam.setLocalAddress((String)this.localAddress.getSelectedItem());
        proxyParam.setRemoteAddress((String)this.remoteAddress.getSelectedItem());
        if (this.getRandomPort().isSelected()) {
            proxyParam.setPort(0);
        } else {
            proxyParam.setPort(this.spinnerPort.getValue());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.callback";
    }
}

