/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import net.sf.json.JSONObject;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.brk.ExtensionBreak;
import org.zaproxy.zap.extension.httppanel.Message;

public class BreakAPI
extends ApiImplementor {
    private static final String PREFIX = "break";
    private static final String ACTION_BREAK = "break";
    private static final String ACTION_BREAK_ON_ID = "breakOnId";
    private static final String ACTION_ADD_HTTP_BREAK_POINT = "addHttpBreakpoint";
    private static final String ACTION_REM_HTTP_BREAK_POINT = "removeHttpBreakpoint";
    private static final String ACTION_CONTINUE = "continue";
    private static final String ACTION_STEP = "step";
    private static final String ACTION_DROP = "drop";
    private static final String ACTION_SET_HTTP_MESSAGE = "setHttpMessage";
    private static final String VIEW_IS_BREAK_ALL = "isBreakAll";
    private static final String VIEW_IS_BREAK_REQUEST = "isBreakRequest";
    private static final String VIEW_IS_BREAK_RESPONSE = "isBreakResponse";
    private static final String VIEW_HTTP_MESSAGE = "httpMessage";
    private static final String PARAM_STRING = "string";
    private static final String PARAM_LOCATION = "location";
    private static final String PARAM_MATCH = "match";
    private static final String PARAM_INVERSE = "inverse";
    private static final String PARAM_IGNORECASE = "ignorecase";
    private static final String PARAM_KEY = "key";
    private static final String PARAM_SCOPE = "scope";
    private static final String PARAM_STATE = "state";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_HTTP_HEADER = "httpHeader";
    private static final String PARAM_HTTP_BODY = "httpBody";
    private static final String VALUE_TYPE_HTTP_ALL = "http-all";
    private static final String VALUE_TYPE_HTTP_REQUESTS = "http-requests";
    private static final String VALUE_TYPE_HTTP_RESPONSES = "http-responses";
    private ExtensionBreak extension = null;

    public BreakAPI(ExtensionBreak ext) {
        this.extension = ext;
        this.addApiView(new ApiView(VIEW_IS_BREAK_ALL));
        this.addApiView(new ApiView(VIEW_IS_BREAK_REQUEST));
        this.addApiView(new ApiView(VIEW_IS_BREAK_RESPONSE));
        this.addApiView(new ApiView(VIEW_HTTP_MESSAGE));
        this.addApiAction(new ApiAction("break", new String[]{PARAM_TYPE, PARAM_STATE}, new String[]{PARAM_SCOPE}));
        this.addApiAction(new ApiAction(ACTION_SET_HTTP_MESSAGE, new String[]{PARAM_HTTP_HEADER}, new String[]{PARAM_HTTP_BODY}));
        this.addApiAction(new ApiAction(ACTION_CONTINUE));
        this.addApiAction(new ApiAction(ACTION_STEP));
        this.addApiAction(new ApiAction(ACTION_DROP));
        this.addApiAction(new ApiAction(ACTION_ADD_HTTP_BREAK_POINT, new String[]{PARAM_STRING, PARAM_LOCATION, PARAM_MATCH, PARAM_INVERSE, PARAM_IGNORECASE}));
        this.addApiAction(new ApiAction(ACTION_REM_HTTP_BREAK_POINT, new String[]{PARAM_STRING, PARAM_LOCATION, PARAM_MATCH, PARAM_INVERSE, PARAM_IGNORECASE}));
    }

    @Override
    public String getPrefix() {
        return "break";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        if ("break".equals(name)) {
            String type = params.getString(PARAM_TYPE).toLowerCase();
            if (type.equals(VALUE_TYPE_HTTP_ALL)) {
                this.extension.setBreakAllRequests(params.getBoolean(PARAM_STATE));
                this.extension.setBreakAllResponses(params.getBoolean(PARAM_STATE));
                return ApiResponseElement.OK;
            } else if (type.equals(VALUE_TYPE_HTTP_REQUESTS)) {
                this.extension.setBreakAllRequests(params.getBoolean(PARAM_STATE));
                return ApiResponseElement.OK;
            } else {
                if (!type.equals(VALUE_TYPE_HTTP_RESPONSES)) throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "type not in [http-all,http-requests,http-responses]");
                this.extension.setBreakAllResponses(params.getBoolean(PARAM_STATE));
            }
            return ApiResponseElement.OK;
        }
        if (ACTION_BREAK_ON_ID.equals(name)) {
            this.extension.setBreakOnId(params.getString(PARAM_KEY), params.getString(PARAM_STATE).toLowerCase().equals("on"));
            return ApiResponseElement.OK;
        }
        if (ACTION_CONTINUE.equals(name)) {
            this.extension.getBreakpointManagementInterface().cont();
            return ApiResponseElement.OK;
        }
        if (ACTION_STEP.equals(name)) {
            this.extension.getBreakpointManagementInterface().step();
            return ApiResponseElement.OK;
        }
        if (ACTION_DROP.equals(name)) {
            this.extension.getBreakpointManagementInterface().drop();
            return ApiResponseElement.OK;
        }
        if (ACTION_SET_HTTP_MESSAGE.equals(name)) {
            Message msg;
            if (this.extension.getBreakpointManagementInterface().getMessage() == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            String header = params.getString(PARAM_HTTP_HEADER);
            String body = this.getParam(params, PARAM_HTTP_BODY, "");
            if (header.indexOf("\r\n") < 0 && header.indexOf("\\n") >= 0) {
                header = header.replace("\\r", "\r").replace("\\n", "\n");
            }
            if (!((msg = this.extension.getBreakpointManagementInterface().getMessage()) instanceof HttpMessage)) return ApiResponseElement.OK;
            HttpMessage httpMsg = (HttpMessage)msg;
            if (this.extension.getBreakpointManagementInterface().isRequest()) {
                try {
                    httpMsg.setRequestHeader(header);
                    httpMsg.setRequestBody(body);
                    this.extension.getBreakpointManagementInterface().setMessage(httpMsg, true);
                    return ApiResponseElement.OK;
                }
                catch (HttpMalformedHeaderException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage());
                }
            } else {
                try {
                    httpMsg.setResponseHeader(header);
                    httpMsg.setResponseBody(body);
                    this.extension.getBreakpointManagementInterface().setMessage(httpMsg, false);
                    return ApiResponseElement.OK;
                }
                catch (HttpMalformedHeaderException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage());
                }
            }
        }
        if (ACTION_ADD_HTTP_BREAK_POINT.equals(name)) {
            try {
                this.extension.addHttpBreakpoint(params.getString(PARAM_STRING), params.getString(PARAM_LOCATION), params.getString(PARAM_MATCH), params.getBoolean(PARAM_INVERSE), params.getBoolean(PARAM_IGNORECASE));
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage());
            }
        }
        if (!ACTION_REM_HTTP_BREAK_POINT.equals(name)) throw new ApiException(ApiException.Type.BAD_ACTION);
        try {
            this.extension.removeHttpBreakpoint(params.getString(PARAM_STRING), params.getString(PARAM_LOCATION), params.getString(PARAM_MATCH), params.getBoolean(PARAM_INVERSE), params.getBoolean(PARAM_IGNORECASE));
            return ApiResponseElement.OK;
        }
        catch (Exception e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage());
        }
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        if (VIEW_IS_BREAK_ALL.equals(name)) {
            return new ApiResponseElement(name, Boolean.toString(this.extension.getBreakpointManagementInterface().isBreakAll()));
        }
        if (VIEW_IS_BREAK_REQUEST.equals(name)) {
            return new ApiResponseElement(name, Boolean.toString(this.extension.getBreakpointManagementInterface().isBreakRequest()));
        }
        if (VIEW_IS_BREAK_RESPONSE.equals(name)) {
            return new ApiResponseElement(name, Boolean.toString(this.extension.getBreakpointManagementInterface().isBreakResponse()));
        }
        if (VIEW_HTTP_MESSAGE.equals(name)) {
            Message msg = this.extension.getBreakpointManagementInterface().getMessage();
            if (msg == null) {
                return new ApiResponseElement(name, "");
            }
            if (msg instanceof HttpMessage) {
                HttpMessage httpMsg = (HttpMessage)msg;
                StringBuilder sb = new StringBuilder();
                if (this.extension.getBreakpointManagementInterface().isRequest()) {
                    sb.append(httpMsg.getRequestHeader().toString());
                    sb.append(httpMsg.getRequestBody().toString());
                } else {
                    sb.append(httpMsg.getResponseHeader().toString());
                    sb.append(httpMsg.getResponseBody().toString());
                }
                return new ApiResponseElement(name, sb.toString());
            }
            throw new ApiException(ApiException.Type.BAD_TYPE);
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }
}

