/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiResponseSet;

public final class ApiResponseConversionUtils {
    private static final Logger LOGGER = Logger.getLogger(ApiResponseConversionUtils.class);

    private ApiResponseConversionUtils() {
    }

    public static ApiResponseSet<String> httpMessageToSet(int historyId, HttpMessage msg) {
        return ApiResponseConversionUtils.httpMessageToSet(historyId, -1, msg);
    }

    public static ApiResponseSet<String> httpMessageToSet(int historyId, int historyType, HttpMessage msg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", String.valueOf(historyId));
        map.put("type", String.valueOf(historyType));
        map.put("timestamp", String.valueOf(msg.getTimeSentMillis()));
        map.put("rtt", String.valueOf(msg.getTimeElapsedMillis()));
        map.put("cookieParams", msg.getCookieParamsAsString());
        map.put("note", msg.getNote());
        map.put("requestHeader", msg.getRequestHeader().toString());
        map.put("requestBody", msg.getRequestBody().toString());
        map.put("responseHeader", msg.getResponseHeader().toString());
        if ("gzip".equals(msg.getResponseHeader().getHeader("Content-Encoding"))) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(msg.getResponseBody().getBytes());
                 GZIPInputStream gis = new GZIPInputStream(bais);
                 InputStreamReader isr = new InputStreamReader(gis);
                 BufferedReader br = new BufferedReader(isr);){
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                map.put("responseBody", sb.toString());
            }
            catch (IOException e) {
                LOGGER.error((Object)("Unable to uncompress gzip content: " + e.getMessage()), (Throwable)e);
                map.put("responseBody", msg.getResponseBody().toString());
            }
        } else {
            map.put("responseBody", msg.getResponseBody().toString());
        }
        return new ApiResponseSet<String>("message", map);
    }
}

