/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.utils.Stats;

public class AntiCsrfDetectScanner
implements PassiveScanner {
    public static final String ACSRF_STATS_PREFIX = "stats.acsrf.";
    private PassiveScanThread parent = null;
    private final ExtensionAntiCSRF extAntiCSRF;

    public AntiCsrfDetectScanner(ExtensionAntiCSRF extAntiCSRF) {
        this.extAntiCSRF = extAntiCSRF;
    }

    @Override
    public void setParent(PassiveScanThread parent) {
        this.parent = parent;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage msg, int id) {
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage msg, int id, Source source) {
        List<AntiCsrfToken> list = this.extAntiCSRF.getTokensFromResponse(msg, source);
        for (AntiCsrfToken token : list) {
            if (this.registerToken(msg.getHistoryRef().getHistoryType())) {
                if (this.parent != null) {
                    this.parent.addTag(id, "AntiCSRF");
                }
                this.extAntiCSRF.registerAntiCsrfToken(token);
            }
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), ACSRF_STATS_PREFIX + token.getName());
            }
            catch (URIException uRIException) {}
        }
    }

    @Override
    public String getName() {
        return "Anti CSRF Token Detection";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public Plugin.AlertThreshold getLevel() {
        return Plugin.AlertThreshold.MEDIUM;
    }

    @Override
    public void setLevel(Plugin.AlertThreshold level) {
    }

    private boolean registerToken(int historyType) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(historyType);
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        return true;
    }
}

