/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import net.sf.json.JSONObject;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;

public class AntiCsrfAPI
extends ApiImplementor {
    private static final String PREFIX = "acsrf";
    private static final String OTHER_GENERATE_FORM = "genForm";
    private static final String OTHER_GENERATE_FORM_PARAM_HREFID = "hrefId";
    private ExtensionAntiCSRF extension = null;

    public AntiCsrfAPI(ExtensionAntiCSRF ext) {
        this.extension = ext;
        this.addApiOthers(new ApiOther(OTHER_GENERATE_FORM, new String[]{OTHER_GENERATE_FORM_PARAM_HREFID}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    public static String getAntiCsrfFormUrl(int hrefid) {
        return API.getInstance().getBaseURL(API.Format.OTHER, PREFIX, API.RequestType.other, OTHER_GENERATE_FORM, false) + OTHER_GENERATE_FORM_PARAM_HREFID + "=" + hrefid;
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage msg, String name, JSONObject params) throws ApiException {
        if (OTHER_GENERATE_FORM.equals(name)) {
            String hrefIdStr = params.getString(OTHER_GENERATE_FORM_PARAM_HREFID);
            if (hrefIdStr == null || hrefIdStr.length() == 0) {
                throw new ApiException(ApiException.Type.MISSING_PARAMETER, OTHER_GENERATE_FORM_PARAM_HREFID);
            }
            try {
                int hrefId = Integer.parseInt(hrefIdStr);
                String response = this.extension.generateForm(hrefId);
                if (response == null) {
                    throw new ApiException(ApiException.Type.HREF_NOT_FOUND, hrefIdStr);
                }
                ExtensionHistory extHist = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
                String charset = extHist.getHistoryReference(hrefId).getHttpMessage().getResponseHeader().getCharset();
                charset = charset == null || charset.length() == 0 ? "" : " charset=" + charset;
                msg.setResponseHeader(API.getDefaultResponseHeader("text/html; " + charset, response.length()));
                msg.setResponseBody(response);
            }
            catch (NumberFormatException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, OTHER_GENERATE_FORM_PARAM_HREFID);
            }
            catch (ApiException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        } else {
            throw new ApiException(ApiException.Type.BAD_OTHER, name);
        }
        return msg;
    }
}

