/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class AlertParam
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(AlertParam.class);
    private static final String PARAM_BASE_KEY = "alert";
    private static final String PARAM_MERGE_RELATED_ISSUES = "alert.mergeissues";
    private static final String PARAM_MAXIMUM_INSTANCES = "alert.maxInstances";
    private static final String PARAM_OVERRIDES_FILENAME = "alert.overridesFilename";
    private static final int DEFAULT_MAXIMUM_INSTANCES = 20;
    private int maximumInstances = 20;
    private boolean mergeRelatedIssues = true;
    private String overridesFilename;

    @Override
    protected void parse() {
        try {
            this.maximumInstances = this.getConfig().getInt(PARAM_MAXIMUM_INSTANCES, 20);
        }
        catch (ConversionException e) {
            LOGGER.error((Object)("Failed to load the \"Maximum instances\" configuration: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.mergeRelatedIssues = this.getConfig().getBoolean(PARAM_MERGE_RELATED_ISSUES, true);
        }
        catch (ConversionException e) {
            LOGGER.error((Object)("Failed to load the \"old format\" configuration: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.overridesFilename = this.getConfig().getString(PARAM_OVERRIDES_FILENAME, "");
        }
        catch (ConversionException e) {
            LOGGER.error((Object)("Failed to load the \"Overrides filename\" configuration: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setMaximumInstances(int maximumInstances) {
        if (this.maximumInstances != maximumInstances) {
            this.maximumInstances = maximumInstances;
            this.getConfig().setProperty(PARAM_MAXIMUM_INSTANCES, (Object)maximumInstances);
        }
    }

    public int getMaximumInstances() {
        return this.maximumInstances;
    }

    public boolean isMergeRelatedIssues() {
        return this.mergeRelatedIssues;
    }

    public void setMergeRelatedIssues(boolean mergeRelatedIssues) {
        if (this.mergeRelatedIssues != mergeRelatedIssues) {
            this.mergeRelatedIssues = mergeRelatedIssues;
            this.getConfig().setProperty(PARAM_MERGE_RELATED_ISSUES, (Object)mergeRelatedIssues);
        }
    }

    public String getOverridesFilename() {
        return this.overridesFilename;
    }

    public void setOverridesFilename(String overridesFilename) {
        this.overridesFilename = overridesFilename;
        this.getConfig().setProperty(PARAM_OVERRIDES_FILENAME, (Object)overridesFilename);
    }
}

