/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.control.AddOnInstaller;
import org.zaproxy.zap.control.AddOnLoaderUtils;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class AddOnLoader
extends URLClassLoader {
    public static final String ADDONS_BLOCK_LIST = "addons.block";
    private static final String ADDONS_RUNNABLE_BASE_KEY = "runnableAddOns";
    private static final String ADDONS_RUNNABLE_KEY = "runnableAddOns.addon";
    private static final String ADDON_RUNNABLE_ID_KEY = "id";
    private static final String ADDON_RUNNABLE_VERSION_KEY = "version";
    private static final String ADDON_RUNNABLE_ALL_EXTENSIONS_KEY = "extensions.extension";
    private static final AddOnUninstallationProgressCallback NULL_CALLBACK = new NullUninstallationProgressCallBack();
    private static final Logger logger = Logger.getLogger(AddOnLoader.class);
    private AddOnCollection aoc = null;
    private List<File> jars = new ArrayList<File>();
    private List<String> blockList = new ArrayList<String>();
    private Map<AddOn, List<String>> runnableAddOns;
    private List<String> idsAddOnsWithRunningIssuesSinceLastRun;
    private Map<String, AddOnClassLoader> addOnLoaders = new HashMap<String, AddOnClassLoader>();

    public AddOnLoader(File[] dirs) {
        super(new URL[0], AddOnLoader.class.getClassLoader());
        this.loadBlockList();
        this.aoc = new AddOnCollection(dirs);
        this.loadAllAddOns();
        if (dirs != null) {
            for (File dir : dirs) {
                try {
                    this.addDirectory(dir);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        for (File file : this.jars) {
            try {
                this.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (Map.Entry entry : this.addOnLoaders.entrySet()) {
            AddOnInstaller.installMissingAddOnFiles((AddOnClassLoader)entry.getValue(), this.getAddOnCollection().getAddOn((String)entry.getKey()));
        }
    }

    public List<String> getIdsAddOnsWithRunningIssuesSinceLastRun() {
        return Collections.unmodifiableList(this.idsAddOnsWithRunningIssuesSinceLastRun);
    }

    private void loadAllAddOns() {
        this.runnableAddOns = new HashMap<AddOn, List<String>>();
        this.idsAddOnsWithRunningIssuesSinceLastRun = new ArrayList<String>();
        Map<AddOn, List<String>> oldRunnableAddOns = AddOnLoader.loadAddOnsRunState(this.aoc);
        ArrayList<AddOn> runAddons = new ArrayList<AddOn>();
        Iterator<AddOn> iterator = this.aoc.getAddOns().iterator();
        while (iterator.hasNext()) {
            AddOn addOn = iterator.next();
            if (this.canLoadAddOn(addOn)) {
                AddOn.AddOnRunRequirements reqs = AddOnLoader.calculateRunRequirements(addOn, this.aoc.getAddOns());
                if (reqs.isRunnable()) {
                    List<Object> runnableExtensions;
                    if (addOn.hasExtensionsWithDeps()) {
                        runnableExtensions = AddOnLoader.getRunnableExtensionsWithDeps(reqs);
                        List<String> oldRunnableExtensions = oldRunnableAddOns.get(addOn);
                        if (oldRunnableExtensions != null && !oldRunnableExtensions.isEmpty()) {
                            oldRunnableExtensions.removeAll(runnableExtensions);
                            if (!oldRunnableExtensions.isEmpty()) {
                                this.idsAddOnsWithRunningIssuesSinceLastRun.add(addOn.getId());
                            }
                        }
                    } else {
                        runnableExtensions = Collections.emptyList();
                    }
                    this.runnableAddOns.put(addOn, runnableExtensions);
                    runAddons.add(addOn);
                    continue;
                }
                if (oldRunnableAddOns.get(addOn) == null) continue;
                this.idsAddOnsWithRunningIssuesSinceLastRun.add(addOn.getId());
                continue;
            }
            iterator.remove();
        }
        AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        for (AddOn addOn : runAddons) {
            addOn.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
            this.createAndAddAddOnClassLoader(addOn);
        }
    }

    private static List<String> getRunnableExtensionsWithDeps(AddOn.AddOnRunRequirements runRequirements) {
        ArrayList<String> runnableExtensions = new ArrayList<String>();
        for (AddOn.ExtensionRunRequirements extReqs : runRequirements.getExtensionRequirements()) {
            if (!extReqs.isRunnable()) continue;
            runnableExtensions.add(extReqs.getClassname());
        }
        return runnableExtensions;
    }

    private boolean canLoadAddOn(AddOn ao) {
        if (this.blockList.contains(ao.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Can't load add-on " + ao.getName() + " it's on the block list (add-on uninstalled but the file couldn't be removed)."));
            }
            return false;
        }
        if (!ao.canLoadInCurrentVersion()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Can't load add-on " + ao.getName() + " because of ZAP version constraints; Not before=" + ao.getNotBeforeVersion() + " Not from=" + ao.getNotFromVersion() + " Current Version=" + Constant.PROGRAM_VERSION));
            }
            return false;
        }
        return true;
    }

    private static AddOn.AddOnRunRequirements calculateRunRequirements(AddOn ao, Collection<AddOn> availableAddOns) {
        AddOn.AddOnRunRequirements reqs = ao.calculateRunRequirements(availableAddOns);
        if (!reqs.isRunnable() && logger.isDebugEnabled()) {
            logger.debug((Object)("Can't run add-on " + ao.getName() + " because of missing requirements: " + AddOnRunIssuesUtils.getRunningIssues(reqs)));
        }
        return reqs;
    }

    private AddOnClassLoader createAndAddAddOnClassLoader(AddOn ao) {
        try {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(ao.getId());
            if (addOnClassLoader != null) {
                return addOnClassLoader;
            }
            List<String> idsAddOnDependencies = ao.getIdsAddOnDependencies();
            if (idsAddOnDependencies.isEmpty()) {
                addOnClassLoader = new AddOnClassLoader(ao.getFile().toURI().toURL(), (ClassLoader)this, ao.getAddOnClassnames());
                this.addOnLoaders.put(ao.getId(), addOnClassLoader);
                return addOnClassLoader;
            }
            ArrayList<AddOnClassLoader> dependencies = new ArrayList<AddOnClassLoader>(idsAddOnDependencies.size());
            for (String addOnId : idsAddOnDependencies) {
                addOnClassLoader = this.addOnLoaders.get(addOnId);
                if (addOnClassLoader == null) {
                    addOnClassLoader = this.createAndAddAddOnClassLoader(this.aoc.getAddOn(addOnId));
                }
                dependencies.add(addOnClassLoader);
            }
            addOnClassLoader = new AddOnClassLoader(ao.getFile().toURI().toURL(), this, dependencies, ao.getAddOnClassnames());
            this.addOnLoaders.put(ao.getId(), addOnClassLoader);
            return addOnClassLoader;
        }
        catch (MalformedURLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to convert URL for AddOnClassLoader " + ao.getFile().toURI(), e);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (AddOnClassLoader loader : this.addOnLoaders.values()) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        for (AddOnClassLoader loader : this.addOnLoaders.values()) {
            url = loader.findResourceInAddOn(name);
            if (url == null) continue;
            return url;
        }
        return url;
    }

    public AddOnCollection getAddOnCollection() {
        return this.aoc;
    }

    private void addDirectory(File dir) {
        if (dir == null) {
            logger.error((Object)"Null directory supplied");
            return;
        }
        if (!dir.exists()) {
            logger.error((Object)("No such directory: " + dir.getAbsolutePath()));
            return;
        }
        if (!dir.isDirectory()) {
            logger.error((Object)("Not a directory: " + dir.getAbsolutePath()));
            return;
        }
        File[] listJars = dir.listFiles(new JarFilenameFilter());
        if (listJars != null) {
            for (File jar : listJars) {
                this.jars.add(jar);
            }
        }
    }

    public synchronized void addAddon(AddOn ao) {
        if (!ao.canLoadInCurrentVersion()) {
            throw new IllegalArgumentException("Cant load add-on " + ao.getName() + " Not before=" + ao.getNotBeforeVersion() + " Not from=" + ao.getNotFromVersion() + " Version=" + Constant.PROGRAM_VERSION);
        }
        if (!this.aoc.addAddOn(ao)) {
            return;
        }
        this.addAddOnImpl(ao);
    }

    private void addAddOnImpl(AddOn ao) {
        if (AddOn.InstallationStatus.INSTALLED == ao.getInstallationStatus()) {
            return;
        }
        if (this.blockList.contains(ao.getId())) {
            this.blockList.remove(ao.getId());
            this.saveBlockList();
        }
        if (!AddOnLoader.isDynamicallyInstallable(ao)) {
            return;
        }
        AddOn.AddOnRunRequirements reqs = AddOnLoader.calculateRunRequirements(ao, this.aoc.getInstalledAddOns());
        if (!reqs.isRunnable()) {
            ao.setInstallationStatus(AddOn.InstallationStatus.NOT_INSTALLED);
            return;
        }
        AddOnInstaller.install(this.createAndAddAddOnClassLoader(ao), ao);
        ao.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
        Control.getSingleton().getExtensionLoader().addOnInstalled(ao);
        if (this.runnableAddOns.get(ao) == null) {
            this.runnableAddOns.put(ao, AddOnLoader.getRunnableExtensionsWithDeps(reqs));
            AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        }
        this.checkAndLoadDependentExtensions();
        this.checkAndInstallAddOnsNotInstalled();
        if (View.isInitialised()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().refreshTabViewMenus();
                }
            });
        }
    }

    private void checkAndInstallAddOnsNotInstalled() {
        ArrayList<AddOn> runnableAddOns = new ArrayList<AddOn>();
        for (AddOn addOn : this.aoc.getAddOns()) {
            AddOn.AddOnRunRequirements reqs;
            if (AddOn.InstallationStatus.NOT_INSTALLED != addOn.getInstallationStatus() || this.addOnLoaders.get(addOn.getId()) != null || !(reqs = addOn.calculateRunRequirements(this.aoc.getInstalledAddOns())).isRunnable()) continue;
            runnableAddOns.add(addOn);
        }
        for (AddOn addOn : runnableAddOns) {
            this.addAddOnImpl(addOn);
        }
    }

    private void checkAndLoadDependentExtensions() {
        boolean changed = false;
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn runningAddOn = this.aoc.getAddOn(entry.getKey());
            for (String extClassName : runningAddOn.getExtensionsWithDeps()) {
                AddOn.AddOnRunRequirements reqs;
                AddOn.ExtensionRunRequirements extReqs;
                if (runningAddOn.isExtensionLoaded(extClassName) || !(extReqs = (reqs = runningAddOn.calculateExtensionRunRequirements(extClassName, this.aoc.getInstalledAddOns())).getExtensionRequirements().get(0)).isRunnable()) continue;
                ArrayList<AddOnClassLoader> dependencies = new ArrayList<AddOnClassLoader>(extReqs.getDependencies().size());
                for (AddOn addOnDep : extReqs.getDependencies()) {
                    dependencies.add(this.addOnLoaders.get(addOnDep.getId()));
                }
                AddOnClassLoader extAddOnClassLoader = new AddOnClassLoader(entry.getValue(), dependencies, runningAddOn.getExtensionAddOnClassnames(extClassName));
                Extension ext = AddOnLoader.loadAddOnExtension(runningAddOn, extReqs.getClassname(), extAddOnClassLoader);
                AddOnInstaller.installAddOnExtension(runningAddOn, ext);
                this.runnableAddOns.get(runningAddOn).add(extReqs.getClassname());
                changed = true;
            }
        }
        if (changed) {
            AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        }
    }

    private static boolean isDynamicallyInstallable(AddOn addOn) {
        return addOn.hasZapAddOnEntry();
    }

    public synchronized boolean removeAddOn(AddOn ao, boolean upgrading, AddOnUninstallationProgressCallback progressCallback) {
        AddOnUninstallationProgressCallback callback = progressCallback == null ? NULL_CALLBACK : progressCallback;
        callback.uninstallingAddOn(ao, upgrading);
        boolean removed = this.removeAddOnImpl(ao, upgrading, callback);
        callback.addOnUninstalled(removed);
        return removed;
    }

    private boolean removeAddOnImpl(AddOn ao, boolean upgrading, AddOnUninstallationProgressCallback callback) {
        if (!AddOnLoader.isDynamicallyInstallable(ao)) {
            return false;
        }
        if (AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == ao.getInstallationStatus()) {
            if (this.runnableAddOns.remove(ao) != null) {
                AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
            }
            AddOnInstaller.uninstallAddOnFiles(ao, NULL_CALLBACK);
            this.removeAddOnClassLoader(ao);
            this.deleteAddOnFile(ao, upgrading);
            ao.setInstallationStatus(AddOn.InstallationStatus.UNINSTALLATION_FAILED);
            Control.getSingleton().getExtensionLoader().addOnUninstalled(ao, false);
            return false;
        }
        if (!this.aoc.includesAddOn(ao.getId())) {
            logger.warn((Object)("Trying to uninstall an add-on that is not installed: " + ao.getId()));
            return false;
        }
        if (AddOn.InstallationStatus.NOT_INSTALLED == ao.getInstallationStatus()) {
            if (this.runnableAddOns.remove(ao) != null) {
                AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
            }
            this.deleteAddOnFile(ao, upgrading);
            return this.aoc.removeAddOn(ao);
        }
        this.unloadDependentExtensions(ao);
        this.softUninstallDependentAddOns(ao);
        boolean uninstalledWithoutErrors = AddOnInstaller.uninstall(ao, callback);
        if (uninstalledWithoutErrors && !this.aoc.removeAddOn(ao)) {
            uninstalledWithoutErrors = false;
        }
        if (uninstalledWithoutErrors) {
            this.removeAddOnClassLoader(ao);
        }
        this.deleteAddOnFile(ao, upgrading);
        if (this.runnableAddOns.remove(ao) != null) {
            AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        }
        ao.setInstallationStatus(uninstalledWithoutErrors ? AddOn.InstallationStatus.AVAILABLE : AddOn.InstallationStatus.UNINSTALLATION_FAILED);
        Control.getSingleton().getExtensionLoader().addOnUninstalled(ao, uninstalledWithoutErrors);
        return uninstalledWithoutErrors;
    }

    private void deleteAddOnFile(AddOn addOn, boolean upgrading) {
        if (addOn.getFile() != null && addOn.getFile().exists() && !addOn.getFile().delete() && !upgrading) {
            logger.debug((Object)("Cant delete " + addOn.getFile().getAbsolutePath()));
            this.blockList.add(addOn.getId());
            this.saveBlockList();
        }
    }

    private void removeAddOnClassLoader(AddOn addOn) {
        if (this.addOnLoaders.containsKey(addOn.getId())) {
            try (AddOnClassLoader addOnClassLoader = this.addOnLoaders.remove(addOn.getId());){
                if (!addOn.getIdsAddOnDependencies().isEmpty()) {
                    addOnClassLoader.clearDependencies();
                }
                ResourceBundle.clearCache(addOnClassLoader);
            }
            catch (Exception e) {
                logger.error((Object)("Failure while closing class loader of " + addOn.getId() + " add-on:"), (Throwable)e);
            }
        }
    }

    private void unloadDependentExtensions(AddOn ao) {
        boolean changed = true;
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn runningAddOn = this.aoc.getAddOn(entry.getKey());
            for (Extension ext : runningAddOn.getLoadedExtensionsWithDeps()) {
                if (!runningAddOn.dependsOn(ext, ao)) continue;
                String classname = ext.getClass().getCanonicalName();
                AddOnInstaller.uninstallAddOnExtension(runningAddOn, ext, NULL_CALLBACK);
                try (AddOnClassLoader extensionClassLoader = (AddOnClassLoader)ext.getClass().getClassLoader();){
                    ext = null;
                    entry.getValue().removeChildClassLoader(extensionClassLoader);
                    extensionClassLoader.clearDependencies();
                    ResourceBundle.clearCache(extensionClassLoader);
                }
                catch (Exception e) {
                    logger.error((Object)("Failure while closing class loader of extension '" + classname + "':"), (Throwable)e);
                }
                this.runnableAddOns.get(runningAddOn).remove(classname);
                changed = true;
            }
        }
        if (changed) {
            AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        }
    }

    private void softUninstallDependentAddOns(AddOn ao) {
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn runningAddOn = this.aoc.getAddOn(entry.getKey());
            if (!runningAddOn.dependsOn(ao)) continue;
            this.softUninstallDependentAddOns(runningAddOn);
            this.softUninstall(runningAddOn);
        }
    }

    private void softUninstall(AddOn addOn) {
        AddOn.InstallationStatus status;
        if (AddOn.InstallationStatus.INSTALLED != addOn.getInstallationStatus()) {
            return;
        }
        if (AddOnLoader.isDynamicallyInstallable(addOn) && AddOnInstaller.softUninstall(addOn, NULL_CALLBACK)) {
            this.removeAddOnClassLoader(addOn);
            status = AddOn.InstallationStatus.NOT_INSTALLED;
        } else {
            status = AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED;
        }
        addOn.setInstallationStatus(status);
        Control.getSingleton().getExtensionLoader().addOnSoftUninstalled(addOn, status == AddOn.InstallationStatus.NOT_INSTALLED);
    }

    private void loadBlockList() {
        this.blockList = AddOnLoader.loadList(ADDONS_BLOCK_LIST);
    }

    private void saveBlockList() {
        AddOnLoader.saveList(ADDONS_BLOCK_LIST, this.blockList);
    }

    private <T> List<ClassNameWrapper> getClassNames(String packageName, Class<T> classType) {
        ArrayList<ClassNameWrapper> listClassName = new ArrayList<ClassNameWrapper>();
        listClassName.addAll(this.getLocalClassNames(packageName));
        for (String addOnId : this.addOnLoaders.keySet()) {
            listClassName.addAll(this.getJarClassNames(this.aoc.getAddOn(addOnId), packageName));
        }
        for (File jar : this.jars) {
            listClassName.addAll(this.getJarClassNames(this.getClass().getClassLoader(), jar, packageName));
        }
        return listClassName;
    }

    public List<Extension> getExtensions() {
        ArrayList<Extension> list = new ArrayList<Extension>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            list.addAll(this.getExtensions(addOn));
        }
        return list;
    }

    public List<Extension> getExtensions(AddOn addOn) {
        AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
        if (addOnClassLoader == null) {
            return Collections.emptyList();
        }
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        extensions.addAll(this.loadAddOnExtensions(addOn, addOn.getExtensions(), addOnClassLoader));
        if (addOn.hasExtensionsWithDeps()) {
            AddOn.AddOnRunRequirements reqs = addOn.calculateRunRequirements(this.aoc.getInstalledAddOns());
            for (AddOn.ExtensionRunRequirements extReqs : reqs.getExtensionRequirements()) {
                if (extReqs.isRunnable()) {
                    ArrayList<AddOnClassLoader> dependencies = new ArrayList<AddOnClassLoader>(extReqs.getDependencies().size());
                    for (AddOn addOnDep : extReqs.getDependencies()) {
                        dependencies.add(this.addOnLoaders.get(addOnDep.getId()));
                    }
                    AddOnClassLoader extAddOnClassLoader = new AddOnClassLoader(addOnClassLoader, dependencies, addOn.getExtensionAddOnClassnames(extReqs.getClassname()));
                    Extension ext = AddOnLoader.loadAddOnExtension(addOn, extReqs.getClassname(), extAddOnClassLoader);
                    if (ext == null) continue;
                    extensions.add(ext);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Can't run extension '" + extReqs.getClassname() + "' of add-on '" + addOn.getName() + "' because of missing requirements: " + AddOnRunIssuesUtils.getRunningIssues(extReqs)));
            }
        }
        return extensions;
    }

    private List<Extension> loadAddOnExtensions(AddOn addOn, List<String> extensions, AddOnClassLoader addOnClassLoader) {
        if (extensions == null || extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Extension> list = new ArrayList<Extension>(extensions.size());
        for (String extName : extensions) {
            Extension ext = AddOnLoader.loadAddOnExtension(addOn, extName, addOnClassLoader);
            if (ext == null) continue;
            list.add(ext);
        }
        return list;
    }

    private static Extension loadAddOnExtension(AddOn addOn, String classname, AddOnClassLoader addOnClassLoader) {
        Extension extension = AddOnLoaderUtils.loadAndInstantiateClass(addOnClassLoader, classname, Extension.class, "extension");
        if (extension != null) {
            addOn.addLoadedExtension(extension);
        }
        return extension;
    }

    public List<AbstractPlugin> getActiveScanRules() {
        ArrayList<AbstractPlugin> list = new ArrayList<AbstractPlugin>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
            if (addOnClassLoader == null) continue;
            list.addAll(AddOnLoaderUtils.getActiveScanRules(addOn, addOnClassLoader));
        }
        list.trimToSize();
        return Collections.unmodifiableList(list);
    }

    public List<PluginPassiveScanner> getPassiveScanRules() {
        ArrayList<PluginPassiveScanner> list = new ArrayList<PluginPassiveScanner>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
            if (addOnClassLoader == null) continue;
            list.addAll(AddOnLoaderUtils.getPassiveScanRules(addOn, addOnClassLoader));
        }
        list.trimToSize();
        return Collections.unmodifiableList(list);
    }

    public <T> List<T> getImplementors(String packageName, Class<T> classType) {
        return this.getImplementors(null, packageName, classType);
    }

    public <T> List<T> getImplementors(AddOn ao, String packageName, Class<T> classType) {
        Class<?> cls = null;
        ArrayList listClass = new ArrayList();
        List<ClassNameWrapper> classNames = ao != null ? this.getJarClassNames(ao, packageName) : this.getClassNames(packageName, classType);
        for (ClassNameWrapper classWrapper : classNames) {
            try {
                cls = classWrapper.getCl().loadClass(classWrapper.getClassName());
                if (Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers()) || !classType.isAssignableFrom(cls)) continue;
                Constructor<?> c = cls.getConstructor(new Class[0]);
                listClass.add(c.newInstance(new Object[0]));
            }
            catch (Throwable e) {
                logger.debug((Object)e.getMessage(), e);
            }
        }
        return listClass;
    }

    private List<ClassNameWrapper> getLocalClassNames(String packageName) {
        if (packageName == null || packageName.equals("")) {
            return Collections.emptyList();
        }
        String folder = packageName.replace('.', '/');
        URL local = AddOnLoader.class.getClassLoader().getResource(folder);
        if (local == null) {
            return Collections.emptyList();
        }
        String jarFile = null;
        if (local.getProtocol().equals("jar")) {
            jarFile = local.toString().substring("jar:".length());
            int pos = jarFile.indexOf("!");
            jarFile = jarFile.substring(0, pos);
            try {
                return this.getJarClassNames(this.getClass().getClassLoader(), new File(new URI(jarFile)), packageName);
            }
            catch (URISyntaxException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                return this.parseClassDir(this.getClass().getClassLoader(), new File(new URI(local.toString())), packageName.replace('.', File.separatorChar), new ClassRecurseDirFileFilter(true));
            }
            catch (URISyntaxException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private List<ClassNameWrapper> parseClassDir(ClassLoader cl, File file, String packageName, FileFilter fileFilter) {
        ArrayList<ClassNameWrapper> classNames = new ArrayList<ClassNameWrapper>();
        File[] listFile = file.listFiles(fileFilter);
        for (int i = 0; i < listFile.length; ++i) {
            File entry = listFile[i];
            if (entry.isDirectory()) {
                classNames.addAll(this.parseClassDir(cl, entry, packageName, fileFilter));
                continue;
            }
            String fileName = entry.toString();
            int pos = fileName.indexOf(packageName);
            if (pos <= 0) continue;
            String className = fileName.substring(pos).replaceAll("\\.class$", "").replace(File.separatorChar, '.');
            classNames.add(new ClassNameWrapper(cl, className));
        }
        return classNames;
    }

    private List<ClassNameWrapper> getJarClassNames(ClassLoader cl, File file, String packageName) {
        ArrayList<ClassNameWrapper> classNames = new ArrayList<ClassNameWrapper>();
        ZipEntry entry = null;
        String className = "";
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class") || (className = entry.toString().replaceAll("\\.class$", "").replaceAll("/", ".")).indexOf(packageName) < 0) continue;
                classNames.add(new ClassNameWrapper(cl, className));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to open file: " + file.getAbsolutePath()), (Throwable)e);
        }
        return classNames;
    }

    private List<ClassNameWrapper> getJarClassNames(AddOn ao, String packageName) {
        ArrayList<ClassNameWrapper> classNames = new ArrayList<ClassNameWrapper>();
        ZipEntry entry = null;
        String className = "";
        try (JarFile jarFile = new JarFile(ao.getFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class") || (className = entry.toString().replaceAll("\\.class$", "").replaceAll("/", ".")).indexOf(packageName) < 0) continue;
                classNames.add(new ClassNameWrapper(this.addOnLoaders.get(ao.getId()), className));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to open file: " + ao.getFile().getAbsolutePath()), (Throwable)e);
        }
        return classNames;
    }

    private static List<String> loadList(String key) {
        ArrayList<String> data = new ArrayList<String>();
        String blockStr = Model.getSingleton().getOptionsParam().getConfig().getString(key, null);
        if (blockStr != null && blockStr.length() > 0) {
            for (String str : blockStr.split(",")) {
                data.add(str);
            }
        }
        return data;
    }

    private static void saveList(String key, List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String id : list) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(id);
        }
        Model.getSingleton().getOptionsParam().getConfig().setProperty(key, (Object)sb.toString());
        try {
            Model.getSingleton().getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException e) {
            logger.error((Object)("Failed to save list [" + key + "]: " + sb.toString()), (Throwable)e);
        }
    }

    private static Map<AddOn, List<String>> loadAddOnsRunState(AddOnCollection addOnCollection) {
        List savedAddOns = ((HierarchicalConfiguration)Model.getSingleton().getOptionsParam().getConfig()).configurationsAt(ADDONS_RUNNABLE_KEY);
        HashMap<AddOn, List<String>> runnableAddOns = new HashMap<AddOn, List<String>>();
        for (HierarchicalConfiguration savedAddOn : savedAddOns) {
            int version;
            AddOn addOn = addOnCollection.getAddOn(savedAddOn.getString(ADDON_RUNNABLE_ID_KEY, ""));
            if (addOn == null || (version = savedAddOn.getInt(ADDON_RUNNABLE_VERSION_KEY, -1)) == -1 || addOn.getFileVersion() != version) continue;
            ArrayList<String> runnableExtensions = new ArrayList<String>();
            List<String> currentExtensions = addOn.getExtensionsWithDeps();
            for (String savedExtension : savedAddOn.getStringArray(ADDON_RUNNABLE_ALL_EXTENSIONS_KEY)) {
                if (!currentExtensions.contains(savedExtension)) continue;
                runnableExtensions.add(savedExtension);
            }
            runnableAddOns.put(addOn, runnableExtensions);
        }
        return runnableAddOns;
    }

    private static void saveAddOnsRunState(Map<AddOn, List<String>> runnableAddOns) {
        HierarchicalConfiguration config = (HierarchicalConfiguration)Model.getSingleton().getOptionsParam().getConfig();
        config.clearTree(ADDONS_RUNNABLE_BASE_KEY);
        int i = 0;
        for (Map.Entry<AddOn, List<String>> runnableAddOnEntry : runnableAddOns.entrySet()) {
            String elementBaseKey = "runnableAddOns.addon(" + i + ").";
            AddOn addOn = runnableAddOnEntry.getKey();
            config.setProperty(elementBaseKey + ADDON_RUNNABLE_ID_KEY, (Object)addOn.getId());
            config.setProperty(elementBaseKey + ADDON_RUNNABLE_VERSION_KEY, (Object)addOn.getFileVersion());
            String extensionBaseKey = elementBaseKey + ADDON_RUNNABLE_ALL_EXTENSIONS_KEY;
            for (String extension : runnableAddOnEntry.getValue()) {
                config.addProperty(extensionBaseKey, (Object)extension);
            }
            ++i;
        }
        try {
            Model.getSingleton().getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException e) {
            logger.error((Object)"Failed to save state of runnable add-ons:", (Throwable)e);
        }
    }

    private static class NullUninstallationProgressCallBack
    implements AddOnUninstallationProgressCallback {
        private NullUninstallationProgressCallBack() {
        }

        @Override
        public void uninstallingAddOn(AddOn addOn, boolean updating) {
        }

        @Override
        public void activeScanRulesWillBeRemoved(int numberOfRules) {
        }

        @Override
        public void activeScanRuleRemoved(String name) {
        }

        @Override
        public void passiveScanRulesWillBeRemoved(int numberOfRules) {
        }

        @Override
        public void passiveScanRuleRemoved(String name) {
        }

        @Override
        public void filesWillBeRemoved(int numberOfFiles) {
        }

        @Override
        public void fileRemoved() {
        }

        @Override
        public void extensionsWillBeRemoved(int numberOfExtensions) {
        }

        @Override
        public void extensionRemoved(String name) {
        }

        @Override
        public void addOnUninstalled(boolean uninstalled) {
        }
    }

    private class ClassNameWrapper {
        private ClassLoader cl;
        private String className;

        public ClassNameWrapper(ClassLoader cl, String className) {
            this.cl = cl;
            this.className = className;
        }

        public ClassLoader getCl() {
            return this.cl;
        }

        public String getClassName() {
            return this.className;
        }
    }

    private static final class ClassRecurseDirFileFilter
    implements FileFilter {
        private boolean recurse;

        public ClassRecurseDirFileFilter(boolean recurse) {
            this.recurse = recurse;
        }

        @Override
        public boolean accept(File file) {
            if (this.recurse && file.isDirectory() && !file.getName().startsWith(".")) {
                return true;
            }
            return file.isFile() && file.getName().endsWith(".class");
        }
    }

    private static final class JarFilenameFilter
    implements FilenameFilter {
        private JarFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String fileName) {
            return fileName.endsWith(".jar");
        }
    }
}

