/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import ch.csnc.extension.httpclient.SSLContextManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.DecoratedSocketsSslSocketFactory;
import org.parosproxy.paros.network.RelaxedX509TrustManager;
import org.parosproxy.paros.security.CachedSslCertifificateServiceImpl;
import org.parosproxy.paros.security.SslCertificateService;

public class SSLConnector
implements SecureProtocolSocketFactory {
    private static final String SSL = "SSL";
    private static final String CONTENTS_UNRECOGNIZED_NAME_EXCEPTION = "unrecognized_name";
    public static final String SECURITY_PROTOCOL_SSL_V2_HELLO = "SSLv2Hello";
    public static final String SECURITY_PROTOCOL_SSL_V3 = "SSLv3";
    public static final String SECURITY_PROTOCOL_TLS_V1 = "TLSv1";
    public static final String SECURITY_PROTOCOL_TLS_V1_1 = "TLSv1.1";
    public static final String SECURITY_PROTOCOL_TLS_V1_2 = "TLSv1.2";
    private static final String[] DEFAULT_ENABLED_PROTOCOLS = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private static final String[] FAIL_SAFE_DEFAULT_ENABLED_PROTOCOLS = new String[]{"TLSv1"};
    private SSLSocketFactory clientSSLSockFactory = null;
    private SSLSocketFactory clientSSLSockCertFactory = null;
    private static String[] supportedProtocols;
    private static String[] clientEnabledProtocols;
    private static String[] serverEnabledProtocols;
    private static ServerSslSocketsDecorator serverSslSocketsDecorator;
    private ClientSslSocketsDecorator clientSslSocketsDecorator;
    private static long MAX_AGE_MISCONFIGURED_HOST_IN_MIN;
    private static long MAX_AGE_MISCONFIGURED_HOST_IN_MS;
    private static LRUMap misconfiguredHosts;
    private static long timeStampLastStaleCheck;
    private static final Logger logger;
    private static SSLContextManager sslContextManager;
    private boolean relaxedTrust = true;

    public SSLConnector() {
        this(true);
    }

    public SSLConnector(boolean relaxedTrust) {
        this.relaxedTrust = relaxedTrust;
        if (this.clientSSLSockFactory == null) {
            serverSslSocketsDecorator = new ServerSslSocketsDecorator();
            this.clientSslSocketsDecorator = new ClientSslSocketsDecorator();
            this.clientSSLSockFactory = this.getClientSocketFactory(SSL);
            misconfiguredHosts = new LRUMap(10);
        }
        if (sslContextManager == null) {
            sslContextManager = new SSLContextManager();
        }
    }

    public SSLContextManager getSSLContextManager() {
        return sslContextManager;
    }

    public void setEnableClientCert(boolean enabled) {
        if (enabled) {
            this.clientSSLSockFactory = this.clientSSLSockCertFactory;
            logger.info((Object)("ClientCert enabled using: " + sslContextManager.getDefaultKey()));
        } else {
            this.clientSSLSockFactory = this.getClientSocketFactory(SSL);
            logger.info((Object)"ClientCert disabled");
        }
    }

    public void setActiveCertificate() {
        SSLContext sslcont = sslContextManager.getSSLContext(sslContextManager.getDefaultKey());
        this.clientSSLSockCertFactory = this.createDecoratedClientSslSocketFactory(sslcont.getSocketFactory());
        logger.info((Object)("ActiveCertificate set to: " + sslContextManager.getDefaultKey()));
    }

    public ServerSocket listen(int paramPortNum, int maxConnection, InetAddress ip) throws IOException {
        throw new UnsupportedOperationException("this code is probably not needed any more, SSL server sockets are not \"static\", they're created on the fly");
    }

    public SSLSocketFactory getClientSocketFactory(String type) {
        TrustManager[] trustMgr = new TrustManager[]{new RelaxedX509TrustManager()};
        try {
            SSLContext sslContext = SSLContext.getInstance(type);
            SecureRandom x = new SecureRandom();
            x.setSeed(System.currentTimeMillis());
            if (this.relaxedTrust) {
                sslContext.init(null, trustMgr, x);
            } else {
                sslContext.init(null, null, x);
            }
            this.clientSSLSockFactory = this.createDecoratedClientSslSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultSSLSocketFactory(this.clientSSLSockFactory);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.clientSSLSockFactory;
    }

    @Deprecated
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        throw new UnsupportedOperationException("Method no longer supported since it's no longer required/called by Commons HttpClient library (version >= 3.0).");
    }

    public static String[] getSupportedProtocols() {
        if (supportedProtocols == null) {
            SSLConnector.readSupportedProtocols(null);
        }
        return Arrays.copyOf(supportedProtocols, supportedProtocols.length);
    }

    private static synchronized void readSupportedProtocols(SSLSocket sslSocket) {
        if (supportedProtocols == null) {
            Object[] tempSupportedProtocols;
            logger.info((Object)"Reading supported SSL/TLS protocols...");
            if (sslSocket != null) {
                logger.info((Object)"Using an existing SSLSocket...");
                tempSupportedProtocols = sslSocket.getSupportedProtocols();
            } else {
                logger.info((Object)"Using a SSLEngine...");
                try {
                    SSLContext ctx = SSLContext.getInstance(SSL);
                    ctx.init(null, null, null);
                    try {
                        tempSupportedProtocols = ctx.createSSLEngine().getSupportedProtocols();
                    }
                    catch (UnsupportedOperationException e) {
                        logger.warn((Object)"Failed to use SSLEngine. Trying with unconnected socket...", (Throwable)e);
                        try (SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket();){
                            tempSupportedProtocols = socket.getSupportedProtocols();
                        }
                    }
                }
                catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
                    logger.error((Object)("Failed to read the SSL/TLS supported protocols. Using default protocol versions: " + Arrays.toString(FAIL_SAFE_DEFAULT_ENABLED_PROTOCOLS)), (Throwable)e);
                    tempSupportedProtocols = FAIL_SAFE_DEFAULT_ENABLED_PROTOCOLS;
                }
            }
            Arrays.sort(tempSupportedProtocols);
            supportedProtocols = tempSupportedProtocols;
            logger.info((Object)("Done reading supported SSL/TLS protocols: " + Arrays.toString(supportedProtocols)));
        }
    }

    public static String[] getClientEnabledProtocols() {
        if (clientEnabledProtocols == null) {
            SSLConnector.setClientEnabledProtocols(DEFAULT_ENABLED_PROTOCOLS);
        }
        return Arrays.copyOf(clientEnabledProtocols, clientEnabledProtocols.length);
    }

    public static void setClientEnabledProtocols(String[] protocols) {
        clientEnabledProtocols = SSLConnector.extractSupportedProtocols(protocols);
    }

    public static String[] getServerEnabledProtocols() {
        if (serverEnabledProtocols == null) {
            SSLConnector.setServerEnabledProtocols(DEFAULT_ENABLED_PROTOCOLS);
        }
        return Arrays.copyOf(serverEnabledProtocols, serverEnabledProtocols.length);
    }

    public static void setServerEnabledProtocols(String[] protocols) {
        serverEnabledProtocols = SSLConnector.extractSupportedProtocols(protocols);
    }

    private static String[] extractSupportedProtocols(String[] enabledProtocols) {
        if (enabledProtocols == null || enabledProtocols.length == 0) {
            throw new IllegalArgumentException("Protocol(s) required but no protocol set.");
        }
        Object[] supportedProtocols = SSLConnector.getSupportedProtocols();
        ArrayList<String> enabledSupportedProtocols = new ArrayList<String>(supportedProtocols.length);
        for (String protocol : enabledProtocols) {
            if (protocol == null || Arrays.binarySearch(supportedProtocols, protocol) < 0) continue;
            enabledSupportedProtocols.add(protocol);
        }
        enabledSupportedProtocols.trimToSize();
        if (enabledSupportedProtocols.isEmpty()) {
            throw new IllegalArgumentException("No supported protocol(s) set.");
        }
        String[] extractedSupportedProtocols = new String[enabledSupportedProtocols.size()];
        enabledSupportedProtocols.toArray(extractedSupportedProtocols);
        return extractedSupportedProtocols;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            InetAddress hostAddress = SSLConnector.getCachedMisconfiguredHost(host, port);
            if (hostAddress != null) {
                return this.clientSSLSockFactory.createSocket(hostAddress, port, localAddress, localPort);
            }
            try {
                SSLSocket sslSocket = (SSLSocket)this.clientSSLSockFactory.createSocket(host, port, localAddress, localPort);
                sslSocket.startHandshake();
                return sslSocket;
            }
            catch (SSLException e) {
                if (!e.getMessage().contains(CONTENTS_UNRECOGNIZED_NAME_EXCEPTION)) {
                    throw e;
                }
                hostAddress = InetAddress.getByName(host);
                SSLConnector.cacheMisconfiguredHost(host, port, hostAddress);
                return this.clientSSLSockFactory.createSocket(hostAddress, port, localAddress, localPort);
            }
        }
        Socket socket = this.clientSSLSockFactory.createSocket();
        InetSocketAddress localAddr = new InetSocketAddress(localAddress, localPort);
        socket.bind(localAddr);
        InetSocketAddress remoteAddr = new InetSocketAddress(host, port);
        socket.connect(remoteAddr, timeout);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheMisconfiguredHost(String host, int port, InetAddress address) {
        LRUMap lRUMap = misconfiguredHosts;
        synchronized (lRUMap) {
            if (!misconfiguredHosts.isEmpty()) {
                SSLConnector.removeStaleCachedMisconfiguredHosts();
            }
            logger.info((Object)("Caching address of misconfigured (\"unrecognized_name\") host [host=" + host + ", port=" + port + "] for the next " + MAX_AGE_MISCONFIGURED_HOST_IN_MIN + " minutes, following connections will not use the hostname."));
            misconfiguredHosts.put((Object)(host + port), (Object)new MisconfiguredHostCacheEntry(host, port, address));
        }
    }

    private static void removeStaleCachedMisconfiguredHosts() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - timeStampLastStaleCheck < MAX_AGE_MISCONFIGURED_HOST_IN_MS) {
            return;
        }
        timeStampLastStaleCheck = currentTime;
        MapIterator it = misconfiguredHosts.mapIterator();
        while (it.hasNext()) {
            it.next();
            MisconfiguredHostCacheEntry entry = (MisconfiguredHostCacheEntry)it.getValue();
            if (!entry.isStale(currentTime)) continue;
            logger.info((Object)("Removing stale cached address of misconfigured (\"unrecognized_name\") host [host=" + entry.getHost() + ", port=" + entry.getPort() + "], following connections will be attempted with the hostname."));
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getCachedMisconfiguredHost(String host, int port) {
        LRUMap lRUMap = misconfiguredHosts;
        synchronized (lRUMap) {
            if (misconfiguredHosts.isEmpty()) {
                return null;
            }
            SSLConnector.removeStaleCachedMisconfiguredHosts();
            MisconfiguredHostCacheEntry entry = (MisconfiguredHostCacheEntry)misconfiguredHosts.get((Object)(host + port));
            if (entry != null) {
                return entry.getAddress();
            }
            return null;
        }
    }

    @Deprecated
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        throw new UnsupportedOperationException("Method no longer supported since it's no longer required/called by Commons HttpClient library (version >= 3.0).");
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        InetAddress inetAddress = SSLConnector.getCachedMisconfiguredHost(host, port);
        if (inetAddress != null) {
            return this.clientSSLSockFactory.createSocket(socket, inetAddress.getHostAddress(), port, autoClose);
        }
        try {
            SSLSocket socketSSL = (SSLSocket)this.clientSSLSockFactory.createSocket(socket, host, port, autoClose);
            socketSSL.startHandshake();
            return socketSSL;
        }
        catch (SSLException e) {
            if (e.getMessage().contains(CONTENTS_UNRECOGNIZED_NAME_EXCEPTION)) {
                SSLConnector.cacheMisconfiguredHost(host, port, InetAddress.getByName(host));
            }
            throw e;
        }
    }

    public Socket createTunnelServerSocket(String targethost, Socket socket) throws IOException {
        SSLSocket s = (SSLSocket)this.getTunnelSSLSocketFactory(targethost).createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        s.setUseClientMode(false);
        s.startHandshake();
        return s;
    }

    public SSLSocketFactory getTunnelSSLSocketFactory(String hostname) {
        try {
            SSLContext ctx = SSLContext.getInstance(SSL);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            SslCertificateService scs = CachedSslCertifificateServiceImpl.getService();
            KeyStore ks = scs.createCertForHost(hostname);
            kmf.init(ks, SslCertificateService.PASSPHRASE);
            SecureRandom x = new SecureRandom();
            x.setSeed(System.currentTimeMillis());
            ctx.init(kmf.getKeyManagers(), null, x);
            SSLSocketFactory tunnelSSLFactory = SSLConnector.createDecoratedServerSslSocketFactory(ctx.getSocketFactory());
            return tunnelSSLFactory;
        }
        catch (IOException | InvalidKeyException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static SSLSocketFactory createDecoratedServerSslSocketFactory(SSLSocketFactory delegate) {
        return new DecoratedSocketsSslSocketFactory(delegate, serverSslSocketsDecorator);
    }

    private SSLSocketFactory createDecoratedClientSslSocketFactory(SSLSocketFactory delegate) {
        return new DecoratedSocketsSslSocketFactory(delegate, this.clientSslSocketsDecorator);
    }

    static {
        MAX_AGE_MISCONFIGURED_HOST_IN_MIN = 5L;
        MAX_AGE_MISCONFIGURED_HOST_IN_MS = TimeUnit.MINUTES.toMillis(MAX_AGE_MISCONFIGURED_HOST_IN_MIN);
        logger = Logger.getLogger(SSLConnector.class);
        sslContextManager = null;
    }

    private static class MisconfiguredHostCacheEntry {
        private final String host;
        private final int port;
        private final InetAddress address;
        private final long timeStampCreation;

        public MisconfiguredHostCacheEntry(String host, int port, InetAddress address) {
            this.host = host;
            this.port = port;
            this.address = address;
            this.timeStampCreation = System.currentTimeMillis();
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public boolean isStale(long currentTime) {
            return currentTime - this.timeStampCreation >= MAX_AGE_MISCONFIGURED_HOST_IN_MS;
        }
    }

    private class ClientSslSocketsDecorator
    implements DecoratedSocketsSslSocketFactory.SslSocketDecorator {
        private ClientSslSocketsDecorator() {
        }

        @Override
        public void decorate(SSLSocket sslSocket) {
            if (supportedProtocols == null) {
                SSLConnector.readSupportedProtocols(sslSocket);
            }
            sslSocket.setEnabledProtocols(SSLConnector.getClientEnabledProtocols());
            if (SSLConnector.this.relaxedTrust) {
                sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
            }
        }
    }

    private static class ServerSslSocketsDecorator
    implements DecoratedSocketsSslSocketFactory.SslSocketDecorator {
        private ServerSslSocketsDecorator() {
        }

        @Override
        public void decorate(SSLSocket sslSocket) {
            if (supportedProtocols == null) {
                SSLConnector.readSupportedProtocols(sslSocket);
            }
            sslSocket.setEnabledProtocols(SSLConnector.getServerEnabledProtocols());
        }
    }
}

