/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import org.parosproxy.paros.common.AbstractParam;

public class DatabaseParam
extends AbstractParam {
    public static final int NEW_SESSION_NOT_SPECIFIED = 0;
    public static final int NEW_SESSION_TIMESTAMPED = 1;
    public static final int NEW_SESSION_USER_SPECIFIED = 2;
    public static final int NEW_SESSION_TEMPORARY = 3;
    private static final String PARAM_BASE_KEY = "database";
    private static final String PARAM_COMPACT_DATABASE = "database.compact";
    private static final String PARAM_REQUEST_BODY_SIZE = "database.request.bodysize";
    private static final String PARAM_RESPONSE_BODY_SIZE = "database.response.bodysize";
    private static final String PARAM_NEW_SESSION_OPTION = "database.newsession";
    private static final String PARAM_NEW_SESSION_PROMPT = "database.newsessionprompt";
    private static final String PARAM_RECOVERY_LOG_ENABLED = "database.recoverylog";
    private boolean compactDatabase = false;
    private int requestbodysize = 0x1000000;
    private int responsebodysize = 0x1000000;
    private int newSessionOption = 0;
    private boolean newSessionPrompt = true;
    private boolean recoveryLogEnabled = true;

    @Override
    protected void parse() {
        this.compactDatabase = this.getConfig().getBoolean(PARAM_COMPACT_DATABASE, this.compactDatabase);
        this.requestbodysize = this.getConfig().getInt(PARAM_REQUEST_BODY_SIZE, this.requestbodysize);
        this.responsebodysize = this.getConfig().getInt(PARAM_RESPONSE_BODY_SIZE, this.responsebodysize);
        this.newSessionOption = this.getConfig().getInt(PARAM_NEW_SESSION_OPTION, this.newSessionOption);
        this.newSessionPrompt = this.getConfig().getBoolean(PARAM_NEW_SESSION_PROMPT, this.newSessionPrompt);
        this.recoveryLogEnabled = this.getConfig().getBoolean(PARAM_RECOVERY_LOG_ENABLED, this.recoveryLogEnabled);
    }

    public boolean isCompactDatabase() {
        return this.compactDatabase;
    }

    public void setCompactDatabase(boolean compactDatabase) {
        this.compactDatabase = compactDatabase;
        this.getConfig().setProperty(PARAM_COMPACT_DATABASE, (Object)compactDatabase);
    }

    public int getRequestBodySize() {
        return this.requestbodysize;
    }

    public void setRequestBodySize(int requestbodysize) {
        this.requestbodysize = requestbodysize;
        this.getConfig().setProperty(PARAM_REQUEST_BODY_SIZE, (Object)requestbodysize);
    }

    public int getResponseBodySize() {
        return this.responsebodysize;
    }

    public void setResponseBodySize(int responsebodysize) {
        this.responsebodysize = responsebodysize;
        this.getConfig().setProperty(PARAM_RESPONSE_BODY_SIZE, (Object)responsebodysize);
    }

    public int getNewSessionOption() {
        return this.newSessionOption;
    }

    public void setNewSessionOption(int newSessionOption) {
        this.newSessionOption = newSessionOption;
        this.getConfig().setProperty(PARAM_NEW_SESSION_OPTION, (Object)newSessionOption);
    }

    public boolean isNewSessionPrompt() {
        return this.newSessionPrompt;
    }

    public void setNewSessionPrompt(boolean newSessionPrompt) {
        this.newSessionPrompt = newSessionPrompt;
        this.getConfig().setProperty(PARAM_NEW_SESSION_PROMPT, (Object)newSessionPrompt);
    }

    public boolean isRecoveryLogEnabled() {
        return this.recoveryLogEnabled;
    }

    public void setRecoveryLogEnabled(boolean enabled) {
        this.recoveryLogEnabled = enabled;
        this.getConfig().setProperty(PARAM_RECOVERY_LOG_ENABLED, (Object)this.recoveryLogEnabled);
    }
}

