/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.AwsCandidateHarvester;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.CustomStreamsSocket;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.proxy.ProxyThreadSSL;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpUtil;
import org.parosproxy.paros.security.MissingRootCertificateException;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.network.HttpRequestBody;

public class ProxyThread
implements Runnable {
    private static final String CONNECT_HTTP_200 = "HTTP/1.1 200 Connection established\r\n\r\n";
    private static Logger log = Logger.getLogger(ProxyThread.class);
    private static final String BAD_GATEWAY_RESPONSE_STATUS = "502 Bad Gateway";
    private static final String GATEWAY_TIMEOUT_RESPONSE_STATUS = "504 Gateway Timeout";
    protected ProxyServer parentServer = null;
    protected ProxyParam proxyParam = null;
    protected ConnectionParam connectionParam = null;
    protected Thread thread = null;
    protected Socket inSocket = null;
    protected Socket outSocket = null;
    protected HttpInputStream httpIn = null;
    protected HttpOutputStream httpOut = null;
    protected ProxyThread originProcess = this;
    private HttpSender httpSender = null;
    private Object semaphore = this;
    private boolean keepSocketOpen = false;
    private static Object semaphoreSingleton = new Object();
    private static int id = 1;
    private static Vector<Thread> proxyThreadList = new Vector();
    private static AwsCandidateHarvester awsCandidateHarvester;

    protected ProxyThread(ProxyServer server, Socket socket) {
        this(server, socket, null);
    }

    protected ProxyThread(ProxyServer server, Socket socket, HttpSender httpSender) {
        this.parentServer = server;
        this.proxyParam = this.parentServer.getProxyParam();
        this.connectionParam = this.parentServer.getConnectionParam();
        this.httpSender = httpSender;
        this.inSocket = socket;
        try {
            this.inSocket.setTcpNoDelay(true);
            this.inSocket.setSoTimeout(this.connectionParam.getTimeoutInSecs() * 1000);
        }
        catch (SocketException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.thread = new Thread((Runnable)this, "ZAP-ProxyThread-" + id++);
        this.thread.setDaemon(true);
        this.thread.setPriority(4);
    }

    public void start() {
        this.thread.start();
    }

    private void beginSSL(String targethost) throws IOException {
        try {
            this.inSocket = HttpSender.getSSLConnector().createTunnelServerSocket(targethost, this.inSocket);
        }
        catch (MissingRootCertificateException e) {
            throw new MissingRootCertificateException(e);
        }
        catch (Exception e) {
            throw new IOException("Error while establishing SSL connection for '" + targethost + "'!", e);
        }
        this.httpIn = new HttpInputStream(this.inSocket);
        this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
    }

    private static boolean isSslTlsHandshake(byte[] bytes) {
        if (bytes.length < 3) {
            throw new IllegalArgumentException("The parameter bytes must have at least 3 bytes.");
        }
        return bytes[0] == 22 && (bytes[1] >= 3 || bytes[1] == 0 && bytes[2] == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            proxyThreadList.add(this.thread);
            boolean isSecure = this instanceof ProxyThreadSSL;
            HttpRequestHeader firstHeader = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inSocket.getInputStream(), 2048);
                this.inSocket = new CustomStreamsSocket(this.inSocket, bufferedInputStream, this.inSocket.getOutputStream());
                this.httpIn = new HttpInputStream(this.inSocket);
                this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
                firstHeader = this.httpIn.readRequestHeader(isSecure);
                firstHeader.setSenderAddress(this.inSocket.getInetAddress());
                if (firstHeader.getMethod().equalsIgnoreCase("CONNECT")) {
                    HttpMessage connectMsg = new HttpMessage(firstHeader);
                    connectMsg.setTimeSentMillis(System.currentTimeMillis());
                    try {
                        this.httpOut.write(CONNECT_HTTP_200);
                        this.httpOut.flush();
                        connectMsg.setResponseHeader(CONNECT_HTTP_200);
                        connectMsg.setTimeElapsedMillis((int)(System.currentTimeMillis() - connectMsg.getTimeSentMillis()));
                        this.notifyConnectMessage(connectMsg);
                        byte[] bytes = new byte[3];
                        bufferedInputStream.mark(3);
                        bufferedInputStream.read(bytes);
                        bufferedInputStream.reset();
                        if (ProxyThread.isSslTlsHandshake(bytes)) {
                            isSecure = true;
                            this.beginSSL(firstHeader.getHostName());
                        }
                        firstHeader = this.httpIn.readRequestHeader(isSecure);
                        firstHeader.setSenderAddress(this.inSocket.getInetAddress());
                        this.processHttp(firstHeader, isSecure);
                        break block21;
                    }
                    catch (MissingRootCertificateException e) {
                        HttpMessage errmsg = new HttpMessage(firstHeader);
                        ProxyThread.setErrorResponse(errmsg, BAD_GATEWAY_RESPONSE_STATUS, e, "ZAP SSL Error");
                        ProxyThread.writeHttpResponse(errmsg, this.httpOut);
                        throw new IOException(e);
                    }
                }
                this.processHttp(firstHeader, isSecure);
            }
            catch (SocketTimeoutException e) {
                if (firstHeader != null) {
                    if ("CONNECT".equalsIgnoreCase(firstHeader.getMethod())) {
                        log.warn((Object)("Timeout reading (client) message after CONNECT to " + firstHeader.getURI()));
                    } else {
                        log.warn((Object)("Timeout accessing " + firstHeader.getURI()));
                    }
                } else {
                    log.warn((Object)"Socket timeout while reading first message.");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e, (Throwable)e);
                    }
                }
            }
            catch (HttpMalformedHeaderException e) {
                log.warn((Object)"Malformed Header: ", (Throwable)e);
            }
            catch (HttpException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)"IOException: ", (Throwable)e);
            }
            finally {
                proxyThreadList.remove(this.thread);
                if (!this.keepSocketOpen) {
                    this.disconnect();
                }
            }
        }
    }

    private void notifyConnectMessage(HttpMessage connectMessage) {
        for (ConnectRequestProxyListener listener : this.parentServer.getConnectRequestProxyListeners()) {
            try {
                listener.receivedConnectRequest(connectMessage);
            }
            catch (Exception e) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)e);
            }
        }
    }

    private static void setErrorResponse(HttpMessage msg, String responseStatus, Exception cause) throws HttpMalformedHeaderException {
        ProxyThread.setErrorResponse(msg, responseStatus, cause, "ZAP Error");
    }

    private static void setErrorResponse(HttpMessage msg, String responseStatus, Exception cause, String errorType) throws HttpMalformedHeaderException {
        StringBuilder strBuilder = new StringBuilder();
        if (cause instanceof SSLException) {
            strBuilder.append(Constant.messages.getString("network.ssl.error.connect"));
            strBuilder.append(msg.getRequestHeader().getURI().toString()).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.exception")).append(cause.getMessage()).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.exception.rootcause")).append(ExceptionUtils.getRootCauseMessage((Throwable)cause)).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.help", Constant.messages.getString("network.ssl.error.help.url")));
            log.warn((Object)strBuilder.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)cause, (Throwable)cause);
                strBuilder.append("\n\nStack Trace:\n");
                for (String stackTraceFrame : ExceptionUtils.getRootCauseStackTrace((Throwable)cause)) {
                    strBuilder.append(stackTraceFrame).append('\n');
                }
            }
        } else {
            strBuilder.append(errorType).append(" [").append(cause.getClass().getName()).append("]: ").append(cause.getLocalizedMessage()).append("\n\nStack Trace:\n");
            for (String stackTraceFrame : ExceptionUtils.getRootCauseStackTrace((Throwable)cause)) {
                strBuilder.append(stackTraceFrame).append('\n');
            }
        }
        ProxyThread.setErrorResponse(msg, responseStatus, strBuilder.toString());
    }

    private static void setErrorResponse(HttpMessage msg, String responseStatus, String message) throws HttpMalformedHeaderException {
        HttpResponseHeader responseHeader = new HttpResponseHeader("HTTP/1.1 " + responseStatus);
        responseHeader.setHeader("Content-Type", "text/plain; charset=UTF-8");
        responseHeader.setHeader("Content-Length", Integer.toString(message.getBytes(StandardCharsets.UTF_8).length));
        msg.setResponseHeader(responseHeader);
        if (!"HEAD".equals(msg.getRequestHeader().getMethod())) {
            msg.setResponseBody(message);
        }
    }

    private static void writeHttpResponse(HttpMessage msg, HttpOutputStream outputStream) throws IOException {
        outputStream.write(msg.getResponseHeader());
        outputStream.flush();
        if (msg.getResponseBody().length() > 0) {
            outputStream.write(msg.getResponseBody().getBytes());
            outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHttp(HttpRequestHeader requestHeader, boolean isSecure) throws IOException {
        HttpRequestBody reqBody = null;
        boolean isFirstRequest = true;
        HttpMessage msg = null;
        this.inSocket.setSoTimeout(2500);
        do {
            if (isFirstRequest) {
                isFirstRequest = false;
            } else {
                try {
                    requestHeader = this.httpIn.readRequestHeader(isSecure);
                    requestHeader.setSenderAddress(this.inSocket.getInetAddress());
                }
                catch (SocketTimeoutException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Timed out while reading a new HTTP request.");
                    }
                    return;
                }
            }
            if (this.parentServer.isEnableApi() && API.getInstance().handleApiRequest(requestHeader, this.httpIn, this.httpOut, this.isRecursive(requestHeader))) {
                return;
            }
            msg = new HttpMessage();
            msg.setRequestHeader(requestHeader);
            if (msg.getRequestHeader().getContentLength() > 0) {
                reqBody = this.httpIn.readRequestBody(requestHeader);
                msg.setRequestBody(reqBody);
            }
            if (this.proxyParam.isRemoveUnsupportedEncodings()) {
                this.removeUnsupportedEncodings(msg);
            }
            if (this.isProcessCache(msg)) continue;
            this.semaphore = this.parentServer.isSerialize() ? semaphoreSingleton : this;
            boolean send = true;
            Object object = this.semaphore;
            synchronized (object) {
                if (this.notifyOverrideListenersRequestSend(msg)) {
                    send = false;
                } else if (!this.notifyListenerRequestSend(msg)) {
                    return;
                }
                try {
                    if (send) {
                        if (msg.getResponseHeader().isEmpty()) {
                            this.getHttpSender().sendAndReceive(msg);
                        }
                        this.decodeResponseIfNeeded(msg);
                        if (!this.notifyOverrideListenersResponseReceived(msg) && !this.notifyListenerResponseReceive(msg)) {
                            return;
                        }
                    }
                }
                catch (HttpException e) {
                    throw e;
                }
                catch (SocketTimeoutException e) {
                    String message = Constant.messages.getString("proxy.error.readtimeout", msg.getRequestHeader().getURI(), this.connectionParam.getTimeoutInSecs());
                    log.warn((Object)message);
                    ProxyThread.setErrorResponse(msg, GATEWAY_TIMEOUT_RESPONSE_STATUS, message);
                    this.notifyListenerResponseReceive(msg);
                }
                catch (IOException e) {
                    ProxyThread.setErrorResponse(msg, BAD_GATEWAY_RESPONSE_STATUS, e);
                    this.notifyListenerResponseReceive(msg);
                }
                try {
                    ProxyThread.writeHttpResponse(msg, this.httpOut);
                }
                catch (IOException e) {
                    StringBuilder strBuilder = new StringBuilder(200);
                    strBuilder.append("Failed to write/forward the HTTP response to the client: ");
                    strBuilder.append(e.getClass().getName());
                    if (e.getMessage() != null) {
                        strBuilder.append(": ").append(e.getMessage());
                    }
                    log.warn((Object)strBuilder.toString());
                }
            }
            ZapGetMethod method = (ZapGetMethod)((Object)msg.getUserObject());
            this.keepSocketOpen = this.notifyPersistentConnectionListener(msg, this.inSocket, method);
            if (this.keepSocketOpen) break;
        } while (!this.isConnectionClose(msg) && !this.inSocket.isClosed());
    }

    private FilterInputStream buildStreamDecoder(String encoding, ByteArrayInputStream bais) throws IOException {
        if (encoding.equalsIgnoreCase("deflate")) {
            return new InflaterInputStream(bais, new Inflater(true));
        }
        return new GZIPInputStream(bais);
    }

    private void decodeResponseIfNeeded(HttpMessage msg) {
        String encoding = msg.getResponseHeader().getHeader("Content-Encoding");
        if (this.proxyParam.isAlwaysDecodeGzip() && encoding != null && !encoding.equalsIgnoreCase("identity")) {
            encoding = Pattern.compile("^x-", 2).matcher(encoding).replaceAll("");
            if (!encoding.equalsIgnoreCase("deflate") && !encoding.equalsIgnoreCase("gzip")) {
                log.warn((Object)("Unsupported content encoding method: " + encoding));
                return;
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(msg.getResponseBody().getBytes());
                 FilterInputStream fis = this.buildStreamDecoder(encoding, bais);
                 BufferedInputStream bis = new BufferedInputStream(fis);
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int readLength;
                byte[] readBuffer = new byte[1024];
                while ((readLength = bis.read(readBuffer, 0, 1024)) != -1) {
                    out.write(readBuffer, 0, readLength);
                }
                msg.setResponseBody(out.toByteArray());
                msg.getResponseHeader().setHeader("Content-Encoding", null);
                if (msg.getResponseHeader().getHeader("Content-Length") != null) {
                    msg.getResponseHeader().setHeader("Content-Length", Integer.toString(out.size()));
                }
            }
            catch (IOException e) {
                log.error((Object)("Unable to uncompress gzip content: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private boolean isConnectionClose(HttpMessage msg) {
        if (msg == null || msg.getResponseHeader().isEmpty()) {
            return true;
        }
        if (msg.getRequestHeader().isConnectionClose()) {
            return true;
        }
        if (msg.getResponseHeader().isConnectionClose()) {
            return true;
        }
        return msg.getResponseHeader().getContentLength() == -1 && msg.getResponseBody().length() > 0;
    }

    protected void disconnect() {
        block8: {
            block7: {
                try {
                    if (this.httpIn != null) {
                        this.httpIn.close();
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                if (this.httpOut != null) {
                    this.httpOut.close();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        HttpUtil.closeSocket(this.inSocket);
        if (this.httpSender != null) {
            this.httpSender.shutdown();
        }
    }

    private boolean notifyListenerRequestSend(HttpMessage httpMessage) {
        if (this.parentServer.excludeUrl(httpMessage.getRequestHeader().getURI())) {
            return true;
        }
        ProxyListener listener = null;
        List<ProxyListener> listenerList = this.parentServer.getListenerList();
        for (int i = 0; i < listenerList.size(); ++i) {
            listener = listenerList.get(i);
            try {
                if (listener.onHttpRequestSend(httpMessage)) continue;
                return false;
            }
            catch (Exception e) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return true;
    }

    private boolean notifyListenerResponseReceive(HttpMessage httpMessage) {
        if (this.parentServer.excludeUrl(httpMessage.getRequestHeader().getURI())) {
            return true;
        }
        ProxyListener listener = null;
        List<ProxyListener> listenerList = this.parentServer.getListenerList();
        for (int i = 0; i < listenerList.size(); ++i) {
            listener = listenerList.get(i);
            try {
                if (listener.onHttpResponseReceive(httpMessage)) continue;
                return false;
            }
            catch (Exception e) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return true;
    }

    private boolean notifyOverrideListenersRequestSend(HttpMessage httpMessage) {
        for (OverrideMessageProxyListener listener : this.parentServer.getOverrideMessageProxyListeners()) {
            try {
                if (!listener.onHttpRequestSend(httpMessage)) continue;
                return true;
            }
            catch (Exception e) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return false;
    }

    private boolean notifyOverrideListenersResponseReceived(HttpMessage httpMessage) {
        for (OverrideMessageProxyListener listener : this.parentServer.getOverrideMessageProxyListeners()) {
            try {
                if (!listener.onHttpResponseReceived(httpMessage)) continue;
                return true;
            }
            catch (Exception e) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return false;
    }

    private boolean notifyPersistentConnectionListener(HttpMessage httpMessage, Socket inSocket, ZapGetMethod method) {
        boolean keepSocketOpen = false;
        PersistentConnectionListener listener = null;
        List<PersistentConnectionListener> listenerList = this.parentServer.getPersistentConnectionListenerList();
        for (int i = 0; i < listenerList.size(); ++i) {
            listener = listenerList.get(i);
            try {
                if (!listener.onHandshakeResponse(httpMessage, inSocket, method)) continue;
                keepSocketOpen = true;
                break;
            }
            catch (Exception e) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)e);
            }
        }
        return keepSocketOpen;
    }

    private boolean isRecursive(HttpRequestHeader header) {
        try {
            if (header.getHostPort() == this.inSocket.getLocalPort()) {
                String targetDomain = header.getHostName();
                if (API.API_DOMAIN.equals(targetDomain)) {
                    return true;
                }
                if (this.isProxyAddress(InetAddress.getByName(targetDomain))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean isProxyAddress(InetAddress address) {
        return this.parentServer.getProxyParam().isProxyIpAnyLocalAddress() ? ProxyThread.isLocalAddress(address) || ProxyThread.isNetworkInterfaceAddress(address) || this.isOwnPublicAddress(address) : address.equals(this.inSocket.getLocalAddress());
    }

    private static boolean isLocalAddress(InetAddress address) {
        return address.isLoopbackAddress() || address.isSiteLocalAddress() || address.isAnyLocalAddress();
    }

    private static boolean isNetworkInterfaceAddress(InetAddress address) {
        try {
            if (NetworkInterface.getByInetAddress(address) != null) {
                return true;
            }
        }
        catch (SocketException e) {
            log.warn((Object)"Failed to check if an address is from a network interface:", (Throwable)e);
        }
        return false;
    }

    private boolean isOwnPublicAddress(InetAddress address) {
        if (!this.proxyParam.isBehindNat()) {
            return false;
        }
        TransportAddress publicAddress = ProxyThread.getAwsCandidateHarvester().getMask();
        if (publicAddress == null) {
            return false;
        }
        return Arrays.equals(address.getAddress(), publicAddress.getAddress().getAddress());
    }

    private static AwsCandidateHarvester getAwsCandidateHarvester() {
        if (awsCandidateHarvester == null) {
            ProxyThread.createAwsCandidateHarvester();
        }
        return awsCandidateHarvester;
    }

    private static synchronized void createAwsCandidateHarvester() {
        if (awsCandidateHarvester == null) {
            awsCandidateHarvester = new AwsCandidateHarvester();
        }
    }

    private void removeUnsupportedEncodings(HttpMessage msg) {
        String encoding = msg.getRequestHeader().getHeader("Accept-Encoding");
        if (encoding == null) {
            return;
        }
        msg.getRequestHeader().setHeader("Accept-Encoding", null);
    }

    protected HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(this.connectionParam, true, 1);
        }
        return this.httpSender;
    }

    static boolean isAnyProxyThreadRunning() {
        return !proxyThreadList.isEmpty();
    }

    protected boolean isProcessCache(HttpMessage msg) throws IOException {
        if (!this.parentServer.isEnableCacheProcessing()) {
            return false;
        }
        if (this.parentServer.getCacheProcessingList().isEmpty()) {
            return false;
        }
        CacheProcessingItem item = this.parentServer.getCacheProcessingList().get(0);
        if (msg.equals(item.message)) {
            HttpMessage newMsg = item.message.cloneAll();
            msg.setResponseHeader(newMsg.getResponseHeader());
            msg.setResponseBody(newMsg.getResponseBody());
            ProxyThread.writeHttpResponse(msg, this.httpOut);
            return true;
        }
        try {
            RecordHistory history = Model.getSingleton().getDb().getTableHistory().getHistoryCache(item.reference, msg);
            if (history == null) {
                return false;
            }
            msg.setResponseHeader(history.getHttpMessage().getResponseHeader());
            msg.setResponseBody(history.getHttpMessage().getResponseBody());
            ProxyThread.writeHttpResponse(msg, this.httpOut);
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }
}

