/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang.ArrayUtils;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.users.User;

class UsersListModel
extends AbstractListModel<User>
implements ComboBoxModel<User> {
    private static final long serialVersionUID = 5648260449088479312L;
    private User selectedItem;
    private UsersTableModel tableModel;
    private User[] customUsers;

    UsersListModel(UsersTableModel tableModel) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(new TableModelListenerImpl());
    }

    @Override
    public User getElementAt(int index) {
        if (index < this.tableModel.getRowCount()) {
            return (User)this.tableModel.getElement(index);
        }
        if (this.customUsers != null) {
            return this.customUsers[index - this.tableModel.getRowCount()];
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.tableModel.getUsers().size() + (this.customUsers == null ? 0 : this.customUsers.length);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (anItem == null) {
            if (this.selectedItem == null) {
                return;
            }
            this.setSelectedItemImpl(null);
            return;
        }
        if (!(anItem instanceof User)) {
            return;
        }
        if (this.selectedItem != null && this.selectedItem.equals(anItem)) {
            return;
        }
        if (this.getIndexOf(anItem) == -1) {
            return;
        }
        this.setSelectedItemImpl((User)anItem);
    }

    private void setSelectedItemImpl(User user) {
        this.selectedItem = user;
        this.fireContentsChanged(this, -1, -1);
    }

    public void setSelectedInternalItem(User user) {
        User internalUser = null;
        int index = this.getIndexOf(user);
        if (index != -1) {
            internalUser = this.getElementAt(index);
        } else if (this.getSize() > 0) {
            internalUser = this.getElementAt(0);
        }
        this.setSelectedItemImpl(internalUser);
    }

    public int getIndexOf(Object object) {
        int index = this.tableModel.getUsers().indexOf(object);
        if (index < 0 && this.customUsers != null) {
            return this.tableModel.getUsers().size() + ArrayUtils.indexOf((Object[])this.customUsers, (Object)object);
        }
        return index;
    }

    public void setCustomUsers(User[] users) {
        User[] oldCustomUsers = this.customUsers;
        int tableUsersSize = this.tableModel.getUsers().size();
        this.customUsers = users;
        if (oldCustomUsers == null || oldCustomUsers.length == 0) {
            if (users != null && users.length != 0) {
                this.fireIntervalAdded(this, tableUsersSize, tableUsersSize + this.customUsers.length - 1);
            }
        } else if (users == null || users.length == 0) {
            this.fireIntervalRemoved(this, tableUsersSize, tableUsersSize + oldCustomUsers.length - 1);
        } else {
            this.fireContentsChanged(this, tableUsersSize, tableUsersSize + Math.max(this.customUsers.length, oldCustomUsers.length) - 1);
        }
    }

    private class TableModelListenerImpl
    implements TableModelListener {
        private TableModelListenerImpl() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            switch (e.getType()) {
                case 1: {
                    if (UsersListModel.this.selectedItem == null) {
                        this.selectFirstUser();
                    }
                    UsersListModel.this.fireIntervalAdded(this, e.getFirstRow(), e.getLastRow());
                    break;
                }
                case 0: {
                    if (UsersListModel.this.selectedItem != null) {
                        int idx = UsersListModel.this.getIndexOf(UsersListModel.this.selectedItem);
                        if (idx == -1) {
                            this.selectionFallback();
                        } else {
                            User user = UsersListModel.this.getElementAt(idx);
                            if (user != UsersListModel.this.selectedItem) {
                                UsersListModel.this.setSelectedItemImpl(user);
                            }
                        }
                    } else {
                        this.selectionFallback();
                    }
                    UsersListModel.this.fireContentsChanged(this, e.getFirstRow(), e.getLastRow());
                    break;
                }
                case -1: {
                    if (UsersListModel.this.selectedItem != null && UsersListModel.this.getIndexOf(UsersListModel.this.selectedItem) == -1) {
                        this.selectionFallback();
                    }
                    UsersListModel.this.fireIntervalRemoved(this, e.getFirstRow(), e.getLastRow());
                    break;
                }
            }
        }

        private void selectFirstUser() {
            UsersListModel.this.setSelectedItemImpl(UsersListModel.this.getElementAt(0));
        }

        private void selectionFallback() {
            if (UsersListModel.this.getSize() != 0) {
                this.selectFirstUser();
            } else if (UsersListModel.this.selectedItem != null) {
                UsersListModel.this.setSelectedItemImpl(null);
            }
        }
    }
}

