/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.PagingTableModel;
import org.zaproxy.zap.view.ZapTable;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSelectableHistoryReferencesContainer;
import org.zaproxy.zap.view.renderer.DateFormatStringValue;
import org.zaproxy.zap.view.renderer.SizeBytesStringValue;
import org.zaproxy.zap.view.renderer.TimeDurationStringValue;
import org.zaproxy.zap.view.table.AlertRiskTableCellItem;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;
import org.zaproxy.zap.view.table.decorator.AlertRiskTableCellItemIconHighlighter;
import org.zaproxy.zap.view.table.decorator.NoteTableCellItemIconHighlighter;

public class HistoryReferencesTable
extends ZapTable {
    private static final long serialVersionUID = -6988769961088738602L;
    private static final Logger LOGGER = Logger.getLogger(HistoryReferencesTable.class);
    private static final HistoryReferencesTableColumnFactory DEFAULT_COLUMN_FACTORY = new HistoryReferencesTableColumnFactory();
    private static final int MAXIMUM_ROWS_FOR_TABLE_CONFIG = 75;
    private int maximumRowsForTableConfig = 75;

    public HistoryReferencesTable() {
        this(new DefaultHistoryReferencesTableModel());
    }

    public HistoryReferencesTable(HistoryReferencesTableModel.Column[] columns) {
        this(new DefaultHistoryReferencesTableModel(columns));
    }

    public HistoryReferencesTable(HistoryReferencesTableModel<?> model) {
        this(model, true);
    }

    public HistoryReferencesTable(HistoryReferencesTableModel<?> model, boolean useDefaultSelectionListener) {
        super(model);
        this.setName("GenericHistoryReferenceTable");
        this.installColumnFactory();
        this.setSelectionMode(2);
        this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        if (useDefaultSelectionListener) {
            this.getSelectionModel().addListSelectionListener(new DisplayMessageOnSelectionValueChange());
        }
        this.setComponentPopupMenu(new CustomPopupMenu());
    }

    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.setDefaultRenderer(Date.class, (TableCellRenderer)new DefaultTableRenderer((StringValue)new DateFormatStringValue()));
    }

    protected void installColumnFactory() {
        this.setColumnFactory(DEFAULT_COLUMN_FACTORY);
        this.createDefaultColumnsFromModel();
        this.initializeColumnWidths();
    }

    protected void displayMessage(HttpMessage msg) {
        View.getSingleton().displayMessage(msg);
    }

    public HistoryReference getSelectedHistoryReference() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            return this.getHistoryReferenceAtViewRow(selectedRow);
        }
        return null;
    }

    public List<HistoryReference> getSelectedHistoryReferences() {
        int[] rows = this.getSelectedRows();
        if (rows.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<HistoryReference> hrefList = new ArrayList<HistoryReference>(rows.length);
        for (int row : rows) {
            HistoryReference hRef = this.getHistoryReferenceAtViewRow(row);
            if (hRef == null) continue;
            hrefList.add(hRef);
        }
        return hrefList;
    }

    protected HistoryReference getHistoryReferenceAtViewRow(int row) {
        Object entry = this.getModel().getEntry(this.convertRowIndexToModel(row));
        if (entry != null) {
            return entry.getHistoryReference();
        }
        return null;
    }

    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof HistoryReferencesTableModel)) {
            throw new IllegalArgumentException("Parameter dataModel must be a subclass of HistoryReferencesTableModel.");
        }
        if (dataModel instanceof PagingTableModel) {
            this.setMaximumRowsForTableConfiguration(((PagingTableModel)dataModel).getMaxPageSize());
        }
        super.setModel(dataModel);
    }

    public HistoryReferencesTableModel<?> getModel() {
        return (HistoryReferencesTableModel)super.getModel();
    }

    public void setMaximumRowsForTableConfiguration(int maximumRows) {
        this.maximumRowsForTableConfig = maximumRows;
    }

    public int getMaximumRowsForTableConfiguration() {
        return this.maximumRowsForTableConfig;
    }

    public void selectHistoryReference(int historyReferenceId) {
        int modelRowIndex = this.getModel().getEntryRowIndex(historyReferenceId);
        if (modelRowIndex > -1) {
            int viewRowIndex = this.convertRowIndexToView(modelRowIndex);
            this.getSelectionModel().setSelectionInterval(viewRowIndex, viewRowIndex);
            this.scrollRowToVisible(viewRowIndex);
        }
    }

    protected static class HistoryReferencesTableColumnFactory
    extends ColumnFactory {
        protected int getRowCount(JXTable table) {
            int rowCount = super.getRowCount(table);
            int maxRowCount = ((HistoryReferencesTable)table).getMaximumRowsForTableConfiguration();
            if (maxRowCount > 0 && rowCount > maxRowCount) {
                return maxRowCount;
            }
            return rowCount;
        }

        public void configureTableColumn(TableModel model, TableColumnExt columnExt) {
            int noteColumnIndex;
            int rttColumnIndex;
            super.configureTableColumn(model, columnExt);
            HistoryReferencesTableModel hRefModel = (HistoryReferencesTableModel)model;
            columnExt.setPrototypeValue(hRefModel.getPrototypeValue(columnExt.getModelIndex()));
            int highestAlertColumnIndex = hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.HIGHEST_ALERT);
            if (highestAlertColumnIndex != -1 && columnExt.getModelIndex() == highestAlertColumnIndex && model.getColumnClass(highestAlertColumnIndex) == AlertRiskTableCellItem.class) {
                columnExt.setHighlighters(new Highlighter[]{new AlertRiskTableCellItemIconHighlighter(highestAlertColumnIndex)});
            }
            if ((rttColumnIndex = hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.RTT)) != -1 && columnExt.getModelIndex() == rttColumnIndex && TimeDurationStringValue.isTargetClass(model.getColumnClass(rttColumnIndex))) {
                columnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new TimeDurationStringValue()));
            }
            if ((noteColumnIndex = hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.NOTE)) != -1 && columnExt.getModelIndex() == noteColumnIndex && model.getColumnClass(noteColumnIndex) == Boolean.class) {
                columnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
                columnExt.setHighlighters(new Highlighter[]{new NoteTableCellItemIconHighlighter(noteColumnIndex)});
            }
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_MESSAGE), model);
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER), model);
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY), model);
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER), model);
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY), model);
        }

        private void installSizeBytesRenderer(TableColumnExt columnExt, int columnIndex, TableModel model) {
            if (columnIndex != -1 && columnExt.getModelIndex() == columnIndex && SizeBytesStringValue.isTargetClass(model.getColumnClass(columnIndex))) {
                columnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new SizeBytesStringValue()));
            }
        }
    }

    protected class CustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected CustomPopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            DefaultSelectableHistoryReferencesContainer messageContainer = new DefaultSelectableHistoryReferencesContainer(HistoryReferencesTable.this.getName(), (Component)((Object)HistoryReferencesTable.this), Collections.emptyList(), this.getSelectedHistoryReferences());
            View.getSingleton().getPopupMenu().show(messageContainer, x, y);
        }

        protected List<HistoryReference> getSelectedHistoryReferences() {
            return HistoryReferencesTable.this.getSelectedHistoryReferences();
        }
    }

    protected class DisplayMessageOnSelectionValueChange
    implements ListSelectionListener {
        protected DisplayMessageOnSelectionValueChange() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                HistoryReference hRef = HistoryReferencesTable.this.getSelectedHistoryReference();
                if (hRef == null) {
                    return;
                }
                boolean focusOwner = HistoryReferencesTable.this.isFocusOwner();
                try {
                    HistoryReferencesTable.this.displayMessage(hRef.getHttpMessage());
                }
                catch (DatabaseException | HttpMalformedHeaderException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    if (focusOwner) {
                        HistoryReferencesTable.this.requestFocusInWindow();
                    }
                }
            }
        }
    }
}

