/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.StickyScrollbarAdjustmentListener;

public class ZapTable
extends JXTable {
    private static final long serialVersionUID = 8303870012122236918L;
    private boolean autoScroll;
    private AutoScrollAction autoScrollAction;
    private StickyScrollbarAdjustmentListener autoScrollScrollbarAdjustmentListener;

    public ZapTable() {
        this.init();
    }

    public ZapTable(TableModel dataModel) {
        super(dataModel);
        this.init();
    }

    private void init() {
        this.setDoubleBuffered(true);
        this.setColumnControlVisible(true);
        JComponent columnControl = this.getColumnControl();
        if (columnControl instanceof ZapColumnControlButton) {
            ZapColumnControlButton zapColumnControl = (ZapColumnControlButton)((Object)columnControl);
            zapColumnControl.addAction((Action)((Object)this.getAutoScrollAction()));
            zapColumnControl.populatePopup();
        }
        this.setAutoScrollOnNewValues(true);
    }

    protected AutoScrollAction getAutoScrollAction() {
        if (this.autoScrollAction == null) {
            this.autoScrollAction = new AutoScrollAction(this);
        }
        return this.autoScrollAction;
    }

    public void setAutoScrollOnNewValues(boolean autoScroll) {
        if (this.autoScroll == autoScroll) {
            return;
        }
        if (this.autoScroll) {
            this.removeAutoScrollScrollbarAdjustmentListener();
        }
        this.autoScroll = autoScroll;
        if (this.autoScrollAction != null) {
            this.autoScrollAction.putValue("SwingSelectedKey", autoScroll);
        }
        if (this.autoScroll) {
            this.addAutoScrollScrollbarAdjustmentListener();
        }
    }

    public boolean isAutoScrollOnNewValues() {
        return this.autoScroll;
    }

    private void addAutoScrollScrollbarAdjustmentListener() {
        JScrollPane scrollPane = this.getEnclosingScrollPane();
        if (scrollPane != null && this.autoScrollScrollbarAdjustmentListener == null) {
            this.autoScrollScrollbarAdjustmentListener = new StickyScrollbarAdjustmentListener();
            scrollPane.getVerticalScrollBar().addAdjustmentListener(this.autoScrollScrollbarAdjustmentListener);
        }
    }

    private void removeAutoScrollScrollbarAdjustmentListener() {
        JScrollPane scrollPane = this.getEnclosingScrollPane();
        if (scrollPane != null && this.autoScrollScrollbarAdjustmentListener != null) {
            scrollPane.getVerticalScrollBar().removeAdjustmentListener(this.autoScrollScrollbarAdjustmentListener);
            this.autoScrollScrollbarAdjustmentListener = null;
        }
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        if (this.isAutoScrollOnNewValues()) {
            this.addAutoScrollScrollbarAdjustmentListener();
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        super.unconfigureEnclosingScrollPane();
        if (this.isAutoScrollOnNewValues()) {
            this.removeAutoScrollScrollbarAdjustmentListener();
        }
    }

    protected JScrollPane getEnclosingScrollPane() {
        Container gp;
        Container p = SwingUtilities.getUnwrappedParent((Component)((Object)this));
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || SwingUtilities.getUnwrappedView(viewport) != this) {
                return null;
            }
            return scrollPane;
        }
        return null;
    }

    public Point getPopupLocation(MouseEvent event) {
        if (event != null) {
            int row = this.rowAtPoint(event.getPoint());
            if (row < 0) {
                this.getSelectionModel().clearSelection();
            } else if (!this.getSelectionModel().isSelectedIndex(row)) {
                this.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        return super.getPopupLocation(event);
    }

    protected JComponent createDefaultColumnControl() {
        return new ZapColumnControlButton(this);
    }

    protected static class AutoScrollAction
    extends AbstractActionExt {
        private static final long serialVersionUID = 5518182106427836717L;
        private final ZapTable table;

        public AutoScrollAction(ZapTable table) {
            super(Constant.messages.getString("view.table.autoscroll.label"));
            this.putValue("ShortDescription", Constant.messages.getString("view.table.autoscroll.tooltip"));
            this.table = table;
        }

        public AutoScrollAction(String label, Icon icon, ZapTable table) {
            super(label, icon);
            this.table = table;
        }

        public boolean isStateAction() {
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            this.table.setAutoScrollOnNewValues(!this.table.isAutoScrollOnNewValues());
        }
    }

    protected static class ZapColumnControlButton
    extends ColumnControlButton {
        private static final long serialVersionUID = -2888568545235496369L;
        private List<Action> customActions;

        public ZapColumnControlButton(JXTable table) {
            super(table);
        }

        public ZapColumnControlButton(JXTable table, Icon icon) {
            super(table, icon);
        }

        protected void populatePopup() {
            super.populatePopup();
            if (this.customActions != null && this.popup instanceof ColumnControlButton.DefaultColumnControlPopup) {
                ((ColumnControlButton.DefaultColumnControlPopup)this.popup).addAdditionalActionItems(this.customActions);
            }
        }

        public void addAction(Action action) {
            if (this.customActions == null) {
                this.customActions = new ArrayList<Action>(1);
            }
            this.customActions.add(action);
        }
    }
}

